/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.predicate.AbstractResourcePredicate;
import com.day.cq.commons.predicates.ResourcePredicate;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.commons.ReferenceSearch;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceSearchV2 {
    private static final Logger log = LoggerFactory.getLogger(ReferenceSearchV2.class);
    private String searchRoot = "/content";
    private boolean exact = false;
    private boolean hollow = false;
    private int maxReferencesPerPage = -1;
    private ResourcePredicate resourcePredicate = null;
    private AbstractResourcePredicate oldResourcePredicate = null;
    private ToggleRouter toggleRouter = this.getToggleRouter();
    static final String DEFAULT_SITES_INDEX_TAG = "wcmReferenceSearch";
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_START_OFFSET = 0;

    BundleContext getBundleContext() {
        BundleContext bundleContext = null;
        try {
            bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        }
        catch (Exception e) {
            log.warn("Could not get bundle context.", e);
        }
        return bundleContext;
    }

    private ToggleRouter getToggleRouter() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            log.warn("BundleContext is null, cannot get ToggleRouter service.");
            return null;
        }
        ServiceReference ref = bundleContext.getServiceReference(ToggleRouter.class);
        if (ref != null) {
            return (ToggleRouter)bundleContext.getService(ref);
        }
        log.warn("Could not get service reference for ToggleRouter.");
        return null;
    }

    public String getSearchRoot() {
        return this.searchRoot;
    }

    public ReferenceSearchV2 setSearchRoot(String searchRoot) {
        this.searchRoot = searchRoot == null || searchRoot.isEmpty() ? "/" : searchRoot;
        return this;
    }

    public boolean isExact() {
        return this.exact;
    }

    public ReferenceSearchV2 setExact(boolean exact) {
        this.exact = exact;
        return this;
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public ReferenceSearchV2 setHollow(boolean hollow) {
        this.hollow = hollow;
        return this;
    }

    public int getMaxReferencesPerPage() {
        return this.maxReferencesPerPage;
    }

    public ReferenceSearchV2 setMaxReferencesPerPage(int maxReferencesPerPage) {
        this.maxReferencesPerPage = maxReferencesPerPage;
        return this;
    }

    public ReferenceSearchV2 setPredicate(ResourcePredicate resourcePredicate) {
        this.resourcePredicate = resourcePredicate;
        return this;
    }

    @Deprecated
    public ReferenceSearchV2 setPredicate(AbstractResourcePredicate resourcePredicate) {
        this.oldResourcePredicate = resourcePredicate;
        return this;
    }

    private String escapePathUsingUpperCaseHex(String string) {
        try {
            BitSet validChars = Text.URISaveEx;
            int escape = 37;
            char[] hexTable = "0123456789ABCDEF".toCharArray();
            byte[] bytes = string.getBytes("utf-8");
            StringBuilder out = new StringBuilder(bytes.length);
            for (byte aByte : bytes) {
                int c = aByte & 0xFF;
                if (validChars.get(c) && c != escape) {
                    out.append((char)c);
                    continue;
                }
                out.append((char)escape);
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
    }

    protected Pattern getSearchPattern(String path) {
        if (this.exact) {
            return Pattern.compile("([\"']|^)(" + Pattern.quote(path) + ")([;.?#\"']|$)");
        }
        return Pattern.compile("([\"']|^)(" + Pattern.quote(path) + ")([;.?#\"'/](.*)|$)");
    }

    private boolean isPatternMatched(List<Pattern> patternList, String value) {
        if (value == null || patternList == null) {
            return false;
        }
        for (Pattern pattern : patternList) {
            if (!pattern.matcher(value).find()) continue;
            return true;
        }
        return false;
    }

    private void filterResultset(Map<String, ReferenceSearch.Info> infos) {
        if (infos == null) {
            return;
        }
        Iterator<Map.Entry<String, ReferenceSearch.Info>> entries = infos.entrySet().iterator();
        while (entries.hasNext()) {
            Resource pageResource;
            Map.Entry<String, ReferenceSearch.Info> entry = entries.next();
            if (entry.getValue().getProperties().isEmpty()) {
                entries.remove();
                continue;
            }
            if (this.resourcePredicate == null && this.oldResourcePredicate == null || entry.getValue().page == null || (pageResource = entry.getValue().page.adaptTo(Resource.class)) == null) continue;
            boolean removed = false;
            if (this.resourcePredicate != null && !this.resourcePredicate.test(pageResource)) {
                entries.remove();
                removed = true;
            }
            if (removed || this.oldResourcePredicate == null || this.oldResourcePredicate.evaluate(pageResource)) continue;
            entries.remove();
        }
    }

    private String escapeSql2SearchTerm(String term) {
        if (term == null) {
            return "";
        }
        return term.replace("'", "''");
    }

    private void prepareSqlSearchTerms(List<String> searchTerms, String path) {
        if (path == null || path.trim().isEmpty()) {
            return;
        }
        searchTerms.add(path);
        String escPath = Text.escapePath(path);
        if (!escPath.equals(path)) {
            searchTerms.add(escPath);
            String escPathUpper = this.escapePathUsingUpperCaseHex(path);
            searchTerms.add(escPathUpper);
            if (escPathUpper.contains("%26")) {
                searchTerms.add(escPathUpper.replaceAll("%26", "&amp;"));
            }
        }
    }

    private Iterator<Resource> executeSql2Query(ResourceResolver resolver, String selectClause, String fromClause, String whereBaseClause, List<String> searchTerms, int offset, int limit) {
        return this.executeSql2Query(resolver, selectClause, fromClause, whereBaseClause, searchTerms, offset, limit, null);
    }

    private Iterator<Resource> executeSql2Query(ResourceResolver resolver, String selectClause, String fromClause, String whereBaseClause, List<String> searchTerms, int offset, int limit, String orderBy) {
        int currentOffset;
        String containsClauses;
        if (searchTerms == null || searchTerms.isEmpty()) {
            return Collections.emptyIterator();
        }
        StringBuilder sql2Query = new StringBuilder();
        sql2Query.append(selectClause).append(" FROM ").append(fromClause);
        String actualSearchRoot = this.searchRoot == null || this.searchRoot.equals("/") ? "" : this.searchRoot;
        String nodeAlias = fromClause.contains(" AS ") ? fromClause.substring(fromClause.lastIndexOf(" AS ") + 4).trim() : fromClause.substring(fromClause.indexOf(91) + 1, fromClause.indexOf(93)).trim();
        ArrayList<String> whereConditions = new ArrayList<String>();
        if (!actualSearchRoot.isEmpty()) {
            whereConditions.add(String.format("ISDESCENDANTNODE(%s, '%s')", nodeAlias, this.escapeSql2SearchTerm(actualSearchRoot)));
        }
        if (whereBaseClause != null && !whereBaseClause.trim().isEmpty()) {
            whereConditions.add(whereBaseClause);
        }
        if (!(containsClauses = searchTerms.stream().map(term -> String.format("CONTAINS(%s.*, '\"%s\"')", nodeAlias, this.escapeSql2SearchTerm((String)term))).collect(Collectors.joining(" OR "))).isEmpty()) {
            whereConditions.add("(" + containsClauses + ")");
        }
        if (!whereConditions.isEmpty()) {
            sql2Query.append(" WHERE ").append(String.join((CharSequence)" AND ", whereConditions));
        }
        if (orderBy != null && !orderBy.trim().isEmpty()) {
            sql2Query.append(" ORDER BY ").append(orderBy);
        }
        StringBuilder optionClause = new StringBuilder();
        optionClause.append(" OPTION (index tag ").append(DEFAULT_SITES_INDEX_TAG);
        int n = currentOffset = offset < 0 ? 0 : offset;
        if (currentOffset > 0) {
            optionClause.append(", OFFSET ").append(currentOffset);
        }
        if (limit > 0) {
            optionClause.append(", LIMIT ").append(limit);
        }
        optionClause.append(")");
        sql2Query.append((CharSequence)optionClause);
        log.debug("Executing SQL2 query: {}", (Object)sql2Query.toString());
        try {
            return resolver.findResources(sql2Query.toString(), "JCR-SQL2");
        }
        catch (RuntimeException e) {
            log.error("Failed to execute SQL2 query for search terms: {}. Query: {}. Error: {}", searchTerms, sql2Query.toString(), e.getMessage(), e);
            log.debug("Query execution failed with searchRoot: '{}', searchTerms: {}, offset: {}, limit: {}", actualSearchRoot, searchTerms, offset, limit);
            if (e instanceof IllegalStateException || e instanceof IllegalArgumentException) {
                throw e;
            }
            return Collections.emptyIterator();
        }
        catch (Exception e) {
            log.error("Unexpected error while executing SQL2 query: {}. This may indicate a system issue.", (Object)sql2Query.toString(), (Object)e);
            return Collections.emptyIterator();
        }
    }

    private void processFoundResourcesForInfo(Iterator<Resource> iter, PageManager manager, Map<String, ReferenceSearch.Info> infos, String originalPathForPattern) {
        if (iter == null || manager == null || infos == null || originalPathForPattern == null) {
            return;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(this.getSearchPattern(originalPathForPattern));
        String escPath = Text.escapePath(originalPathForPattern);
        if (!escPath.equals(originalPathForPattern)) {
            patterns.add(this.getSearchPattern(escPath));
            String escPathUpper = this.escapePathUsingUpperCaseHex(originalPathForPattern);
            patterns.add(this.getSearchPattern(escPathUpper));
            if (escPathUpper.contains("%26")) {
                patterns.add(this.getSearchPattern(escPathUpper.replaceAll("%26", "&amp;")));
            }
        }
        log.debug("Processing resources to find property matches using patterns for original path: {}", (Object)originalPathForPattern);
        while (iter.hasNext()) {
            Page page;
            Resource res = iter.next();
            if (res == null || (page = manager.getContainingPage(res)) == null) continue;
            ReferenceSearch.Info info = infos.get(page.getPath());
            if (info == null) {
                info = new ReferenceSearch.Info(page, this.hollow);
                infos.put(page.getPath(), info);
            }
            if (this.getMaxReferencesPerPage() >= 0 && info.getProperties().size() >= this.getMaxReferencesPerPage()) continue;
            try {
                Node node = res.adaptTo(Node.class);
                if (node == null) {
                    log.debug("Resource {} could not be adapted to Node.", (Object)res.getPath());
                    continue;
                }
                PropertyIterator pIter = node.getProperties();
                block3: while (pIter.hasNext() && (this.getMaxReferencesPerPage() < 0 || info.getProperties().size() < this.getMaxReferencesPerPage())) {
                    Property p = pIter.nextProperty();
                    if (p.getType() != 1 && p.getType() != 7) continue;
                    if (p.isMultiple()) {
                        for (Value v : p.getValues()) {
                            String value = v.getString();
                            if (!this.isPatternMatched(patterns, value)) continue;
                            info.addProperty(p.getPath());
                            continue block3;
                        }
                        continue;
                    }
                    String value = p.getString();
                    if (!this.isPatternMatched(patterns, value)) continue;
                    info.addProperty(p.getPath());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while accessing properties of " + res.getPath(), e);
            }
        }
    }

    public Map<String, ReferenceSearch.Info> search(ResourceResolver resolver, String path) {
        return this.search(resolver, path, 0, -1);
    }

    public Map<String, ReferenceSearch.Info> search(ResourceResolver resolver, String path, int limit, int offset) {
        if (path == null || resolver == null) {
            log.debug("Resolver or path is null. Path: {}, Resolver: {}", (Object)path, (Object)resolver);
            return Collections.emptyMap();
        }
        PageManager manager = resolver.adaptTo(PageManager.class);
        if (manager == null) {
            log.error("Could not adapt ResourceResolver to PageManager.");
            return Collections.emptyMap();
        }
        HashMap<String, ReferenceSearch.Info> infos = new HashMap<String, ReferenceSearch.Info>();
        ArrayList<String> searchTerms = new ArrayList<String>();
        this.prepareSqlSearchTerms(searchTerms, path);
        if (searchTerms.isEmpty()) {
            return Collections.emptyMap();
        }
        Iterator<Resource> resources = this.executeSql2Query(resolver, "SELECT s.*", "[nt:base] AS s", null, searchTerms, offset, limit);
        this.processFoundResourcesForInfo(resources, manager, infos, path);
        this.filterResultset(infos);
        return infos;
    }

    public List<Page> findPageReferencesForResource(ResourceResolver resolver, String path, int limit, int offset) {
        Iterator<Resource> pageResources = this.findPageResources(resolver, path, limit, offset, null);
        return this.processPageResources(pageResources, resolver).getLeft();
    }

    private Pair<List<Page>, String> processPageResources(Iterator<Resource> pageResources, ResourceResolver resolver) {
        if (pageResources == null || resolver == null) {
            return Pair.of(Collections.emptyList(), null);
        }
        PageManager manager = resolver.adaptTo(PageManager.class);
        if (manager == null) {
            log.error("Could not adapt ResourceResolver to PageManager.");
            return Pair.of(Collections.emptyList(), null);
        }
        ArrayList<Page> pageReferences = new ArrayList<Page>();
        String lastReferencePath = "";
        while (pageResources.hasNext()) {
            Resource res = pageResources.next();
            lastReferencePath = res.getPath();
            Page page = manager.getContainingPage(res);
            if (page == null || pageReferences.contains(page)) continue;
            pageReferences.add(page);
            lastReferencePath = res.getPath();
            if (this.resourcePredicate != null && !this.resourcePredicate.test(res)) {
                pageReferences.remove(page);
                continue;
            }
            if (this.oldResourcePredicate == null || this.oldResourcePredicate.evaluate(res)) continue;
            pageReferences.remove(page);
        }
        return Pair.of(pageReferences, lastReferencePath);
    }

    private Iterator<Resource> findPageResources(ResourceResolver resolver, String path, int limit, int offset, String cursor) {
        if (path == null || resolver == null) {
            log.debug("Resolver or path is null for findPageResources. Path: {}, Resolver: {}", (Object)path, (Object)resolver);
            return Collections.emptyIterator();
        }
        ArrayList<String> searchTerms = new ArrayList<String>();
        this.prepareSqlSearchTerms(searchTerms, path);
        if (searchTerms.isEmpty()) {
            return Collections.emptyIterator();
        }
        String nodeAlias = "pageNode";
        String whereClause = null;
        String orderBy = nodeAlias + ".[jcr:path]";
        if (cursor != null && !cursor.trim().isEmpty()) {
            whereClause = String.format("%s.[jcr:path] > '%s' AND %s.[jcr:path] NOT LIKE '%s/%%'", nodeAlias, this.escapeSql2SearchTerm(cursor), nodeAlias, this.escapeSql2SearchTerm(cursor));
        }
        return this.executeSql2Query(resolver, "SELECT " + nodeAlias + ".*", "[nt:base] AS " + nodeAlias, whereClause, searchTerms, offset, limit, orderBy);
    }

    public List<Page> findPageReferencesForResource(ResourceResolver resolver, String path, int limit, String cursor) {
        Iterator<Resource> pageResources = this.findPageResources(resolver, path, limit, 0, cursor);
        Pair<List<Page>, String> result = this.processPageResources(pageResources, resolver);
        cursor = result.getRight();
        ArrayList<Page> pageReferences = new ArrayList<Page>((Collection)result.getLeft());
        while (pageReferences.size() < limit && cursor != null && !cursor.isEmpty()) {
            cursor = result.getRight();
            pageResources = this.findPageResources(resolver, path, limit - pageReferences.size(), 0, cursor);
            result = this.processPageResources(pageResources, resolver);
            for (Page page : result.getLeft()) {
                if (pageReferences.contains(page)) continue;
                pageReferences.add(page);
            }
        }
        return pageReferences;
    }
}

