/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.process;

import com.adobe.granite.workflow.collection.ResourceCollection;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.workflow.process.ResourceCollectionHelper;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class ReplicatePageProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ReplicatePageProcess.class);
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    public static final String TYPE_JCR_UUID = "JCR_UUID";
    @Reference
    protected Replicator replicator;
    @Reference
    protected EventAdmin eventAdmin;
    @Reference
    protected ResourceCollectionManager rcManager;
    @Reference
    private AgentManager agentManager;
    @Reference
    private SlingRepository repository;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Session participantSession = null;
        Session replicationSession = null;
        try {
            String approverId;
            Session session = workflowSession.getSession();
            if (this.replicateAsParticipant(args) && (approverId = this.resolveParticipantId(workItem, workflowSession)) != null) {
                participantSession = this.getParticipantSession(approverId, workflowSession);
            }
            replicationSession = participantSession != null ? participantSession : session;
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null) {
                String payloadData = (String)data.getPayload();
                if (session.itemExists(payloadData)) {
                    path = payloadData;
                }
            } else if (data.getPayload() != null && type.equals(TYPE_JCR_UUID)) {
                Node node = session.getNodeByUUID((String)data.getPayload());
                path = node.getPath();
            }
            MetaDataMap metaDataMap = data.getMetaDataMap();
            HashMap<String, String> versionMap = new HashMap<String, String>();
            if (metaDataMap.containsKey("versions")) {
                JSONObject versionJs = new JSONObject((String)((Object)data.getMetaDataMap().get("versions", String.class)));
                Iterator<String> iterator = versionJs.keys();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    versionMap.put(key, (String)versionJs.get(key));
                }
            }
            String agentId = null;
            if (metaDataMap.containsKey("agentId")) {
                agentId = (String)((Object)metaDataMap.get("agentId", String.class));
            }
            if (path != null) {
                List<ResourceCollection> rcCollections = this.rcManager.getCollectionsForNode((Node)session.getItem(path));
                List<String> paths = ResourceCollectionHelper.getPaths(path, rcCollections);
                for (String aPath : paths) {
                    if (this.canReplicate(replicationSession, aPath)) {
                        Agent agent;
                        ReplicationOptions opts = new ReplicationOptions();
                        String versionLabel = this.getVersionLabel(aPath, versionMap);
                        if (StringUtils.isNotEmpty(versionLabel)) {
                            opts.setRevision(versionLabel);
                        }
                        if (StringUtils.isNoneEmpty(agentId) && (agent = this.getAgent(agentId)) != null) {
                            String targetAgentId = agent.getId();
                            opts.setFilter(fltAgent -> fltAgent.getId().equals(targetAgentId));
                        }
                        opts = this.prepareOptions(opts);
                        this.replicator.replicate(replicationSession, this.getReplicationType(), aPath, opts);
                        continue;
                    }
                    log.debug(session.getUserID() + " is not allowed to replicate this page/asset " + aPath + ". Issuing request for 'replication");
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    ((Dictionary)properties).put("path", aPath);
                    ((Dictionary)properties).put("replicationType", (Object)((Object)this.getReplicationType()));
                    ((Dictionary)properties).put("userId", session.getUserID());
                    if (StringUtils.isNotEmpty(agentId)) {
                        ((Dictionary)properties).put("agentId", agentId);
                    }
                    Event event = new Event("com/day/cq/wcm/workflow/req/for/activation", (Dictionary<String, ?>)properties);
                    this.eventAdmin.sendEvent(event);
                }
            } else {
                log.warn("Cannot activate page or asset because path is null for this workitem: " + workItem.toString());
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException(e);
        }
        catch (ReplicationException e) {
            throw new WorkflowException(e);
        }
        catch (JSONException e) {
            throw new WorkflowException(e);
        }
        finally {
            if (participantSession != null && participantSession.isLive()) {
                participantSession.logout();
                participantSession = null;
            }
        }
    }

    private String getVersionLabel(String path, Map<String, String> versionMap) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        if (versionMap.containsKey(path)) {
            return versionMap.get(path);
        }
        if (!((String)path).endsWith("/jcr:content")) {
            path = (String)path + "/jcr:content";
        }
        return versionMap.get(path);
    }

    private boolean replicateAsParticipant(MetaDataMap args) {
        String processArgs = (String)((Object)args.get(Arguments.PROCESS_ARGS.getArgumentName(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            String[] arguments;
            for (String argument : arguments = processArgs.split(",")) {
                String[] split = argument.split("=");
                if (split.length != 2) continue;
                String key = split[0];
                String value = split[1];
                if (!key.equalsIgnoreCase(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName())) continue;
                return Boolean.parseBoolean(value);
            }
            return false;
        }
        return args.get(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName(), Boolean.FALSE);
    }

    private Session getParticipantSession(String participantId, WorkflowSession workflowSession) {
        try {
            return this.repository.impersonateFromService(workflowSession.getSession().getUserID(), new SimpleCredentials(participantId, new char[0]), null);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    private String resolveParticipantId(WorkItem workItem, WorkflowSession workflowSession) {
        List<Object> history = new ArrayList();
        try {
            history = workflowSession.getHistory(workItem.getWorkflow());
            for (int index = history.size() - 1; index >= 0; --index) {
                HistoryItem previous = (HistoryItem)history.get(index);
                String type = previous.getWorkItem().getNode().getType();
                if (type == null || !type.equals("PARTICIPANT") && !type.equals("DYNAMIC_PARTICIPANT")) continue;
                return previous.getUserId();
            }
            return null;
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    private Agent getAgent(String agentId) {
        if (agentId == null) {
            return null;
        }
        Map<String, Agent> agents = this.agentManager.getAgents();
        Set<Map.Entry<String, Agent>> entries = agents.entrySet();
        for (Map.Entry<String, Agent> entry : entries) {
            String name = entry.getKey();
            Agent agent = entry.getValue();
            if (!name.equals(agentId)) continue;
            return agent;
        }
        return null;
    }

    public abstract ReplicationActionType getReplicationType();

    protected ReplicationOptions prepareOptions(ReplicationOptions opts) {
        return opts;
    }

    protected boolean canReplicate(Session session, String path) throws AccessDeniedException {
        try {
            AccessControlManager acMgr = session.getAccessControlManager();
            return acMgr.hasPrivileges(path, new Privilege[]{acMgr.privilegeFromName("{http://www.day.com/crx/1.0}replicate")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRcManager(ResourceCollectionManager resourceCollectionManager) {
        this.rcManager = resourceCollectionManager;
    }

    protected void unbindRcManager(ResourceCollectionManager resourceCollectionManager) {
        if (this.rcManager == resourceCollectionManager) {
            this.rcManager = null;
        }
    }

    protected void bindAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    protected void unbindAgentManager(AgentManager agentManager) {
        if (this.agentManager == agentManager) {
            this.agentManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        REPLICATE_AS_PARTICIPANT("replicateAsParticipant");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }
    }
}

