/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class OrderedSet
implements Set {
    private final HashSet set;
    private final LinkedList list = new LinkedList();

    public OrderedSet() {
        this.set = new HashSet();
    }

    public OrderedSet(Collection c) {
        this.set = new HashSet(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public OrderedSet(int initialCapacity, float loadFactor) {
        this.set = new HashSet(initialCapacity, loadFactor);
    }

    public OrderedSet(int initialCapacity) {
        this.set = new HashSet(initialCapacity);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        if (this.set.add(o)) {
            this.list.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            this.list.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        boolean ret = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            ret |= this.add(iter.next());
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection c) {
        this.set.clear();
        this.list.clear();
        return this.addAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean ret = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            ret |= this.remove(iter.next());
        }
        return ret;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }
}

