/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import com.day.util.diff.ChangeListener;
import com.day.util.diff.DefaultDocumentSource;
import com.day.util.diff.Document;
import java.io.PrintWriter;

public class InlineChangeListener
implements ChangeListener {
    private final PrintWriter out;

    public InlineChangeListener(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void onDocumentsStart(Document left, Document right) {
    }

    @Override
    public void onDocumentsEnd(Document left, Document right) {
        this.out.flush();
    }

    @Override
    public void onChangeStart(int leftLine, int leftLen, int rightLine, int rightLen) {
    }

    @Override
    public void onChangeEnd() {
        this.out.flush();
    }

    @Override
    public void onUnmodified(int leftLine, int rightLine, Document.Element text) {
        this.out.print(text);
    }

    @Override
    public void onDeleted(int leftLine, int rightLine, Document.Element text) {
        Document.AnnotatedElement t;
        String author = null;
        if (text instanceof Document.AnnotatedElement && (t = (Document.AnnotatedElement)text).getDocumentSource() instanceof DefaultDocumentSource) {
            DefaultDocumentSource src = (DefaultDocumentSource)t.getDocumentSource();
            author = src.getAuthor();
        }
        this.out.print("<del");
        if (author != null) {
            this.out.print(" title=\"");
            this.out.print(author);
            this.out.print("\"");
        }
        this.out.print(">");
        this.out.print(text);
        this.out.print("</del>");
    }

    @Override
    public void onInserted(int leftLine, int rightLine, Document.Element text) {
        Document.AnnotatedElement t;
        String author = null;
        if (text instanceof Document.AnnotatedElement && (t = (Document.AnnotatedElement)text).getDocumentSource() instanceof DefaultDocumentSource) {
            DefaultDocumentSource src = (DefaultDocumentSource)t.getDocumentSource();
            author = src.getAuthor();
        }
        this.out.print("<ins");
        if (author != null) {
            this.out.print(" title=\"");
            this.out.print(author);
            this.out.print("\"");
        }
        this.out.print(">");
        this.out.print(text);
        this.out.print("</ins>");
    }
}

