/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.FluentIterable;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.commons.collections.StreamUtils;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

@Deprecated(since="2024-09-23")
public class SharedDataStoreUtils {
    public static boolean isShared(BlobStore blobStore) {
        return blobStore instanceof SharedDataStore && ((SharedDataStore)((Object)blobStore)).getType() == SharedDataStore.Type.SHARED;
    }

    public static DataRecord getEarliestRecord(List<DataRecord> recs) {
        return Collections.min(recs, Comparator.comparing(DataRecord::getLastModified, Comparator.naturalOrder()));
    }

    public static Set<String> refsNotAvailableFromRepos(List<DataRecord> repos, List<DataRecord> refs) {
        return SetUtils.difference(StreamUtils.toStream(FluentIterable.of(repos)).collect(Collectors.toMap(input -> SharedStoreRecordType.REPOSITORY.getIdFromName(input.getIdentifier().toString()), e -> e, (oldValue, newValue) -> {
            throw new IllegalArgumentException("Duplicate key found: " + SharedStoreRecordType.REPOSITORY.getIdFromName(newValue.getIdentifier().toString()));
        }, LinkedHashMap::new)).keySet(), StreamUtils.toStream(FluentIterable.of(refs)).collect(Collectors.groupingBy(input -> SharedStoreRecordType.REFERENCES.getIdFromName(input.getIdentifier().toString()), LinkedHashMap::new, Collectors.toList())).keySet());
    }

    public static Set<String> refsNotOld(List<DataRecord> repos, List<DataRecord> refs, long referenceTime) {
        Set<String> qualifyingRefs = refs.stream().filter(dataRecord -> dataRecord.getLastModified() < referenceTime).collect(Collectors.groupingBy(input -> SharedStoreRecordType.MARKED_START_MARKER.getIdFromName(input.getIdentifier().toString()), Collectors.mapping(Function.identity(), Collectors.toList()))).keySet();
        Set<String> repoIds = repos.stream().map(dataRecord -> SharedStoreRecordType.REPOSITORY.getIdFromName(dataRecord.getIdentifier().toString())).collect(Collectors.toSet());
        repoIds.removeAll(qualifyingRefs);
        return repoIds;
    }

    @Deprecated(since="2024-09-23")
    public static enum SharedStoreRecordType {
        REFERENCES("references"),
        REPOSITORY("repository"),
        MARKED_START_MARKER("markedTimestamp"),
        BLOBREFERENCES("blob");

        private final String type;
        static final String DELIM = "-";

        private SharedStoreRecordType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getIdFromName(String name) {
            return Arrays.stream(name.split(DELIM, 2)).skip(1L).findFirst().map(s -> s.split("_", 2)[0]).orElse(null);
        }

        public String getNameFromId(String id) {
            return String.join((CharSequence)DELIM, this.getType(), id);
        }

        public String getNameFromIdPrefix(String id, String prefix) {
            return String.join((CharSequence)"_", String.join((CharSequence)DELIM, this.getType(), id), prefix);
        }
    }
}

