/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.commons.collections.StreamUtils;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamespaceRegistryModel {
    private final Map<String, String> prefixToNamespaceMap;
    private final Map<String, String> encodedNamespaceToPrefixMap;
    private final Set<String> registeredPrefixes;
    private final Set<String> registeredNamespacesEncoded;
    private final Set<String> mappedPrefixes;
    private final Set<String> mappedNamespacesEncoded;
    private final Set<String> mappedToPrefixes;
    private final Set<String> mappedToNamespacesEncoded;
    private final Set<String> allPrefixes;
    private final Set<String> allNamespacesEncoded;
    private final Set<String> consistentPrefixes;
    private final Set<String> consistentNamespacesEncoded;
    private final int registrySize;
    private final Set<String> duplicatePrefixes;
    private final Set<String> duplicateNamespacesEncoded;
    private final Set<String> danglingPrefixes;
    private final Set<String> danglingNamespacesEncoded;
    private volatile boolean consistent = false;
    private volatile boolean fixable = false;

    private NamespaceRegistryModel(List<String> registeredPrefixesList, List<String> registeredNamespacesEncodedList, Map<String, String> prefixToNamespaceMap, Map<String, String> encodedNamespaceToPrefixMap) {
        this.registeredPrefixes = registeredPrefixesList.stream().filter(s -> !Objects.isNull(s) && !s.isEmpty()).collect(Collectors.toSet());
        this.duplicatePrefixes = this.findDuplicates(registeredPrefixesList);
        this.registeredNamespacesEncoded = registeredNamespacesEncodedList.stream().filter(s -> !Objects.isNull(s) && !s.isEmpty()).collect(Collectors.toSet());
        this.duplicateNamespacesEncoded = this.findDuplicates(registeredNamespacesEncodedList);
        this.prefixToNamespaceMap = new HashMap<String, String>(prefixToNamespaceMap);
        this.encodedNamespaceToPrefixMap = new HashMap<String, String>(encodedNamespaceToPrefixMap);
        this.mappedPrefixes = this.prefixToNamespaceMap.keySet();
        this.mappedNamespacesEncoded = this.encodedNamespaceToPrefixMap.keySet();
        this.mappedToPrefixes = new HashSet<String>(encodedNamespaceToPrefixMap.values());
        this.mappedToNamespacesEncoded = this.prefixToNamespaceMap.values().stream().map(Namespaces::encodeUri).collect(Collectors.toSet());
        this.allPrefixes = SetUtils.union((Set)SetUtils.union(this.registeredPrefixes, this.mappedPrefixes), this.mappedToPrefixes);
        this.allNamespacesEncoded = SetUtils.union((Set)SetUtils.union(this.registeredNamespacesEncoded, this.mappedNamespacesEncoded), this.mappedToNamespacesEncoded);
        this.registrySize = Math.max(this.allPrefixes.size(), this.allNamespacesEncoded.size());
        this.consistentPrefixes = SetUtils.intersection((Set)SetUtils.intersection(this.registeredPrefixes, this.mappedPrefixes), this.mappedToPrefixes);
        this.consistentNamespacesEncoded = SetUtils.intersection((Set)SetUtils.intersection(this.registeredNamespacesEncoded, this.mappedNamespacesEncoded), this.mappedToNamespacesEncoded);
        this.danglingPrefixes = SetUtils.difference(this.registeredPrefixes, (Set)SetUtils.union(this.mappedPrefixes, this.mappedToPrefixes));
        this.danglingNamespacesEncoded = SetUtils.difference(this.registeredNamespacesEncoded, (Set)SetUtils.union(this.mappedNamespacesEncoded, this.mappedToNamespacesEncoded));
        boolean sizeMatches = this.duplicatePrefixes.isEmpty() && this.duplicateNamespacesEncoded.isEmpty() && this.consistentNamespacesEncoded.size() == this.allNamespacesEncoded.size() && this.consistentPrefixes.size() == this.allPrefixes.size();
        boolean doesRoundtrip = true;
        if (sizeMatches) {
            for (String prefix : this.mappedPrefixes) {
                String revMapped = encodedNamespaceToPrefixMap.get(Namespaces.encodeUri(prefixToNamespaceMap.get(prefix)));
                if (revMapped != null && revMapped.equals(prefix)) continue;
                doesRoundtrip = false;
                break;
            }
            if (doesRoundtrip) {
                for (String ns : this.mappedNamespacesEncoded) {
                    String uri = prefixToNamespaceMap.get(encodedNamespaceToPrefixMap.get(ns));
                    if (uri != null && Namespaces.encodeUri(uri).equals(ns)) continue;
                    doesRoundtrip = false;
                    break;
                }
            }
        }
        this.fixable = this.consistent = sizeMatches && doesRoundtrip;
        if (!this.consistent && doesRoundtrip) {
            this.fixable = this.registrySize == SetUtils.union(this.mappedPrefixes, this.mappedToPrefixes).size() && this.registrySize == SetUtils.union(this.mappedNamespacesEncoded, this.mappedToNamespacesEncoded).size();
        }
    }

    @Nullable
    public static NamespaceRegistryModel create(@NotNull Root root) {
        Tree rootTree = root.getTree("/");
        Tree namespaces = rootTree.getChild("jcr:system").getChild("rep:namespaces");
        if (namespaces.exists()) {
            Tree nsdata = namespaces.getChild("rep:nsdata");
            HashMap<String, String> prefixToNamespaceMap = new HashMap<String, String>();
            HashMap<String, String> namespaceToPrefixMap = new HashMap<String, String>();
            for (PropertyState propertyState : namespaces.getProperties()) {
                String prefix = propertyState.getName();
                if (prefix.equals("jcr:primaryType")) continue;
                prefixToNamespaceMap.put(prefix, propertyState.getValue(Type.STRING));
            }
            block9: for (PropertyState propertyState : nsdata.getProperties()) {
                String encodedUri;
                switch (encodedUri = propertyState.getName()) {
                    case "rep:prefixes": 
                    case "rep:uris": 
                    case "jcr:primaryType": {
                        continue block9;
                    }
                }
                namespaceToPrefixMap.put(encodedUri, propertyState.getValue(Type.STRING));
            }
            Iterable<String> uris = Objects.requireNonNull(nsdata.getProperty("rep:uris")).getValue(Type.STRINGS);
            return new NamespaceRegistryModel(Arrays.asList((String[])IterableUtils.toArray(Objects.requireNonNull(nsdata.getProperty("rep:prefixes")).getValue(Type.STRINGS), String.class)), StreamUtils.toStream(uris).map(Namespaces::encodeUri).collect(Collectors.toList()), prefixToNamespaceMap, namespaceToPrefixMap);
        }
        return null;
    }

    public NamespaceRegistryModel setMappings(@NotNull Map<String, String> additionalPrefixToUrisMappings) {
        ArrayList<String> newRegisteredPrefixesList = new ArrayList<String>(this.registeredPrefixes);
        HashMap<String, String> newPrefixToNamespaceMap = new HashMap<String, String>(this.prefixToNamespaceMap);
        ArrayList<String> newRegisteredNamespacesEncodedList = new ArrayList<String>(this.registeredNamespacesEncoded);
        HashMap<String, String> newEncodedNamespaceToPrefixMap = new HashMap<String, String>(this.encodedNamespaceToPrefixMap);
        for (Map.Entry<String, String> entry : additionalPrefixToUrisMappings.entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            String encodedUri = Namespaces.encodeUri(uri);
            if (!newRegisteredPrefixesList.contains(prefix)) {
                newRegisteredPrefixesList.add(prefix);
            }
            if (!newRegisteredNamespacesEncodedList.contains(encodedUri)) {
                newRegisteredNamespacesEncodedList.add(encodedUri);
            }
            String previousUri = newPrefixToNamespaceMap.get(prefix);
            newPrefixToNamespaceMap.put(prefix, uri);
            if (previousUri != null) {
                String previousEncodedUri = Namespaces.encodeUri(previousUri);
                newRegisteredNamespacesEncodedList.remove(previousEncodedUri);
                newEncodedNamespaceToPrefixMap.remove(previousEncodedUri);
            }
            newEncodedNamespaceToPrefixMap.put(encodedUri, prefix);
        }
        return new NamespaceRegistryModel(newRegisteredPrefixesList, newRegisteredNamespacesEncodedList, newPrefixToNamespaceMap, newEncodedNamespaceToPrefixMap);
    }

    public NamespaceRegistryModel tryRegistryRepair() {
        if (this.fixable) {
            ArrayList<String> fixedRegisteredPrefixesList = new ArrayList<String>();
            HashMap<String, String> fixedPrefixToNamespaceMap = new HashMap<String, String>();
            block0: for (String prefix : this.allPrefixes) {
                if (this.mappedPrefixes.contains(prefix)) {
                    fixedRegisteredPrefixesList.add(prefix);
                    fixedPrefixToNamespaceMap.put(prefix, this.prefixToNamespaceMap.get(prefix));
                    continue;
                }
                for (Map.Entry entry : this.encodedNamespaceToPrefixMap.entrySet()) {
                    if (!((String)entry.getValue()).equals(prefix)) continue;
                    fixedRegisteredPrefixesList.add(prefix);
                    fixedPrefixToNamespaceMap.put(prefix, Text.unescape((String)entry.getKey()));
                    continue block0;
                }
            }
            ArrayList<String> fixedRegisteredNamespacesEncodedList = new ArrayList<String>();
            HashMap<String, String> fixedNamespaceToPrefixMap = new HashMap<String, String>();
            block2: for (String string : this.allNamespacesEncoded) {
                if (this.mappedNamespacesEncoded.contains(string)) {
                    fixedRegisteredNamespacesEncodedList.add(string);
                    fixedNamespaceToPrefixMap.put(string, this.encodedNamespaceToPrefixMap.get(string));
                    continue;
                }
                for (Map.Entry<String, String> entry : this.prefixToNamespaceMap.entrySet()) {
                    if (!Namespaces.encodeUri(entry.getValue()).equals(string)) continue;
                    fixedRegisteredNamespacesEncodedList.add(string);
                    fixedNamespaceToPrefixMap.put(string, entry.getKey());
                    continue block2;
                }
            }
            return new NamespaceRegistryModel(fixedRegisteredPrefixesList, fixedRegisteredNamespacesEncodedList, fixedPrefixToNamespaceMap, fixedNamespaceToPrefixMap);
        }
        return this;
    }

    public void apply(Root root) throws RepositoryException, CommitFailedException {
        String name;
        Tree rootTree = root.getTree("/");
        Tree namespaces = rootTree.getChild("jcr:system").getChild("rep:namespaces");
        Tree nsdata = namespaces.getChild("rep:nsdata");
        for (PropertyState propertyState : namespaces.getProperties()) {
            name = propertyState.getName();
            if ("jcr:primaryType".equals(name)) continue;
            namespaces.removeProperty(name);
        }
        for (PropertyState propertyState : nsdata.getProperties()) {
            name = propertyState.getName();
            if ("jcr:primaryType".equals(name)) continue;
            nsdata.removeProperty(name);
        }
        nsdata.removeProperty("rep:prefixes");
        nsdata.removeProperty("rep:uris");
        for (Map.Entry entry : this.prefixToNamespaceMap.entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            namespaces.setProperty(prefix, uri);
        }
        for (Map.Entry entry : this.encodedNamespaceToPrefixMap.entrySet()) {
            String encodedUri = (String)entry.getKey();
            String prefix = (String)entry.getValue();
            nsdata.setProperty(encodedUri, prefix);
        }
        nsdata.setProperty("rep:prefixes", this.mappedPrefixes, Type.STRINGS);
        nsdata.setProperty("rep:uris", this.prefixToNamespaceMap.values(), Type.STRINGS);
        if (!this.consistent) {
            throw new IllegalStateException("Final registry consistency check failed.");
        }
    }

    public boolean isConsistent() {
        return this.consistent;
    }

    public boolean isFixable() {
        return this.fixable;
    }

    public Set<String> getDanglingPrefixes() {
        return this.danglingPrefixes;
    }

    public Set<String> getDanglingEncodedNamespaceUris() {
        return this.danglingNamespacesEncoded;
    }

    public Map<String, String> getRepairedMappings() {
        String uri;
        String prefix;
        HashMap<String, String> map = new HashMap<String, String>();
        Set repairablePrefixes = SetUtils.difference((Set)SetUtils.difference(this.allPrefixes, this.consistentPrefixes), this.danglingPrefixes);
        Set repairableUrisEncoded = SetUtils.difference((Set)SetUtils.difference(this.allNamespacesEncoded, this.consistentNamespacesEncoded), this.danglingNamespacesEncoded);
        for (Map.Entry<String, String> entry : this.prefixToNamespaceMap.entrySet()) {
            prefix = entry.getKey();
            uri = entry.getValue();
            if (!repairablePrefixes.contains(prefix) && !repairableUrisEncoded.contains(uri)) continue;
            map.put(prefix, uri);
        }
        for (Map.Entry<String, String> entry : this.encodedNamespaceToPrefixMap.entrySet()) {
            prefix = entry.getValue();
            uri = entry.getKey();
            if (!repairablePrefixes.contains(prefix) && !repairableUrisEncoded.contains(uri)) continue;
            map.put(prefix, uri);
        }
        return map;
    }

    private <T> Set<T> findDuplicates(Collection<T> c) {
        HashSet uniques = new HashSet();
        return c.stream().filter(t -> !uniques.add(t)).collect(Collectors.toSet());
    }

    public void dump() throws IOException {
        this.dump(System.out);
    }

    public void dump(OutputStream out) throws IOException {
        this.dump(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        out.flush();
    }

    public void dump(Writer out) throws IOException {
        BufferedWriter writer = new BufferedWriter(out);
        if (this.consistent) {
            writer.write("This namespace registry model is consistent, containing the following mappings from prefixes to namespace uris:");
            writer.newLine();
            writer.newLine();
            for (Map.Entry<String, String> entry : this.prefixToNamespaceMap.entrySet()) {
                writer.write(entry.getKey() + " -> " + entry.getValue());
                writer.newLine();
            }
        } else {
            writer.write("This namespace registry model is inconsistent. The inconsistency can " + (this.isFixable() ? "" : "NOT ") + "be fixed.");
            writer.newLine();
            writer.newLine();
            writer.write("Registered prefixes without any namespace mapping: " + String.valueOf(this.danglingPrefixes));
            writer.newLine();
            writer.write("Registered namespace URIs without any prefix mapping: " + String.valueOf(this.danglingNamespacesEncoded));
            writer.newLine();
            writer.write("Duplicate prefixes: " + String.valueOf(this.duplicatePrefixes));
            writer.newLine();
            writer.write("Duplicate namespace URIs: " + String.valueOf(this.duplicateNamespacesEncoded));
            writer.newLine();
            writer.write("Mapped unregistered prefixes: " + String.valueOf(SetUtils.difference((Set)SetUtils.union(this.mappedPrefixes, this.mappedToPrefixes), this.registeredPrefixes)));
            writer.newLine();
            writer.write("Mapped unregistered namespace URIs: " + String.valueOf(SetUtils.difference((Set)SetUtils.union(this.mappedNamespacesEncoded, this.mappedToNamespacesEncoded), this.registeredNamespacesEncoded)));
            writer.newLine();
            writer.write("Mapped prefixes without a reverse mapping: " + String.valueOf(SetUtils.difference(this.mappedPrefixes, this.mappedToPrefixes)));
            writer.newLine();
            writer.write("Mapped namespace URIs without a reverse mapping: " + String.valueOf(SetUtils.difference(this.mappedNamespacesEncoded, this.mappedToNamespacesEncoded)));
            writer.newLine();
            writer.newLine();
            if (this.isFixable()) {
                NamespaceRegistryModel repaired = this.tryRegistryRepair();
                writer.newLine();
                writer.write("The following mappings could be repaired:");
                writer.newLine();
                writer.newLine();
                for (Map.Entry<String, String> entry : this.getRepairedMappings().entrySet()) {
                    writer.write(entry.getKey() + " -> " + entry.getValue());
                    writer.newLine();
                }
                writer.newLine();
                writer.newLine();
                writer.write("The repaired registry would contain the following mappings:");
                writer.newLine();
                writer.newLine();
                for (Map.Entry<String, String> entry : repaired.prefixToNamespaceMap.entrySet()) {
                    writer.write(entry.getKey() + " -> " + entry.getValue());
                    writer.newLine();
                }
            } else {
                writer.write("The following mappings could be repaired:");
                writer.newLine();
                writer.newLine();
                for (Map.Entry<String, String> entry : this.getRepairedMappings().entrySet()) {
                    writer.write(entry.getKey() + " -> " + entry.getValue());
                    writer.newLine();
                }
                writer.newLine();
                writer.newLine();
                writer.write("To create a fixed model, use #tryRegistryRepair(Map<String, String>) and supply missing prefix to namespace mappings as parameters");
                writer.newLine();
            }
        }
        writer.flush();
    }
}

