/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.observation.filter.RelativePathSelector;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Selectors {
    public static final UniversalFilter.Selector THIS = new ThisSelector();
    public static final UniversalFilter.Selector PARENT = new ParentSelector();

    @NotNull
    public static UniversalFilter.Selector fromThis(@NotNull String relPath) {
        return new RelativePathSelector(relPath, THIS);
    }

    @NotNull
    public static UniversalFilter.Selector fromParent(@NotNull String relPath) {
        return new RelativePathSelector(relPath, PARENT);
    }

    private Selectors() {
    }

    private static class ThisSelector
    implements UniversalFilter.Selector {
        private ThisSelector() {
        }

        @Override
        public NodeState select(@NotNull UniversalFilter filter, @Nullable PropertyState before, @Nullable PropertyState after) {
            return EmptyNodeState.MISSING_NODE;
        }

        @Override
        public NodeState select(@NotNull UniversalFilter filter, @NotNull String name, @NotNull NodeState before, @NotNull NodeState after) {
            return after.exists() ? after : before;
        }
    }

    private static class ParentSelector
    implements UniversalFilter.Selector {
        private ParentSelector() {
        }

        @Override
        public NodeState select(@NotNull UniversalFilter filter, @Nullable PropertyState before, @Nullable PropertyState after) {
            return after != null ? filter.getAfterState() : filter.getBeforeState();
        }

        @Override
        public NodeState select(@NotNull UniversalFilter filter, @NotNull String name, @NotNull NodeState before, @NotNull NodeState after) {
            return after.exists() ? filter.getAfterState() : filter.getBeforeState();
        }
    }
}

