/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.Aggregator;
import org.apache.jackrabbit.vault.fs.api.ArtifactHandler;
import org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.VaultFsConfig11;
import org.apache.jackrabbit.vault.util.RejectingEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractVaultFsConfig
implements VaultFsConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractVaultFsConfig.class);
    public static final String ATTR_VERSION = "version";
    private List<Aggregator> aggregators = new ArrayList<Aggregator>();
    private List<ArtifactHandler> handlers = new ArrayList<ArtifactHandler>();
    private Map<String, String> properties = new HashMap<String, String>();
    private byte[] source;
    private String name = "";

    public static VaultFsConfig load(File file) throws ConfigurationException, IOException {
        try (FileInputStream input = new FileInputStream(file);){
            VaultFsConfig vaultFsConfig = AbstractVaultFsConfig.load(input, file.getName());
            return vaultFsConfig;
        }
    }

    public static VaultFsConfig load(InputStream in, String name) throws ConfigurationException, IOException {
        double version;
        byte[] source = IOUtils.toByteArray(in);
        Document document = AbstractVaultFsConfig.parse(new ByteArrayInputStream(source));
        Element doc = document.getDocumentElement();
        if (!doc.getNodeName().equals("vaultfs")) {
            throw new ConfigurationException("<vaultfs> expected.");
        }
        String v = doc.getAttribute(ATTR_VERSION);
        if (v == null || v.equals("")) {
            v = "1.0";
        }
        if ((version = Double.parseDouble(v)) != 1.1) {
            throw new ConfigurationException("version " + version + " not supported.");
        }
        VaultFsConfig11 config = new VaultFsConfig11();
        config.setSource(source);
        config.setName(name);
        ((AbstractVaultFsConfig)config).process(doc);
        return config;
    }

    protected Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    protected abstract void process(Element var1) throws ConfigurationException;

    private void setSource(byte[] bytes) {
        this.source = bytes;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public InputStream getSource() {
        return new ByteArrayInputStream(this.source);
    }

    @Override
    public String getSourceAsString() {
        try {
            return new String(this.source, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Aggregator> getAggregators() {
        return this.aggregators;
    }

    @Override
    public List<ArtifactHandler> getHandlers() {
        return this.handlers;
    }

    private static Document parse(InputStream xml) throws ConfigurationException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            return builder.parse(xml);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Configuration file syntax error.", e);
        }
    }

    protected static Collection<Element> getChildElements(Node elem) {
        NodeList nodeList = elem.getChildNodes();
        ArrayList<Element> nodes = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() != 1) continue;
            nodes.add((Element)child);
        }
        return nodes;
    }

    protected void fail(String msg, Node elem) throws ConfigurationException {
        Object path = "";
        while (elem != null && elem.getNodeType() != 9) {
            path = " > " + elem.getNodeName() + (String)path;
            elem = elem.getParentNode();
        }
        throw new ConfigurationException(msg + ". Location: " + this.name + (String)path);
    }
}

