/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSave {
    private static final Logger log = LoggerFactory.getLogger(AutoSave.class);
    private int numModified;
    private int lastSave;
    private int threshold = 1024;
    private int failedSaveThreshold = 0;
    private ProgressTracker tracker;
    private boolean dryRun;
    private int debugFailEach;
    private int debugSaveCount;

    public AutoSave() {
    }

    public AutoSave(int threshold) {
        this.threshold = threshold;
    }

    boolean isDisabled() {
        return this.threshold == Integer.MAX_VALUE;
    }

    public AutoSave copy() {
        AutoSave ret = new AutoSave();
        ret.threshold = this.threshold;
        ret.numModified = this.numModified;
        ret.lastSave = this.lastSave;
        ret.tracker = this.tracker;
        ret.dryRun = this.dryRun;
        ret.debugFailEach = this.debugFailEach;
        return ret;
    }

    public void setTracker(@Nullable ProgressTracker tracker) {
        this.tracker = tracker;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setDebugFailEach(int debugFailEach) {
        this.debugFailEach = debugFailEach;
    }

    public boolean needsSave() {
        return this.numModified - this.lastSave >= this.threshold + this.failedSaveThreshold;
    }

    public void save(@Nullable Session session) throws RepositoryException {
        this.save(session, true);
    }

    public void save(@Nullable Session session, boolean isIntermediate) throws RepositoryException {
        if (this.isDisabled()) {
            log.trace("Save disabled.");
            return;
        }
        int diff = this.numModified - this.lastSave;
        if (isIntermediate) {
            log.debug("Threshold of {} reached. {} approx {} transient changes.", this.threshold, this.dryRun ? "dry run, reverting" : "saving", diff);
        }
        if (this.tracker != null) {
            if (this.dryRun) {
                this.tracker.track("reverting approx " + diff + " nodes... (dry run)", "");
            } else {
                this.tracker.track("saving approx " + diff + " nodes...", "");
            }
        }
        if (session != null) {
            if (this.debugFailEach > 0 && this.debugSaveCount > 0 && this.debugSaveCount % this.debugFailEach == 0) {
                String msg = String.format(Locale.ENGLISH, "Debugging provoked failure after %s saves.", this.debugSaveCount);
                log.error(msg);
                throw new RepositoryException(msg);
            }
            if (!this.saveWithBackoff(session, isIntermediate)) {
                this.failedSaveThreshold = diff - this.threshold + 10;
                log.warn("Retry auto-save after {} more modified nodes", (Object)10);
            } else {
                this.lastSave = this.numModified;
                this.failedSaveThreshold = 0;
            }
        }
    }

    private boolean saveWithBackoff(@NotNull Session session, boolean isIntermediate) throws RepositoryException {
        block6: {
            try {
                if (this.dryRun) {
                    session.refresh(false);
                    break block6;
                }
                try {
                    session.save();
                }
                catch (RepositoryException e) {
                    log.error("Error during auto save, retrying after refresh: {}", (Object)Importer.getExtendedThrowableMessage(e));
                    session.refresh(true);
                    session.save();
                }
                ++this.debugSaveCount;
            }
            catch (RepositoryException e) {
                if (this.isPotentiallyTransientException(e) && isIntermediate) {
                    log.warn("Could not auto-save even after refresh due to potentially transient exception: {}", (Object)Importer.getExtendedThrowableMessage(e));
                    log.debug("Auto save exception", e);
                    return false;
                }
                throw e;
            }
        }
        return true;
    }

    boolean isPotentiallyTransientException(RepositoryException e) {
        return e instanceof ConstraintViolationException;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean modified(int num) {
        this.numModified += num;
        return this.needsSave();
    }

    @Deprecated
    public void markMissing(@NotNull String path) {
    }

    @Deprecated
    public void markResolved(@NotNull String path) {
    }

    public String toString() {
        return "AutoSave [numModified=" + this.numModified + ", lastSave=" + this.lastSave + ", threshold=" + this.threshold + ", failedSaveThreshold=" + this.failedSaveThreshold + ", dryRun=" + this.dryRun + "]";
    }
}

