/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.AppendingDeltaPackedLongBuffer;

class BinaryDocValuesWriter
extends DocValuesWriter {
    private static final int MAX_LENGTH = 0x7FFFFEFF;
    private static final int BLOCK_BITS = 15;
    private final PagedBytes bytes;
    private final DataOutput bytesOut;
    private final Counter iwBytesUsed;
    private final AppendingDeltaPackedLongBuffer lengths;
    private FixedBitSet docsWithField;
    private final FieldInfo fieldInfo;
    private int addedValues;
    private long bytesUsed;

    public BinaryDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.bytes = new PagedBytes(15);
        this.bytesOut = this.bytes.getDataOutput();
        this.lengths = new AppendingDeltaPackedLongBuffer(0.0f);
        this.iwBytesUsed = iwBytesUsed;
        this.docsWithField = new FixedBitSet(64);
        this.bytesUsed = this.docsWithFieldBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value) {
        if (docID < this.addedValues) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (value == null) {
            throw new IllegalArgumentException("field=\"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value.length > 0x7FFFFEFF) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= 2147483391");
        }
        while (this.addedValues < docID) {
            ++this.addedValues;
            this.lengths.add(0L);
        }
        ++this.addedValues;
        this.lengths.add(value.length);
        try {
            this.bytesOut.writeBytes(value.bytes, value.offset, value.length);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, docID);
        this.docsWithField.set(docID);
        this.updateBytesUsed();
    }

    private long docsWithFieldBytesUsed() {
        return RamUsageEstimator.sizeOf(this.docsWithField.getBits()) + 64L;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.lengths.ramBytesUsed() + this.bytes.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void finish(int maxDoc) {
    }

    @Override
    public void flush(SegmentWriteState state, DocValuesConsumer dvConsumer) throws IOException {
        final int maxDoc = state.segmentInfo.getDocCount();
        this.bytes.freeze(false);
        dvConsumer.addBinaryField(this.fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new BytesIterator(maxDoc);
            }
        });
    }

    @Override
    public void abort() {
    }

    private class BytesIterator
    implements Iterator<BytesRef> {
        final BytesRef value = new BytesRef();
        final AbstractAppendingLongBuffer.Iterator lengthsIterator;
        final DataInput bytesIterator;
        final int size;
        final int maxDoc;
        int upto;

        BytesIterator(int maxDoc) {
            this.lengthsIterator = BinaryDocValuesWriter.this.lengths.iterator();
            this.bytesIterator = BinaryDocValuesWriter.this.bytes.getDataInput();
            this.size = (int)BinaryDocValuesWriter.this.lengths.size();
            this.maxDoc = maxDoc;
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public BytesRef next() {
            BytesRef v;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.upto < this.size) {
                int length = (int)this.lengthsIterator.next();
                this.value.grow(length);
                this.value.length = length;
                try {
                    this.bytesIterator.readBytes(this.value.bytes, this.value.offset, this.value.length);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                v = BinaryDocValuesWriter.this.docsWithField.get(this.upto) ? this.value : null;
            } else {
                v = null;
            }
            ++this.upto;
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

