/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.MojoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.maven.mojos.Aggregate;
import org.apache.sling.feature.maven.mojos.AggregateFeaturesMojo;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES)
public class AggregateWithSDKMojo
extends AggregateFeaturesMojo {
    private static final String SDK_GROUP_ID = "com.adobe.aem";
    private static final String SDK_ARTIFACT_ID = "aem-sdk-api";
    private static final String SDK_FEATUREMODEL_CLASSIFIER = "aem-author-sdk";
    private static final String FEATUREMODEL_TYPE = "slingosgifeature";
    boolean unitTestMode = false;
    boolean unitTestEarlyExit = false;
    @Parameter(required=false)
    private List<Aggregate> aggregates;
    @Parameter(defaultValue="com.adobe.aem", property="sdkGroupId")
    String sdkGroupId;
    @Parameter(defaultValue="aem-sdk-api", property="sdkArtifactId")
    String sdkArtifactId;
    @Parameter(required=false, property="sdkVersion")
    String sdkVersion;

    public void execute() throws MojoExecutionException {
        MojoUtils.setParameter((Object)this, "generatedFeatures", MojoUtils.getGeneratedFeaturesDir(this.project));
        MojoUtils.setParameter((Object)this, AggregateFeaturesMojo.class, "aggregates", this.getUserAggregates());
        if (!this.unitTestMode) {
            super.execute();
        }
        if (this.unitTestEarlyExit) {
            return;
        }
        MojoUtils.setParameter((Object)this, "generatedFeatures", null);
        MojoUtils.setParameter((Object)this, AggregateFeaturesMojo.class, "aggregates", this.getFinalAggregates());
        if (!this.unitTestMode) {
            super.execute();
        }
    }

    private List<Aggregate> getUserAggregates() throws MojoExecutionException {
        ArrayList<Aggregate> l = new ArrayList<Aggregate>();
        Aggregate a = new Aggregate();
        a.classifier = "user-aggregated";
        a.setFilesInclude("**/*.json");
        a.markAsComplete = false;
        a.artifactsOverrides = Collections.singletonList("*:*:HIGHEST");
        a.configurationOverrides = Collections.singletonList("*=MERGE_LATEST");
        l.add(a);
        return l;
    }

    private List<Aggregate> getFinalAggregates() throws MojoExecutionException {
        ArrayList<Aggregate> l = new ArrayList<Aggregate>();
        Aggregate a = new Aggregate();
        a.classifier = "aggregated";
        a.setIncludeArtifact(this.getSDKFeatureModel());
        a.setIncludeClassifier("user-aggregated");
        a.markAsComplete = false;
        a.artifactsOverrides = Arrays.asList("com.adobe.cq:core.wcm.components.core:FIRST", "com.adobe.cq:core.wcm.components.extensions.amp:FIRST", "org.apache.sling:org.apache.sling.models.impl:FIRST", "*:core.wcm.components.content:zip:*:FIRST", "*:core.wcm.components.extensions.amp.content:zip:*:FIRST", "*:*:ALL");
        a.configurationOverrides = Collections.singletonList("*=MERGE_LATEST");
        l.add(a);
        return l;
    }

    private Dependency getSDKFeatureModel() throws MojoExecutionException {
        Dependency sdkDep;
        if (this.sdkVersion == null) {
            sdkDep = this.getSDKFromDependencies();
        } else {
            sdkDep = new Dependency();
            sdkDep.setGroupId(this.sdkGroupId);
            sdkDep.setArtifactId(this.sdkArtifactId);
            sdkDep.setVersion(this.sdkVersion);
        }
        this.getLog().info((CharSequence)("Using SDK Version for analysis: " + sdkDep));
        Dependency sdkFM = new Dependency();
        sdkFM.setGroupId(sdkDep.getGroupId());
        sdkFM.setArtifactId(sdkDep.getArtifactId());
        sdkFM.setVersion(sdkDep.getVersion());
        sdkFM.setType(FEATUREMODEL_TYPE);
        sdkFM.setClassifier(SDK_FEATUREMODEL_CLASSIFIER);
        return sdkFM;
    }

    private Dependency getSDKFromDependencies() throws MojoExecutionException {
        for (Dependency d : this.project.getDependencies()) {
            if (!SDK_GROUP_ID.equals(d.getGroupId()) || !SDK_ARTIFACT_ID.equals(d.getArtifactId())) continue;
            return d;
        }
        for (Dependency d : this.project.getDependencyManagement().getDependencies()) {
            if (!SDK_GROUP_ID.equals(d.getGroupId()) || !SDK_ARTIFACT_ID.equals(d.getArtifactId())) continue;
            return d;
        }
        throw new MojoExecutionException("Unable to find SDK artifact in dependencies or dependency management");
    }
}

