/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.MojoUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.maven.mojos.AnalyseFeaturesMojo;
import org.apache.sling.feature.maven.mojos.Scan;

@Mojo(name="analyse", defaultPhase=LifecyclePhase.TEST)
public class AnalyseMojo
extends AnalyseFeaturesMojo {
    boolean unitTestMode = false;
    @Parameter(defaultValue="bundle-packages,requirements-capabilities,bundle-resources,api-regions,api-regions-check-order,api-regions-dependencies,api-regions-duplicates,api-regions-crossfeature-dups", property="includeTasks")
    List<String> includeTasks;
    @Parameter
    Map<String, Properties> taskConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.taskConfiguration == null) {
            this.taskConfiguration = new HashMap<String, Properties>();
        }
        if (!this.taskConfiguration.containsKey("api-regions-crossfeature-dups")) {
            Properties cfd = new Properties();
            cfd.setProperty("regions", "global,com.adobe.aem.deprecated");
            cfd.setProperty("warningPackages", "*");
            this.taskConfiguration.put("api-regions-crossfeature-dups", cfd);
        }
        if (!this.taskConfiguration.containsKey("api-regions-check-order")) {
            Properties ord = new Properties();
            ord.setProperty("order", "global,com.adobe.aem.deprecated,com.adobe.aem.internal");
            this.taskConfiguration.put("api-regions-check-order", ord);
        }
        Scan s = new Scan();
        s.setIncludeClassifier("aggregated");
        for (String string : this.includeTasks) {
            s.setIncludeTask(string);
        }
        for (Map.Entry entry : this.taskConfiguration.entrySet()) {
            Properties p = (Properties)entry.getValue();
            HashMap m = new HashMap();
            p.stringPropertyNames().forEach(n -> m.put(n, p.getProperty((String)n)));
            s.setTaskConfiguration((String)entry.getKey(), m);
        }
        MojoUtils.setParameter((Object)this, "scans", Collections.singletonList(s));
        if (this.unitTestMode) {
            return;
        }
        super.execute();
    }
}

