/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.maven.Environment;
import org.apache.sling.feature.maven.FeatureProjectInfo;
import org.apache.sling.feature.maven.Preprocessor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="featureparticipant")
public class LifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_ID = "com.adobe.aem:aemanalyser-maven-plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private ArtifactResolver resolver;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Environment env = new Environment();
        env.artifactHandlerManager = this.artifactHandlerManager;
        env.resolver = this.resolver;
        env.logger = this.logger;
        env.session = session;
        this.logger.debug("Searching for project using plugin 'com.adobe.aem:aemanalyser-maven-plugin'...");
        for (MavenProject project : session.getProjects()) {
            Plugin plugin = project.getPlugin(PLUGIN_ID);
            if (plugin == null) continue;
            this.logger.debug("Found project " + project.getId() + " using " + PLUGIN_ID);
            FeatureProjectInfo info = new FeatureProjectInfo();
            info.plugin = plugin;
            info.project = project;
            env.modelProjects.put(project.getGroupId() + ":" + project.getArtifactId(), info);
        }
        this.preProcess(env);
    }

    void preProcess(Environment env) {
        new Preprocessor().process(env);
    }
}

