/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.MojoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.maven.mojos.Aggregate;
import org.apache.sling.feature.maven.mojos.AggregateFeaturesMojo;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES)
public class AggregateWithSDKMojo
extends AggregateFeaturesMojo {
    private static final String SDK_GROUP_ID = "com.adobe.aem";
    private static final String SDK_ARTIFACT_ID = "aem-sdk-api";
    private static final String SDK_FEATUREMODEL_CLASSIFIER = "aem-author-sdk";
    private static final String SDK_FEATUREMODEL_TYPE = "slingosgifeature";
    boolean unitTestMode = false;
    @Parameter(required=false)
    private List<Aggregate> aggregates;
    @Parameter(defaultValue="com.adobe.aem", property="sdkGroupId")
    String sdkGroupId;
    @Parameter(defaultValue="aem-sdk-api", property="sdkArtifactId")
    String sdkArtifactId;
    @Parameter(required=false, property="sdkVersion")
    String sdkVersion;

    public void execute() throws MojoExecutionException {
        MojoUtils.setParameter((Object)this, AggregateFeaturesMojo.class, "aggregates", this.getAggregates());
        if (this.unitTestMode) {
            return;
        }
        super.execute();
    }

    private List<Aggregate> getAggregates() throws MojoExecutionException {
        ArrayList<Aggregate> l = new ArrayList<Aggregate>();
        Aggregate a = new Aggregate();
        a.classifier = "aggregated";
        a.setIncludeArtifact(this.getSDKFeatureModel());
        a.setFilesInclude("**/*.json");
        a.markAsComplete = true;
        a.artifactsOverrides = Collections.singletonList("*:*:LATEST");
        a.configurationOverrides = Collections.singletonList("*=MERGE_LATEST");
        l.add(a);
        return l;
    }

    private Dependency getSDKFeatureModel() throws MojoExecutionException {
        Dependency sdkDep;
        if (this.sdkVersion == null) {
            sdkDep = this.getSDKFromDependencies();
        } else {
            sdkDep = new Dependency();
            sdkDep.setGroupId(this.sdkGroupId);
            sdkDep.setArtifactId(this.sdkArtifactId);
            sdkDep.setVersion(this.sdkVersion);
        }
        Dependency sdkFM = new Dependency();
        sdkFM.setGroupId(sdkDep.getGroupId());
        sdkFM.setArtifactId(sdkDep.getArtifactId());
        sdkFM.setVersion(sdkDep.getVersion());
        sdkFM.setType(SDK_FEATUREMODEL_TYPE);
        sdkFM.setClassifier(SDK_FEATUREMODEL_CLASSIFIER);
        return sdkFM;
    }

    private Dependency getSDKFromDependencies() throws MojoExecutionException {
        for (Dependency d : this.project.getDependencies()) {
            if (!SDK_GROUP_ID.equals(d.getGroupId()) || !SDK_ARTIFACT_ID.equals(d.getArtifactId())) continue;
            return d;
        }
        for (Dependency d : this.project.getDependencyManagement().getDependencies()) {
            if (!SDK_GROUP_ID.equals(d.getGroupId()) || !SDK_ARTIFACT_ID.equals(d.getArtifactId())) continue;
            return d;
        }
        throw new MojoExecutionException("Unable to find SDK artifact in dependencies or dependency management");
    }
}

