/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.sling.cpconverter.maven.mojos.ContentPackage;
import org.apache.sling.cpconverter.maven.mojos.ConvertCPMojo;

@Mojo(name="convert", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ConvertToFeatureModelMojo
extends ConvertCPMojo {
    static final String AEM_ANALYSE_PACKAGING = "aem-analyse";
    boolean unitTestMode = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MojoUtils.setParameter((Object)this, "artifactIdOverride", this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
        MojoUtils.setParameter((Object)this, "isContentPackage", !AEM_ANALYSE_PACKAGING.equals(this.project.getPackaging()));
        MojoUtils.setParameter((Object)this, "installConvertedCP", false);
        MojoUtils.setParameter((Object)this, "contentPackages", this.getContentPackages());
        MojoUtils.setParameter((Object)this, "convertedCPOutput", this.getCPConversionDir());
        MojoUtils.setParameter((Object)this, "fmOutput", this.getGeneratedFeaturesDir());
        MojoUtils.setParameter((Object)this, "exportToApiRegion", "global");
        if (this.unitTestMode) {
            return;
        }
        super.execute();
    }

    private List<ContentPackage> getContentPackages() throws MojoExecutionException {
        if (!AEM_ANALYSE_PACKAGING.equals(this.project.getPackaging())) {
            ContentPackage cp = new ContentPackage();
            cp.setGroupId(this.project.getGroupId());
            cp.setArtifactId(this.project.getArtifactId());
            this.getLog().info((CharSequence)("Taking current project as content package: " + cp));
            return Collections.singletonList(cp);
        }
        ArrayList<ContentPackage> l = new ArrayList<ContentPackage>();
        for (Dependency d : this.project.getDependencies()) {
            if (!"zip".equals(d.getType())) continue;
            ContentPackage cp = new ContentPackage();
            cp.setGroupId(d.getGroupId());
            cp.setArtifactId(d.getArtifactId());
            l.add(cp);
        }
        if (l.isEmpty()) {
            throw new MojoExecutionException("No content packages found for project.");
        }
        this.getLog().info((CharSequence)("Found content packages from dependencies: " + l));
        return l;
    }

    private File getCPConversionDir() {
        return new File(this.project.getBuild().getDirectory() + "/cp-conversion");
    }

    private File getGeneratedFeaturesDir() {
        return new File(this.getCPConversionDir(), "fm.out");
    }
}

