/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import com.adobe.aem.analyser.AemAnalyserUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AemAggregator {
    private static final String SDK_FEATUREMODEL_AUTHOR_CLASSIFIER = "aem-author-sdk";
    private static final String SDK_FEATUREMODEL_PUBLISH_CLASSIFIER = "aem-publish-sdk";
    private static final String FEATUREMODEL_TYPE = "slingosgifeature";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File featureOutputDirectory;
    private ArtifactProvider artifactProvider;
    private FeatureProvider featureProvider;
    private ArtifactId projectId;
    private ArtifactId sdkId;
    private List<ArtifactId> addOnIds;

    public ArtifactProvider getArtifactProvider() {
        return this.artifactProvider;
    }

    public void setArtifactProvider(ArtifactProvider artifactProvider) {
        this.artifactProvider = artifactProvider;
    }

    public FeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(FeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    public ArtifactId getProjectId() {
        return this.projectId;
    }

    public void setProjectId(ArtifactId projectId) {
        this.projectId = projectId;
    }

    public File getFeatureOutputDirectory() {
        return this.featureOutputDirectory;
    }

    public void setFeatureOutputDirectory(File featureOutputDirectory) {
        this.featureOutputDirectory = featureOutputDirectory;
    }

    public ArtifactId getSdkId() {
        return this.sdkId;
    }

    public void setSdkId(ArtifactId sdkId) {
        this.sdkId = sdkId;
    }

    public List<ArtifactId> getAddOnIds() {
        return this.addOnIds;
    }

    public void setAddOnIds(List<ArtifactId> addOnIds) {
        this.addOnIds = addOnIds;
    }

    public List<Feature> aggregate() throws IOException {
        Map<String, Feature> projectFeatures = this.readFeatures();
        Map<String, List<Feature>> userAggregates = this.getUserAggregates(projectFeatures);
        this.aggregate(userAggregates, Mode.USER, projectFeatures);
        Map<String, List<Feature>> productAggregates = this.getProductAggregates();
        this.aggregate(productAggregates, Mode.PRODUCT, projectFeatures);
        Map<String, List<Feature>> finalAggregates = this.getFinalAggregates(userAggregates, projectFeatures);
        return this.aggregate(finalAggregates, Mode.FINAL, projectFeatures);
    }

    private Map<String, Feature> readFeatures() throws IOException {
        HashMap<String, Feature> result = new HashMap<String, Feature>();
        for (File f : this.getFeatureOutputDirectory().listFiles()) {
            if (!f.getName().endsWith(".json") || f.getName().startsWith(".")) continue;
            this.logger.info("Reading feature {}...", (Object)f.getName());
            try (FileReader reader = new FileReader(f);){
                Feature feature = FeatureJSONReader.read((Reader)reader, (String)f.getName());
                result.put(f.getName(), feature);
            }
        }
        return result;
    }

    private Properties getRunmodeMappings() throws IOException {
        File mappingFile = new File(this.featureOutputDirectory, "runmode.mapping");
        if (!mappingFile.isFile()) {
            throw new IOException("File generated by content package to feature model converter not found: " + mappingFile);
        }
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(mappingFile);){
            p.load(is);
        }
        return p;
    }

    Map<String, List<Feature>> getUserAggregates(Map<String, Feature> projectFeatures) throws IOException {
        Properties runmodes = this.getRunmodeMappings();
        HashMap<String, List<Feature>> aggregates = new HashMap<String, List<Feature>>();
        Map<String, Set<String>> toCreate = this.getUserAggregatesToCreate(runmodes);
        for (Map.Entry<String, Set<String>> entry : toCreate.entrySet()) {
            String name = "user-aggregated-".concat(entry.getKey());
            List list = aggregates.computeIfAbsent(name, n -> new ArrayList());
            entry.getValue().forEach(n -> list.add((Feature)projectFeatures.get(n)));
        }
        return aggregates;
    }

    Map<String, Set<String>> getUserAggregatesToCreate(Properties runmodes) throws IOException {
        try {
            return AemAnalyserUtil.getAggregates(runmodes);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
    }

    Map<String, List<Feature>> getProductAggregates() throws IOException {
        HashMap<String, List<Feature>> aggregates = new HashMap<String, List<Feature>>();
        for (boolean isAuthor : new boolean[]{true, false}) {
            String aggClassifier = this.getProductAggregateName(isAuthor);
            List list = aggregates.computeIfAbsent(aggClassifier, n -> new ArrayList());
            Feature sdkFeature = this.getFeatureProvider().provide(this.getSdkId().changeClassifier(isAuthor ? SDK_FEATUREMODEL_AUTHOR_CLASSIFIER : SDK_FEATUREMODEL_PUBLISH_CLASSIFIER).changeType(FEATUREMODEL_TYPE));
            if (sdkFeature == null) {
                throw new IOException("Unable to find SDK feature for " + this.getSdkId().toMvnId());
            }
            list.add(sdkFeature);
            if (this.getAddOnIds() == null) continue;
            for (ArtifactId id : this.getAddOnIds()) {
                Feature feature = this.getFeatureProvider().provide(id);
                if (feature == null) {
                    throw new IOException("Unable to find addon feature for " + id.toMvnId());
                }
                list.add(feature);
            }
        }
        return aggregates;
    }

    Map<String, List<Feature>> getFinalAggregates(Map<String, List<Feature>> userAggregate, Map<String, Feature> projectFeatures) throws IOException {
        HashMap<String, List<Feature>> aggregates = new HashMap<String, List<Feature>>();
        for (String name : userAggregate.keySet()) {
            boolean isAuthor = name.startsWith("user-aggregated-author");
            String classifier = name.substring(5);
            List list = aggregates.computeIfAbsent(classifier, n -> new ArrayList());
            list.add(projectFeatures.get(this.getProductAggregateName(isAuthor)));
            list.add(projectFeatures.get(name));
        }
        return aggregates;
    }

    private String getProductAggregateName(boolean author) {
        return "product-aggregated-" + (author ? "author" : "publish");
    }

    List<Feature> aggregate(Map<String, List<Feature>> aggregates, Mode mode, final Map<String, Feature> projectFeatures) throws IOException {
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Map.Entry<String, List<Feature>> aggregate : aggregates.entrySet()) {
            this.logger.info("Building aggregate {}...", (Object)aggregate.getKey());
            BuilderContext builderContext = new BuilderContext(new FeatureProvider(){

                public Feature provide(ArtifactId id) {
                    for (Feature feat : projectFeatures.values()) {
                        if (!feat.getId().equals((Object)id)) continue;
                        return feat;
                    }
                    return AemAggregator.this.getFeatureProvider().provide(id);
                }
            });
            builderContext.setArtifactProvider(this.getArtifactProvider());
            builderContext.addMergeExtensions((MergeHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(MergeHandler.class).iterator(), 16), false).toArray(MergeHandler[]::new)).addPostProcessExtensions((PostProcessHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(PostProcessHandler.class).iterator(), 16), false).toArray(PostProcessHandler[]::new));
            if (mode == Mode.USER || mode == Mode.PRODUCT) {
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:*:HIGHEST"));
            } else if (mode == Mode.FINAL) {
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"com.adobe.cq:core.wcm.components.core:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"com.adobe.cq:core.wcm.components.extensions.amp:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"org.apache.sling:org.apache.sling.models.impl:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:core.wcm.components.content:zip:*:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:core.wcm.components.extensions.amp.content:zip:*:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:*:jar:*:ALL"));
            }
            builderContext.addConfigsOverrides(Collections.singletonMap("*", "MERGE_LATEST"));
            ArtifactId newFeatureID = this.getProjectId().changeClassifier(aggregate.getKey()).changeType(FEATUREMODEL_TYPE);
            Feature feature = FeatureBuilder.assemble((ArtifactId)newFeatureID, (BuilderContext)builderContext, (Feature[])aggregate.getValue().toArray(new Feature[aggregate.getValue().size()]));
            try (FileWriter writer = new FileWriter(new File(this.getFeatureOutputDirectory(), aggregate.getKey().concat(".json")));){
                FeatureJSONWriter.write((Writer)writer, (Feature)feature);
            }
            projectFeatures.put(aggregate.getKey(), feature);
            result.add(feature);
        }
        return result;
    }

    public static enum Mode {
        USER,
        PRODUCT,
        FINAL;

    }
}

