/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import com.adobe.aem.analyser.AemAnalyser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class AemAnalyserUtil {
    private static final Map<String, String> INVALID_MODES = new HashMap<String, String>();
    static final List<String> USED_MODES;
    private static final String DEFAULT_MODE = "(default)";

    static String getValidRunMode(String mode) {
        return INVALID_MODES.get(mode);
    }

    public static boolean isRunModeUsed(String mode) {
        return USED_MODES.contains(mode);
    }

    public static Map<String, Set<String>> getAggregates(Properties runmodes) {
        HashMap<String, Set<String>> allModels = new HashMap<String, Set<String>>();
        for (String mode : USED_MODES) {
            allModels.put(mode, new HashSet());
        }
        Object defaultFm = runmodes.remove(DEFAULT_MODE);
        if (defaultFm != null) {
            allModels.values().stream().forEach(s -> s.add(defaultFm.toString()));
        }
        for (String mode : runmodes.stringPropertyNames()) {
            String key;
            Set models = (Set)allModels.get(mode);
            boolean valid = false;
            if (models != null) {
                models.add(runmodes.getProperty(mode));
                for (String ap : new String[]{".dev", ".stage", ".prod"}) {
                    key = mode.concat(ap);
                    models = (Set)allModels.get(key);
                    if (models == null) continue;
                    models.add(runmodes.getProperty(mode));
                }
                valid = true;
            } else {
                for (String ap : new String[]{"author.", "publish."}) {
                    key = ap.concat(mode);
                    models = (Set)allModels.get(key);
                    if (models == null) continue;
                    models.add(runmodes.getProperty(mode));
                    valid = true;
                }
            }
            if (valid) continue;
            String validMode = AemAnalyserUtil.getValidRunMode(mode);
            if (validMode != null) {
                throw new IllegalArgumentException("Invalid runmode " + mode + ". Please use this runmode instead: " + validMode);
            }
            LoggerFactory.getLogger((String)AemAnalyser.class.getName()).info("Ignoring unused runmode " + mode);
        }
        AemAnalyserUtil.pruneModels(allModels);
        return allModels;
    }

    static void pruneModels(Map<String, Set<String>> allModels) {
        for (String ap : new String[]{"author", "publish"}) {
            for (String env : new String[]{".dev", ".stage", ".prod"}) {
                String mode = ap + env;
                if (!allModels.get(ap).equals(allModels.get(mode))) continue;
                allModels.remove(mode);
            }
        }
        block2: for (String ap : new String[]{"author", "publish"}) {
            for (String env : new String[]{".dev", ".stage", ".prod"}) {
                if (!allModels.containsKey(ap + env)) continue block2;
            }
            allModels.remove(ap);
        }
    }

    static {
        INVALID_MODES.put("dev.author", "author.dev");
        INVALID_MODES.put("stage.author", "author.stage");
        INVALID_MODES.put("prod.author", "author.dev");
        INVALID_MODES.put("dev.publish", "publish.dev");
        INVALID_MODES.put("stage.publish", "publish.stage");
        INVALID_MODES.put("prod.publish", "publish.prod");
        USED_MODES = Arrays.asList("author", "author.dev", "author.stage", "author.prod", "publish", "publish.dev", "publish.stage", "publish.prod");
    }
}

