/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.AemAggregator;
import com.adobe.aem.analyser.AemAnalyser;
import com.adobe.aem.analyser.AemAnalyserResult;
import com.adobe.aem.analyser.AemPackageConverter;
import com.adobe.aem.analyser.mojos.Addon;
import com.adobe.aem.analyser.mojos.VersionUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadataSource;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.io.artifacts.ArtifactManager;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.io.json.FeatureJSONReader;

public class AemAnalyseMojo
extends AbstractMojo {
    @Parameter(property="sdkArtifactId")
    String sdkArtifactId;
    @Parameter(required=false, property="sdkVersion")
    String sdkVersion;
    @Parameter(required=false, defaultValue="false", property="sdkUseDependency")
    boolean useDependencyVersions;
    @Parameter
    List<Addon> addons;
    @Parameter(defaultValue="requirements-capabilities,bundle-content,bundle-resources,bundle-nativecode,api-regions,api-regions-check-order,api-regions-crossfeature-dups,api-regions-exportsimports,repoinit,configuration-api,region-deprecated-api", property="analyserTasks")
    List<String> analyserTasks;
    @Parameter
    Map<String, Properties> analyserTaskConfigurations;
    @Parameter(defaultValue="false", property="aem.analyser.skip")
    boolean skip;
    @Parameter(defaultValue="true", property="failon.analyser.errors")
    private boolean failOnAnalyserErrors;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    private org.apache.maven.artifact.metadata.ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    private final Map<String, Artifact> artifactCache = new ConcurrentHashMap<String, Artifact>();

    private File getConversionOutputDir() {
        return new File(this.project.getBuild().getDirectory().concat(File.separator).concat("cp-conversion"));
    }

    private File getGeneratedFeaturesDir() {
        return new File(this.getConversionOutputDir(), "fm.out");
    }

    boolean skipRun() {
        boolean skipExecution;
        String skipVar = System.getenv("CM_PROGRAM_ID");
        boolean bl = skipExecution = skipVar != null && skipVar.length() > 0;
        if (skipExecution) {
            this.getLog().info((CharSequence)"Skipping AEM analyser plugin as variable CM_PROGRAM_ID is set.");
        } else if (this.skip) {
            skipExecution = true;
            this.getLog().info((CharSequence)"Skipping AEM analyser plugin as configured.");
        }
        return skipExecution;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipRun()) {
            return;
        }
        VersionUtil versionUtil = new VersionUtil(this.getLog(), this.project, this.artifactHandlerManager, (ArtifactMetadataSource)this.artifactMetadataSource, this.remoteArtifactRepositories, this.localRepository);
        ArtifactId sdkId = versionUtil.getSDKArtifactId(this.sdkArtifactId, this.sdkVersion, this.useDependencyVersions);
        List<ArtifactId> addons = versionUtil.discoverAddons(this.addons, this.useDependencyVersions);
        this.convertContentPackages();
        List<Feature> features = this.aggregateFeatureModels(sdkId, addons);
        this.analyseFeatures(features, versionUtil.getVersionWarnings());
    }

    void convertContentPackages() throws MojoExecutionException {
        AemPackageConverter converter = new AemPackageConverter();
        converter.setArtifactIdOverride(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, "slingosgifeature").toMvnId());
        converter.setConverterOutputDirectory(this.getConversionOutputDir());
        converter.setFeatureOutputDirectory(this.getGeneratedFeaturesDir());
        for (Artifact contentPackage : this.getContentPackages()) {
            File source = contentPackage.getFile();
            try {
                converter.convert(Collections.singletonMap(contentPackage.toString(), source));
            }
            catch (IOException t) {
                throw new MojoExecutionException("Content Package Converter Exception " + t.getMessage(), (Exception)t);
            }
        }
    }

    private List<Artifact> getContentPackages() throws MojoExecutionException {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        if (!"aem-analyse".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Using current project as content package: " + this.project.getArtifact()));
            result.add(this.project.getArtifact());
        } else {
            for (Artifact d : this.project.getDependencyArtifacts()) {
                if (!"zip".equals(d.getType()) && !"content-package".equals(d.getType())) continue;
                result.add(d);
            }
            this.getLog().info((CharSequence)("Found content packages from dependencies: " + result));
        }
        if (result.isEmpty()) {
            throw new MojoExecutionException("No content packages found for project.");
        }
        return result;
    }

    List<Feature> aggregateFeatureModels(ArtifactId sdkId, List<ArtifactId> addons) throws MojoExecutionException {
        try {
            AemAggregator a = new AemAggregator();
            a.setFeatureOutputDirectory(this.getGeneratedFeaturesDir());
            a.setArtifactProvider(this.getArtifactProvider());
            a.setFeatureProvider(new FeatureProvider(){

                public Feature provide(ArtifactId id) {
                    return AemAnalyseMojo.this.getOrResolveFeature(id);
                }
            });
            a.setProjectId(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, null));
            a.setSdkId(sdkId);
            a.setAddOnIds(addons);
            return a.aggregate();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    void analyseFeatures(List<Feature> features, List<String> additionalWarnings) throws MojoFailureException, MojoExecutionException {
        boolean hasErrors = false;
        try {
            AemAnalyser analyser = new AemAnalyser();
            analyser.setArtifactProvider(this.getArtifactProvider());
            analyser.setIncludedTasks(this.getAnalyserTasks());
            analyser.setTaskConfigurations(this.getAnalyserTaskConfigurations());
            AemAnalyserResult result = analyser.analyse(features);
            for (String msg : additionalWarnings) {
                this.getLog().warn((CharSequence)msg);
            }
            for (String msg : result.getWarnings()) {
                this.getLog().warn((CharSequence)msg);
            }
            for (String msg : result.getErrors()) {
                this.getLog().error((CharSequence)msg);
            }
            hasErrors = result.hasErrors();
        }
        catch (Exception e) {
            throw new MojoExecutionException("A fatal error occurred while analysing the features, see error cause:", e);
        }
        if (hasErrors) {
            if (this.failOnAnalyserErrors) {
                throw new MojoFailureException("One or more feature analyser(s) detected feature error(s), please read the plugin log for more details");
            }
            this.getLog().warn((CharSequence)"Errors found during analyser run, but this plugin is configured to ignore errors and continue the build!");
        }
    }

    ArtifactProvider getArtifactProvider() throws IOException {
        final ArtifactProvider localProvider = this.getLocalArtifactProvider();
        return new ArtifactProvider(){

            public URL provide(ArtifactId id) {
                URL url = localProvider.provide(id);
                if (url != null) {
                    return url;
                }
                try {
                    return AemAnalyseMojo.this.getOrResolveArtifact(id).getFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    AemAnalyseMojo.this.getLog().debug((CharSequence)("Malformed url " + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
        };
    }

    Map<String, Map<String, String>> getAnalyserTaskConfigurations() {
        HashMap<String, Map<String, String>> config = new HashMap<String, Map<String, String>>();
        if (this.analyserTaskConfigurations != null) {
            for (Map.Entry<String, Properties> entry : this.analyserTaskConfigurations.entrySet()) {
                HashMap m = new HashMap();
                entry.getValue().stringPropertyNames().forEach(n -> m.put(n, ((Properties)entry.getValue()).getProperty((String)n)));
                config.put(entry.getKey(), m);
            }
        }
        return config;
    }

    Set<String> getAnalyserTasks() {
        return new LinkedHashSet<String>(this.analyserTasks);
    }

    ArtifactProvider getLocalArtifactProvider() throws IOException {
        ArtifactManagerConfig amcfg = new ArtifactManagerConfig();
        amcfg.setRepositoryUrls(new String[]{this.getConversionOutputDir().toURI().toURL().toString()});
        return ArtifactManager.getArtifactManager((ArtifactManagerConfig)amcfg);
    }

    private static Artifact findArtifact(ArtifactId id, Collection<Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getGroupId().equals(id.getGroupId()) || !artifact.getArtifactId().equals(id.getArtifactId()) || !artifact.getVersion().equals(id.getVersion()) || !artifact.getType().equals(id.getType()) || (id.getClassifier() != null || artifact.getClassifier() != null) && (id.getClassifier() == null || !id.getClassifier().equals(artifact.getClassifier()))) continue;
                return artifact.getFile() == null ? null : artifact;
            }
        }
        return null;
    }

    Artifact getOrResolveArtifact(ArtifactId id) {
        Artifact result = this.artifactCache.get(id.toMvnId());
        if (result == null) {
            result = AemAnalyseMojo.findArtifact(id, this.project.getAttachedArtifacts());
            if (result == null && (result = AemAnalyseMojo.findArtifact(id, this.project.getDependencyArtifacts())) == null) {
                DefaultArtifact prjArtifact = new DefaultArtifact(id.getGroupId(), id.getArtifactId(), VersionRange.createFromVersion((String)id.getVersion()), "provided", id.getType(), id.getClassifier(), this.artifactHandlerManager.getArtifactHandler(id.getType()));
                try {
                    this.artifactResolver.resolve((Artifact)prjArtifact, this.project.getRemoteArtifactRepositories(), this.mavenSession.getLocalRepository());
                }
                catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                    throw new RuntimeException("Unable to get artifact for " + id.toMvnId(), e);
                }
                result = prjArtifact;
            }
            this.artifactCache.put(id.toMvnId(), result);
        }
        return result;
    }

    Feature getOrResolveFeature(ArtifactId id) {
        Feature feature;
        File artFile = this.getOrResolveArtifact(id).getFile();
        FileReader reader = new FileReader(artFile);
        try {
            feature = FeatureJSONReader.read((Reader)reader, (String)artFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read feature file " + artFile + " for " + id.toMvnId(), ioe);
            }
        }
        ((Reader)reader).close();
        return feature;
    }
}

