/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.Addon;
import com.adobe.aem.analyser.mojos.Constants;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadataSource;
import org.apache.sling.feature.ArtifactId;

public class VersionUtil {
    private final MavenProject project;
    private final Log log;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final List<ArtifactRepository> remoteArtifactRepositories;
    private final ArtifactRepository localRepository;
    private final List<String> versionWarnings = new ArrayList<String>();

    public VersionUtil(Log log, MavenProject project, ArtifactHandlerManager artifactHandlerManager, ArtifactMetadataSource artifactMetadataSource, List<ArtifactRepository> remoteArtifactRepositories, ArtifactRepository localRepository) {
        this.project = project;
        this.log = log;
        this.artifactHandlerManager = artifactHandlerManager;
        this.artifactMetadataSource = artifactMetadataSource;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.localRepository = localRepository;
    }

    List<String> getVersionWarnings() {
        return this.versionWarnings;
    }

    List<ArtifactId> discoverAddons(List<Addon> addons, boolean useDependencyVersions) throws MojoExecutionException {
        ArrayList<ArtifactId> result = new ArrayList<ArtifactId>();
        for (Addon addon : addons == null ? Constants.DEFAULT_ADDONS : addons) {
            ArtifactId addonSDK = this.getArtifactIdFromDependencies(addon.groupId, addon.artifactId);
            if (addonSDK == null) continue;
            Dependency dep = new Dependency();
            dep.setGroupId(addonSDK.getGroupId());
            dep.setArtifactId(addonSDK.getArtifactId());
            dep.setVersion(addonSDK.getVersion());
            String foundVersion = useDependencyVersions ? null : this.getLatestVersion(dep);
            String useVersion = dep.getVersion();
            if (foundVersion != null && this.isNewer(useVersion, foundVersion)) {
                this.versionWarnings.add("Project is configured with outdated Add-On version : " + dep);
                this.versionWarnings.add("Please update to version : " + foundVersion);
                useVersion = foundVersion;
            }
            addonSDK = addonSDK.changeVersion(useVersion);
            this.log.info((CharSequence)("Using Add-On for analysis: " + addonSDK));
            result.add(addonSDK);
        }
        return result;
    }

    ArtifactId getSDKArtifactId(String configuredArtifactId, String configuredVersion, boolean useDependencyVersions) throws MojoExecutionException {
        ArtifactId result;
        String useArtifactId;
        ArtifactId dependencySdk;
        if (configuredArtifactId != null) {
            if (configuredVersion != null) {
                dependencySdk = new ArtifactId("com.adobe.aem", configuredArtifactId, configuredVersion, null, null);
            } else {
                dependencySdk = this.getArtifactIdFromDependencies("com.adobe.aem", configuredArtifactId);
                if (dependencySdk == null && configuredVersion == null) {
                    throw new MojoExecutionException("Unable to find SDK artifact in dependencies or dependency management: com.adobe.aem:" + configuredArtifactId);
                }
            }
        } else {
            dependencySdk = this.getArtifactIdFromDependencies("com.adobe.aem", "aem-prerelease-sdk-api");
            if (dependencySdk == null) {
                dependencySdk = this.getArtifactIdFromDependencies("com.adobe.aem", "aem-sdk-api");
            }
        }
        String string = useArtifactId = dependencySdk != null ? dependencySdk.getArtifactId() : "aem-sdk-api";
        if (configuredVersion != null) {
            result = new ArtifactId("com.adobe.aem", useArtifactId, configuredVersion, null, null);
            this.log.info((CharSequence)("Using configured SDK Version for analysis: " + result));
        } else {
            String useVersion;
            String foundVersion;
            Dependency dep = new Dependency();
            dep.setGroupId("com.adobe.aem");
            dep.setArtifactId(useArtifactId);
            dep.setVersion(dependencySdk == null ? "1.0" : dependencySdk.getVersion());
            String string2 = foundVersion = useDependencyVersions ? null : this.getLatestVersion(dep);
            if (foundVersion == null && dependencySdk == null) {
                throw new MojoExecutionException("Unable to find SDK artifact in dependencies or dependency management: com.adobe.aem:" + useArtifactId);
            }
            String string3 = useVersion = dependencySdk != null ? dependencySdk.getVersion() : null;
            if (dependencySdk != null && foundVersion != null && this.isNewer(useVersion, foundVersion)) {
                this.versionWarnings.add("Project is configured with outdated SDK version : " + dependencySdk.getVersion());
                this.versionWarnings.add("Please update to SDK version : " + foundVersion);
                useVersion = foundVersion;
            }
            result = new ArtifactId("com.adobe.aem", useArtifactId, useVersion, null, null);
            this.log.info((CharSequence)("Using detected SDK Version for analysis: " + result));
        }
        return result;
    }

    private boolean isNewer(String existingVersion, String foundVersion) {
        if (foundVersion == null) {
            return false;
        }
        DefaultArtifactVersion fv = new DefaultArtifactVersion(foundVersion);
        DefaultArtifactVersion ev = new DefaultArtifactVersion(existingVersion);
        return fv.compareTo((Object)ev) > 0;
    }

    ArtifactId getArtifactIdFromDependencies(String groupId, String artifactId) throws MojoExecutionException {
        ArrayList allDependencies = new ArrayList();
        if (this.project.getDependencies() != null) {
            allDependencies.addAll(this.project.getDependencies());
        }
        if (this.project.getDependencyManagement() != null && this.project.getDependencyManagement().getDependencies() != null) {
            allDependencies.addAll(this.project.getDependencyManagement().getDependencies());
        }
        for (Dependency d : allDependencies) {
            if (!groupId.equals(d.getGroupId()) || !artifactId.equals(d.getArtifactId())) continue;
            return new ArtifactId(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), d.getType());
        }
        return null;
    }

    String getLatestVersion(Dependency dependency) throws MojoExecutionException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), "provided", dependency.getType(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()));
            List versions = this.artifactMetadataSource.retrieveAvailableVersions((Artifact)artifact, this.localRepository, this.remoteArtifactRepositories);
            Object latest = null;
            for (ArtifactVersion candidate : versions) {
                if (ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
                if (latest == null) {
                    latest = candidate;
                    continue;
                }
                if (candidate.compareTo(latest) <= 0) continue;
                latest = candidate;
            }
            return latest != null ? latest.toString() : null;
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

