/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.DefaultAclManager;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.LocalMavenRepositoryArtifactsDeployer;
import org.apache.sling.feature.cpconverter.features.DefaultFeaturesManager;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.RegexBasedResourceFilter;
import org.apache.sling.feature.cpconverter.filtering.ResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.DefaultEntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.vltpkg.DefaultPackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AemPackageConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FILTER = ".*/(apps|libs)/(.*)/install\\.(((author|publish)\\.(dev|stage|prod))|((dev|stage|prod)\\.(author|publish))|(dev|stage|prod))/(.*)(?<=\\.(zip|jar)$)";
    private File featureOutputDirectory;
    private File converterOutputDirectory;
    private String artifactIdOverride;

    public File getFeatureOutputDirectory() {
        return this.featureOutputDirectory;
    }

    public void setFeatureOutputDirectory(File featureOutputDirectory) {
        this.featureOutputDirectory = featureOutputDirectory;
    }

    public File getConverterOutputDirectory() {
        return this.converterOutputDirectory;
    }

    public void setConverterOutputDirectory(File converterOutputDirectory) {
        this.converterOutputDirectory = converterOutputDirectory;
    }

    public String getArtifactIdOverride() {
        return this.artifactIdOverride;
    }

    public void setArtifactIdOverride(String artifactIdOverride) {
        this.artifactIdOverride = artifactIdOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(Map<String, File> contentPackages) throws IOException {
        HashMap properties = new HashMap();
        DefaultAclManager aclManager = new DefaultAclManager(null, "system");
        DefaultFeaturesManager featuresManager = new DefaultFeaturesManager(false, 20, this.featureOutputDirectory, this.artifactIdOverride, null, properties, (AclManager)aclManager);
        featuresManager.setExportToAPIRegion("global");
        ContentPackage2FeatureModelConverter converter = new ContentPackage2FeatureModelConverter(false).setFeaturesManager((FeaturesManager)featuresManager).setBundlesDeployer((ArtifactsDeployer)new LocalMavenRepositoryArtifactsDeployer(this.converterOutputDirectory)).setEntryHandlersManager((EntryHandlersManager)new DefaultEntryHandlersManager(Collections.emptyMap(), false, ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.KEEP)).setAclManager((AclManager)new DefaultAclManager()).setEmitter((PackagesEventsEmitter)DefaultPackagesEventsEmitter.open((File)this.featureOutputDirectory)).setResourceFilter(this.getResourceFilter());
        try {
            for (Map.Entry<String, File> entry : contentPackages.entrySet()) {
                this.logger.info("Converting package {}", (Object)entry.getKey());
                try {
                    converter.convert(new File[]{entry.getValue()});
                }
                catch (Throwable t) {
                    throw new IOException("Content Package Converter Exception " + t.getMessage(), t);
                    return;
                }
            }
        }
        finally {
            converter.cleanup();
        }
    }

    private ResourceFilter getResourceFilter() {
        RegexBasedResourceFilter filter = new RegexBasedResourceFilter();
        filter.addFilteringPattern(FILTER);
        return filter;
    }
}

