/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.Addon;
import com.adobe.aem.analyser.mojos.Constants;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.ArtifactId;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;

public class VersionUtil {
    private static final String PLUGIN_TYPE = "maven-plugin";
    private final MavenProject project;
    private final Log log;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final List<String> versionWarnings = new ArrayList<String>();
    private final boolean isOffline;

    public VersionUtil(Log log, MavenProject project, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repoSystem, RepositorySystemSession repoSession, boolean isOffline) {
        this.project = project;
        this.log = log;
        this.artifactHandlerManager = artifactHandlerManager;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.isOffline = isOffline;
    }

    List<String> getVersionWarnings() {
        return this.versionWarnings;
    }

    List<ArtifactId> discoverAddons(List<Addon> addons, boolean useDependencyVersions) throws MojoExecutionException {
        ArrayList<ArtifactId> result = new ArrayList<ArtifactId>();
        for (Addon addon : addons == null ? Constants.DEFAULT_ADDONS : addons) {
            ArtifactId addonSDK = this.getArtifactIdFromDependencies(addon.groupId, addon.artifactId);
            if (addonSDK == null) continue;
            Dependency dep = new Dependency();
            dep.setGroupId(addonSDK.getGroupId());
            dep.setArtifactId(addonSDK.getArtifactId());
            dep.setVersion(addonSDK.getVersion());
            String foundVersion = useDependencyVersions ? null : this.getLatestVersion(dep);
            String useVersion = dep.getVersion();
            if (foundVersion != null && this.isNewer(useVersion, foundVersion)) {
                this.versionWarnings.add("Project is configured with outdated Add-On version : " + dep);
                this.versionWarnings.add("Please update to version : " + foundVersion);
                useVersion = foundVersion;
            }
            addonSDK = addonSDK.changeVersion(useVersion);
            if (addon.classifier != null) {
                addonSDK = addonSDK.changeClassifier(addon.classifier);
            }
            this.log.info((CharSequence)("Using Add-On for analysis: " + addonSDK));
            result.add(addonSDK);
        }
        return result;
    }

    ArtifactId getSDKArtifactId(String configuredArtifactId, String configuredVersion, boolean useDependencyVersions) throws MojoExecutionException {
        ArtifactId result;
        String useArtifactId;
        ArtifactId dependencySdk;
        if (configuredArtifactId != null) {
            if (configuredVersion != null) {
                dependencySdk = new ArtifactId("com.adobe.aem", configuredArtifactId, configuredVersion, null, null);
            } else {
                dependencySdk = this.getArtifactIdFromDependencies("com.adobe.aem", configuredArtifactId);
                if (dependencySdk == null && configuredVersion == null) {
                    throw new MojoExecutionException("Unable to find SDK artifact in dependencies or dependency management: com.adobe.aem:" + configuredArtifactId);
                }
            }
        } else {
            dependencySdk = this.getArtifactIdFromDependencies("com.adobe.aem", "aem-prerelease-sdk-api");
            if (dependencySdk == null) {
                dependencySdk = this.getArtifactIdFromDependencies("com.adobe.aem", "aem-sdk-api");
            }
        }
        String string = useArtifactId = dependencySdk != null ? dependencySdk.getArtifactId() : "aem-sdk-api";
        if (configuredVersion != null) {
            result = new ArtifactId("com.adobe.aem", useArtifactId, configuredVersion, null, null);
            this.log.info((CharSequence)("Using configured SDK Version for analysis: " + result));
        } else {
            String useVersion;
            String foundVersion;
            Dependency dep = new Dependency();
            dep.setGroupId("com.adobe.aem");
            dep.setArtifactId(useArtifactId);
            dep.setVersion(dependencySdk == null ? "1.0" : dependencySdk.getVersion());
            String string2 = foundVersion = useDependencyVersions ? null : this.getLatestVersion(dep);
            if (foundVersion == null && dependencySdk == null) {
                throw new MojoExecutionException("Unable to find SDK artifact in dependencies or dependency management: com.adobe.aem:" + useArtifactId);
            }
            String string3 = useVersion = dependencySdk != null ? dependencySdk.getVersion() : foundVersion;
            if (dependencySdk != null && foundVersion != null && this.isNewer(useVersion, foundVersion)) {
                this.versionWarnings.add("Project is configured with outdated SDK version : " + dependencySdk.getVersion());
                this.versionWarnings.add("Please update to SDK version : " + foundVersion);
                useVersion = foundVersion;
            }
            result = new ArtifactId("com.adobe.aem", useArtifactId, useVersion, null, null);
            this.log.info((CharSequence)("Using detected SDK Version for analysis: " + result));
        }
        return result;
    }

    private boolean isNewer(String existingVersion, String foundVersion) {
        if (foundVersion == null) {
            return false;
        }
        DefaultArtifactVersion fv = new DefaultArtifactVersion(foundVersion);
        DefaultArtifactVersion ev = new DefaultArtifactVersion(existingVersion);
        return fv.compareTo((Object)ev) > 0;
    }

    ArtifactId getArtifactIdFromDependencies(String groupId, String artifactId) throws MojoExecutionException {
        ArrayList allDependencies = new ArrayList();
        if (this.project.getDependencies() != null) {
            allDependencies.addAll(this.project.getDependencies());
        }
        if (this.project.getDependencyManagement() != null && this.project.getDependencyManagement().getDependencies() != null) {
            allDependencies.addAll(this.project.getDependencyManagement().getDependencies());
        }
        for (Dependency d : allDependencies) {
            if (!groupId.equals(d.getGroupId()) || !artifactId.equals(d.getArtifactId())) continue;
            return new ArtifactId(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), d.getType());
        }
        return null;
    }

    String getLatestVersion(Dependency dependency) throws MojoExecutionException {
        if (this.isOffline) {
            this.versionWarnings.add("Plugin is used in offline mode, checking for latest version for " + dependency + " is disabled.");
            return null;
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()).getExtension(), "RELEASE");
        List<RemoteRepository> repositories = this.getRemoteRepositoriesWithUpdatePolicy(PLUGIN_TYPE.equals(dependency.getType()) ? this.project.getRemotePluginRepositories() : this.project.getRemoteProjectRepositories(), "always");
        VersionRequest versionRequest = new VersionRequest((Artifact)artifact, repositories, null);
        try {
            VersionResult result = this.repoSystem.resolveVersion(this.repoSession, versionRequest);
            return result.getVersion();
        }
        catch (VersionResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private List<RemoteRepository> getRemoteRepositoriesWithUpdatePolicy(List<RemoteRepository> repositories, String updatePolicy) {
        ArrayList<RemoteRepository> newRepositories = new ArrayList<RemoteRepository>();
        for (RemoteRepository repo : repositories) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repo);
            RepositoryPolicy newPolicy = new RepositoryPolicy(repo.getPolicy(false).isEnabled(), updatePolicy, repo.getPolicy(false).getChecksumPolicy());
            builder.setPolicy(newPolicy);
            newRepositories.add(builder.build());
        }
        return newRepositories;
    }

    public void checkPluginVersion(String groupId, String artifactId, String version) throws MojoExecutionException {
        Dependency pluginDependency = new Dependency();
        pluginDependency.setGroupId(groupId);
        pluginDependency.setArtifactId(artifactId);
        pluginDependency.setVersion(version);
        pluginDependency.setType(PLUGIN_TYPE);
        String latestVersion = this.getLatestVersion(pluginDependency);
        if (latestVersion != null && this.isNewer(version, latestVersion)) {
            this.versionWarnings.add("Project is configured with outdated aemanalyser plugin version : " + version);
            this.versionWarnings.add("Please update to plugin version : " + latestVersion);
        }
    }
}

