/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.AemAggregator;
import com.adobe.aem.analyser.AemAnalyser;
import com.adobe.aem.analyser.AemAnalyserResult;
import com.adobe.aem.analyser.AemPackageConverter;
import com.adobe.aem.analyser.mojos.Addon;
import com.adobe.aem.analyser.mojos.VersionUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.io.artifacts.ArtifactManager;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class AemAnalyseMojo
extends AbstractMojo {
    @Parameter(property="sdkArtifactId")
    String sdkArtifactId;
    @Parameter(required=false, property="sdkVersion")
    String sdkVersion;
    @Parameter(required=false, defaultValue="false", property="sdkUseDependency")
    boolean useDependencyVersions;
    @Parameter
    List<Addon> addons;
    @Parameter(defaultValue="requirements-capabilities,api-regions,api-regions-check-order,api-regions-crossfeature-dups,api-regions-exportsimports,region-deprecated-api", property="analyserTasks")
    List<String> analyserTasks;
    @Parameter(property="skipAnalyserTasks")
    List<String> skipAnalyserTasks;
    @Parameter(defaultValue="bundle-content,bundle-resources,bundle-nativecode,bundle-unversioned-packages,artifact-rules,configuration-api,aem-env-var,repoinit,content-packages-validation", property="analyserUserTasks")
    List<String> analyserUserTasks;
    @Parameter(property="skipAnalyserUserTasks")
    List<String> skipAnalyserUserTasks;
    @Parameter
    Map<String, Properties> analyserTaskConfigurations;
    @Parameter(defaultValue="false", property="aem.analyser.skip")
    boolean skip;
    @Parameter(defaultValue="true", property="failon.analyser.errors")
    private boolean failOnAnalyserErrors;
    @Parameter(property="aem.analyser.classifier")
    private String classifier;
    @Parameter
    private List<File> contentPackageFiles;
    @Parameter(defaultValue="false", property="aem.analyser.strict")
    private boolean strictValidation;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    private final Map<String, Artifact> artifactCache = new ConcurrentHashMap<String, Artifact>();

    private File getConversionOutputDir() {
        return new File(this.project.getBuild().getDirectory().concat(File.separator).concat("cp-conversion"));
    }

    private File getGeneratedFeaturesDir() {
        return new File(this.getConversionOutputDir(), "fm.out");
    }

    boolean skipRun() {
        boolean skipExecution;
        String skipVar = System.getenv("CM_PROGRAM_ID");
        boolean bl = skipExecution = skipVar != null && skipVar.length() > 0;
        if (skipExecution) {
            this.getLog().info((CharSequence)"Skipping AEM analyser plugin as variable CM_PROGRAM_ID is set.");
        } else if (this.skip) {
            skipExecution = true;
            this.getLog().info((CharSequence)"Skipping AEM analyser plugin as configured.");
        }
        return skipExecution;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipRun()) {
            return;
        }
        VersionUtil versionUtil = new VersionUtil(this.getLog(), this.project, this.artifactHandlerManager, this.repoSystem, this.repoSession, this.mavenSession.isOffline());
        versionUtil.checkPluginVersion(this.plugin.getGroupId(), this.plugin.getArtifactId(), this.plugin.getVersion());
        ArtifactId sdkId = versionUtil.getSDKArtifactId(this.sdkArtifactId, this.sdkVersion, this.useDependencyVersions);
        List<ArtifactId> addons = versionUtil.discoverAddons(this.addons, this.useDependencyVersions);
        for (String msg : versionUtil.getVersionWarnings()) {
            this.getLog().warn((CharSequence)msg);
        }
        ArrayList<String> additionalWarnings = new ArrayList<String>();
        additionalWarnings.addAll(versionUtil.getVersionWarnings());
        ArrayList<String> additionalErrors = new ArrayList<String>();
        this.convertContentPackages(additionalWarnings, additionalErrors);
        try (ArtifactManager artifactManager = this.getArtifactManager();){
            ArtifactProvider compositeArtifactProvider = this.getCompositeArtifactProvider(artifactManager);
            List<Feature> features = this.aggregateFeatureModels(sdkId, addons, compositeArtifactProvider);
            this.analyseFeatures(features, additionalWarnings, additionalErrors, compositeArtifactProvider);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    void convertContentPackages(List<String> additionalWarnings, List<String> additionalErrors) throws MojoExecutionException {
        AemPackageConverter converter = new AemPackageConverter();
        converter.setArtifactIdOverride(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, "slingosgifeature").toMvnId());
        converter.setConverterOutputDirectory(this.getConversionOutputDir());
        converter.setFeatureOutputDirectory(this.getGeneratedFeaturesDir());
        LinkedHashMap<String, File> packages = new LinkedHashMap<String, File>();
        for (Artifact contentPackage : this.getContentPackages()) {
            File source = contentPackage.getFile();
            packages.put(contentPackage.getId().toString(), source);
        }
        try {
            converter.convert(packages);
        }
        catch (ConverterException ce) {
            this.getLog().error((CharSequence)ce.getMessage());
            throw new MojoExecutionException(ce.getMessage());
        }
        catch (IOException t) {
            throw new MojoExecutionException("Content Package Converter Exception " + t.getMessage(), (Exception)t);
        }
    }

    private List<Artifact> getContentPackages() throws MojoExecutionException {
        if (!"aem-analyse".equals(this.project.getPackaging())) {
            if (this.contentPackageFiles != null && !this.contentPackageFiles.isEmpty()) {
                this.validateContentPackageFiles(this.contentPackageFiles);
                return this.contentPackageFiles.stream().map(this::contentPackageFileToArtifact).collect(Collectors.toList());
            }
            if (this.classifier != null) {
                for (Artifact artifact : this.project.getAttachedArtifacts()) {
                    if (!this.classifier.equals(artifact.getClassifier())) continue;
                    this.getLog().info((CharSequence)("Using attached artifact with classifier '" + this.classifier + "' as content package: " + this.project.getArtifact()));
                    return Collections.singletonList(artifact);
                }
                throw new MojoExecutionException("No attached artifact with classifier " + this.classifier + " found for project.");
            }
            this.getLog().info((CharSequence)("Using current project as content package: " + this.project.getArtifact()));
            return Collections.singletonList(this.project.getArtifact());
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Dependency d : this.project.getDependencies()) {
            if (!"zip".equals(d.getType()) && !"content-package".equals(d.getType())) continue;
            Artifact artifact = this.getOrResolveArtifact(new ArtifactId(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), d.getType()));
            result.add(artifact);
        }
        if (result.isEmpty()) {
            throw new MojoExecutionException("No content packages found for project.");
        }
        this.getLog().info((CharSequence)("Found content packages from dependencies: " + result));
        return result;
    }

    private void validateContentPackageFiles(List<File> files) throws MojoExecutionException {
        for (File file : files) {
            try {
                if (!file.exists()) {
                    throw new MojoExecutionException("File not found: " + file.getAbsolutePath());
                }
                if (FileUtils.directoryContains((File)this.project.getBasedir(), (File)file)) continue;
                throw new MojoExecutionException("File not inside project directory: " + file.getAbsolutePath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error validation file: " + file.getAbsolutePath(), (Exception)ex);
            }
        }
    }

    private Artifact contentPackageFileToArtifact(File file) {
        String fileClassifier = "hash-" + file.getPath().hashCode();
        String type = "zip";
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(type);
        org.apache.maven.artifact.DefaultArtifact fileArtifact = new org.apache.maven.artifact.DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, type, fileClassifier, artifactHandler);
        fileArtifact.setFile(file);
        return fileArtifact;
    }

    List<Feature> aggregateFeatureModels(ArtifactId sdkId, List<ArtifactId> addons, ArtifactProvider artifactProvider) throws MojoExecutionException {
        try {
            AemAggregator a = new AemAggregator();
            a.setFeatureOutputDirectory(this.getGeneratedFeaturesDir());
            a.setArtifactProvider(artifactProvider);
            a.setFeatureProvider(new FeatureProvider(){

                public Feature provide(ArtifactId id) {
                    return AemAnalyseMojo.this.getOrResolveFeature(id);
                }
            });
            a.setProjectId(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, null));
            a.setSdkId(sdkId);
            a.setAddOnIds(addons);
            return a.aggregate();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    void analyseFeatures(List<Feature> features, List<String> additionalWarnings, List<String> additionalErrors, ArtifactProvider artifactProvider) throws MojoFailureException, MojoExecutionException {
        boolean hasErrors = false;
        try {
            AemAnalyser analyser = new AemAnalyser();
            analyser.setArtifactProvider(artifactProvider);
            analyser.setIncludedTasks(this.getAnalyserTasks());
            analyser.setIncludedUserTasks(this.getAnalyserUserTasks());
            analyser.setTaskConfigurations(this.getAnalyserTaskConfigurations());
            AemAnalyserResult result = analyser.analyse(features);
            for (String msg2 : additionalWarnings) {
                if (this.strictValidation) {
                    this.getLog().error((CharSequence)msg2);
                    continue;
                }
                this.getLog().warn((CharSequence)msg2);
            }
            for (String msg2 : result.getWarnings()) {
                if (this.strictValidation) {
                    this.getLog().error((CharSequence)msg2);
                    continue;
                }
                this.getLog().warn((CharSequence)msg2);
            }
            additionalErrors.stream().forEach(msg -> this.getLog().error((CharSequence)msg));
            result.getErrors().stream().forEach(msg -> this.getLog().error((CharSequence)msg));
            hasErrors = result.hasErrors() || !additionalErrors.isEmpty() || this.strictValidation && (result.hasWarnings() || !additionalWarnings.isEmpty());
        }
        catch (Exception e) {
            throw new MojoExecutionException("A fatal error occurred while analysing the features, see error cause:", e);
        }
        if (hasErrors) {
            if (this.failOnAnalyserErrors) {
                throw new MojoFailureException("One or more feature analyser(s) detected feature error(s), please read the plugin log for more details");
            }
            this.getLog().warn((CharSequence)"Errors found during analyser run, but this plugin is configured to ignore errors and continue the build!");
        }
    }

    ArtifactProvider getCompositeArtifactProvider(final ArtifactManager artifactManager) throws IOException {
        return new ArtifactProvider(){

            public URL provide(ArtifactId id) {
                URL url = artifactManager.provide(id);
                if (url != null) {
                    return url;
                }
                try {
                    return AemAnalyseMojo.this.getOrResolveArtifact(id).getFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    AemAnalyseMojo.this.getLog().debug((CharSequence)("Malformed url " + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
        };
    }

    Map<String, Map<String, String>> getAnalyserTaskConfigurations() {
        HashMap<String, Map<String, String>> config = new HashMap<String, Map<String, String>>();
        if (this.analyserTaskConfigurations != null) {
            for (Map.Entry<String, Properties> entry : this.analyserTaskConfigurations.entrySet()) {
                HashMap m = new HashMap();
                entry.getValue().stringPropertyNames().forEach(n -> m.put(n, ((Properties)entry.getValue()).getProperty((String)n)));
                config.put(entry.getKey(), m);
            }
        }
        return config;
    }

    Set<String> getAnalyserTasks() {
        return AemAnalyseMojo.getFilteredSet(this.analyserTasks, this.skipAnalyserTasks);
    }

    Set<String> getAnalyserUserTasks() {
        return AemAnalyseMojo.getFilteredSet(this.analyserUserTasks, this.skipAnalyserUserTasks);
    }

    private static Set<String> getFilteredSet(List<String> values, List<String> skipValues) {
        HashSet<String> skipValuesSet = new HashSet<String>(skipValues != null ? skipValues : Collections.emptyList());
        return values.stream().filter(value -> !skipValuesSet.contains(value)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    ArtifactManager getArtifactManager() throws IOException {
        ArtifactManagerConfig amcfg = new ArtifactManagerConfig();
        amcfg.setRepositoryUrls(new String[]{this.getConversionOutputDir().toURI().toURL().toString()});
        return ArtifactManager.getArtifactManager((ArtifactManagerConfig)amcfg);
    }

    private static Artifact findArtifact(ArtifactId id, Collection<Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getGroupId().equals(id.getGroupId()) || !artifact.getArtifactId().equals(id.getArtifactId()) || !artifact.getVersion().equals(id.getVersion()) || !artifact.getType().equals(id.getType()) || (id.getClassifier() != null || artifact.getClassifier() != null) && (id.getClassifier() == null || !id.getClassifier().equals(artifact.getClassifier()))) continue;
                return artifact.getFile() == null ? null : artifact;
            }
        }
        return null;
    }

    Artifact getOrResolveArtifact(ArtifactId id) {
        Artifact result = this.artifactCache.get(id.toMvnId());
        if (result == null) {
            result = AemAnalyseMojo.findArtifact(id, this.project.getAttachedArtifacts());
            if (result == null && (result = AemAnalyseMojo.findArtifact(id, this.project.getArtifacts())) == null) {
                ArtifactRequest req = new ArtifactRequest((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(id.toMvnId()), this.project.getRemoteProjectRepositories(), null);
                try {
                    ArtifactResult resolutionResult = this.repoSystem.resolveArtifact(this.repoSession, req);
                    result = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)resolutionResult.getArtifact());
                }
                catch (ArtifactResolutionException e) {
                    throw new RuntimeException("Unable to get artifact for " + id.toMvnId(), e);
                }
            }
            this.artifactCache.put(id.toMvnId(), result);
        }
        return result;
    }

    Feature getOrResolveFeature(ArtifactId id) {
        Feature feature;
        File artFile = this.getOrResolveArtifact(id).getFile();
        FileReader reader = new FileReader(artFile);
        try {
            feature = FeatureJSONReader.read((Reader)reader, (String)artFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read feature file " + artFile + " for " + id.toMvnId(), ioe);
            }
        }
        ((Reader)reader).close();
        return feature;
    }
}

