/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.DependencyLifecycleParticipant;
import com.adobe.aem.analyser.result.AemAnalyserAnnotation;
import com.adobe.aem.analyser.result.AemAnalyserResult;
import com.adobe.aem.project.model.Application;
import com.adobe.aem.project.model.Project;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractAemMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession repoSession;
    private final Map<String, org.apache.maven.artifact.Artifact> artifactCache = new ConcurrentHashMap<String, org.apache.maven.artifact.Artifact>();
    @Parameter(defaultValue="false", property="aem.analyser.strict")
    protected boolean strictValidation;
    @Parameter(defaultValue="false", property="aem.analyser.sysout")
    protected boolean useSysout;

    private static org.apache.maven.artifact.Artifact findArtifact(ArtifactId id, Collection<org.apache.maven.artifact.Artifact> artifacts) {
        if (artifacts != null) {
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                if (!artifact.getGroupId().equals(id.getGroupId()) || !artifact.getArtifactId().equals(id.getArtifactId()) || !artifact.getVersion().equals(id.getVersion()) || !artifact.getType().equals(id.getType()) || (id.getClassifier() != null || artifact.getClassifier() != null) && (id.getClassifier() == null || !id.getClassifier().equals(artifact.getClassifier()))) continue;
                return artifact.getFile() == null ? null : artifact;
            }
        }
        return null;
    }

    org.apache.maven.artifact.Artifact getOrResolveArtifact(ArtifactId id) {
        org.apache.maven.artifact.Artifact result = this.artifactCache.get(id.toMvnId());
        if (result == null) {
            result = AbstractAemMojo.findArtifact(id, this.project.getAttachedArtifacts());
            if (result == null && (result = AbstractAemMojo.findArtifact(id, this.project.getArtifacts())) == null) {
                ArtifactRequest req = new ArtifactRequest((Artifact)new DefaultArtifact(id.toMvnId()), this.project.getRemoteProjectRepositories(), null);
                try {
                    ArtifactResult resolutionResult = this.repoSystem.resolveArtifact(this.repoSession, req);
                    result = RepositoryUtils.toArtifact((Artifact)resolutionResult.getArtifact());
                }
                catch (ArtifactResolutionException e) {
                    throw new RuntimeException("Unable to get artifact for " + id.toMvnId(), e);
                }
            }
            this.artifactCache.put(id.toMvnId(), result);
        }
        return result;
    }

    Feature getOrResolveFeature(ArtifactId id) {
        Feature feature;
        File artFile = this.getOrResolveArtifact(id).getFile();
        FileReader reader = new FileReader(artFile);
        try {
            feature = FeatureJSONReader.read((Reader)reader, (String)artFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read feature file " + artFile + " for " + id.toMvnId(), ioe);
            }
        }
        ((Reader)reader).close();
        return feature;
    }

    protected Project getProject() {
        Project pr = DependencyLifecycleParticipant.getProject(this.project);
        if (pr == null) {
            pr = new Project(this.project.getBasedir().getParentFile());
            pr.scan();
            DependencyLifecycleParticipant.setProject(this.project, pr);
        }
        if (pr.getApplication() == null || !pr.getApplication().getDirectory().getAbsolutePath().equals(this.project.getBasedir().getAbsolutePath())) {
            pr.setApplication(new Application(this.project.getBasedir()));
        }
        pr.getApplication().setId(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, null));
        return pr;
    }

    private File getBaseDirectory() {
        File baseDir = this.project.getBasedir();
        if (this.useSysout) {
            boolean done = false;
            do {
                File gitDir;
                if ((gitDir = new File(baseDir, ".git")).exists() && gitDir.isDirectory()) {
                    done = true;
                    continue;
                }
                if ((baseDir = baseDir.getParentFile()) != null) continue;
                baseDir = this.project.getBasedir();
                done = true;
            } while (!done);
        }
        return baseDir;
    }

    protected void printResult(AemAnalyserResult result) {
        File baseDir = this.getBaseDirectory();
        for (AemAnalyserAnnotation ann : result.getWarnings()) {
            if (this.strictValidation) {
                if (this.useSysout) {
                    System.out.println(ann.toMessage(AemAnalyserAnnotation.Level.error, baseDir));
                    continue;
                }
                this.getLog().error((CharSequence)ann.toString(baseDir));
                continue;
            }
            if (this.useSysout) {
                System.out.println(ann.toMessage(AemAnalyserAnnotation.Level.warning, baseDir));
                continue;
            }
            this.getLog().warn((CharSequence)ann.toString(baseDir));
        }
        for (AemAnalyserAnnotation ann : result.getErrors()) {
            if (this.useSysout) {
                System.out.println(ann.toMessage(AemAnalyserAnnotation.Level.error, baseDir));
                continue;
            }
            this.getLog().error((CharSequence)ann.toString(baseDir));
        }
    }
}

