/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.AemAnalyserResult;
import com.adobe.aem.analyser.mojos.AbstractAnalyseMojo;
import com.adobe.aem.analyser.tasks.ConfigurationsTask;
import com.adobe.aem.analyser.tasks.ConfigurationsTaskConfig;
import com.adobe.aem.analyser.tasks.TaskContext;
import com.adobe.aem.analyser.tasks.TaskResult;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.ArtifactId;

@Mojo(name="analyse-configs", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class AnalyseConfigsMojo
extends AbstractAnalyseMojo {
    @Parameter(defaultValue="src/main/content/jcr_root")
    private File repositoryRootDirectory;
    @Parameter(defaultValue="false")
    private boolean enforceConfigurationBelowConfigFolder;

    @Override
    protected AemAnalyserResult doExecute(ArtifactId sdkId, List<ArtifactId> addons) throws MojoExecutionException, MojoFailureException {
        try {
            TaskContext context = new TaskContext(this.project.getBasedir(), new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, this.project.getPackaging()), sdkId, addons, id -> this.getOrResolveFeature(id));
            ConfigurationsTaskConfig config = new ConfigurationsTaskConfig();
            config.setEnforceRepositoryConfigurationBelowConfigFolder(this.enforceConfigurationBelowConfigFolder);
            ConfigurationsTask task = new ConfigurationsTask(context, config);
            List files = task.scanRepositoryDirectory(this.repositoryRootDirectory);
            TaskResult result = task.analyseConfigurations(files);
            AemAnalyserResult mojoResult = new AemAnalyserResult();
            result.getErrors().stream().forEach(a -> mojoResult.getErrors().add(a.toString()));
            result.getWarnings().stream().forEach(a -> mojoResult.getWarnings().add(a.toString()));
            return mojoResult;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }
}

