/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.project.model.Application;
import com.adobe.aem.project.model.ArtifactsFile;
import com.adobe.aem.project.model.Module;
import com.adobe.aem.project.model.ModuleType;
import com.adobe.aem.project.model.Project;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="aemappparticipant")
public class DependencyLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_ID = "com.adobe.aem:aemanalyser-maven-plugin";
    @Requirement
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.logger.debug("Searching for project using plugin 'com.adobe.aem:aemanalyser-maven-plugin'...");
        ArrayList<MavenProject> apps = new ArrayList<MavenProject>();
        for (MavenProject project : session.getProjects()) {
            Plugin plugin = project.getPlugin(PLUGIN_ID);
            if (plugin == null || !"aemapp".equals(project.getPackaging())) continue;
            apps.add(project);
        }
        for (MavenProject project : apps) {
            this.processProject(project, session);
        }
    }

    private void processProject(MavenProject mavenProject, MavenSession session) {
        this.logger.debug("Found application project " + mavenProject.getId());
        Project project = new Project(mavenProject.getBasedir().getParentFile());
        project.scan();
        Application app = project.getApplication();
        if (app == null || !app.getDirectory().getAbsolutePath().equals(mavenProject.getBasedir().getAbsolutePath())) {
            this.logger.debug("Skipping project due to setup mismatch");
            return;
        }
        for (Module m : project.getModules()) {
            if (m.getType() != ModuleType.BUNDLE && m.getType() != ModuleType.CONTENT) continue;
            MavenProject found = null;
            for (MavenProject p : session.getProjects()) {
                if (!p.getBasedir().getAbsolutePath().equals(m.getDirectory().getAbsolutePath())) continue;
                found = p;
                break;
            }
            if (found == null) {
                File pomFile = new File(m.getDirectory(), "pom.xml");
                if (!pomFile.exists()) continue;
                MavenXpp3Reader reader = new MavenXpp3Reader();
                try (FileReader r = new FileReader(pomFile);){
                    String version;
                    Model model = reader.read((Reader)r);
                    String groupId = model.getGroupId();
                    if (groupId == null && model.getParent() != null) {
                        groupId = model.getParent().getGroupId();
                    }
                    if ((version = model.getVersion()) == null && model.getParent() != null) {
                        version = model.getParent().getVersion();
                    }
                    if (groupId == null || model.getArtifactId() == null || version == null) continue;
                    ArtifactId id = new ArtifactId(groupId, model.getArtifactId(), version, null, m.getType() == ModuleType.BUNDLE ? null : "zip");
                    m.setMvnId(id.toMvnId());
                    this.addDependency(mavenProject, id);
                }
                catch (IOException | XmlPullParserException throwable) {}
                continue;
            }
            ArtifactId id = new ArtifactId(found.getGroupId(), found.getArtifactId(), found.getVersion(), null, m.getType() == ModuleType.BUNDLE ? null : "zip");
            m.setMvnId(id.toMvnId());
            this.addDependency(mavenProject, id);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(project);
            oos.flush();
            mavenProject.setContextValue(PLUGIN_ID, (Object)baos.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.debug("Adding dependencies...");
        this.addArtifacts(mavenProject, app.getBundleFiles());
        this.addArtifacts(mavenProject, app.getContentPackageFiles());
        this.logger.debug("Done adding dependencies");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Project getProject(MavenProject mavenProject) {
        byte[] data = (byte[])mavenProject.getContextValue(PLUGIN_ID);
        if (data != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                Project project;
                try (ObjectInputStream ois = new ObjectInputStream(bais);){
                    project = (Project)ois.readObject();
                }
                return project;
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void addArtifacts(MavenProject project, List<ArtifactsFile> artifactsFiles) {
        for (ArtifactsFile file : artifactsFiles) {
            try {
                for (Artifact a : file.readArtifacts()) {
                    this.addDependency(project, a.getId());
                }
            }
            catch (IOException iOException) {
            }
        }
    }

    private Dependency toDependency(ArtifactId id, String scope) {
        Dependency dep = new Dependency();
        dep.setGroupId(id.getGroupId());
        dep.setArtifactId(id.getArtifactId());
        dep.setVersion(id.getVersion());
        dep.setType(id.getType());
        dep.setClassifier(id.getClassifier());
        dep.setScope(scope);
        return dep;
    }

    private void addDependency(MavenProject project, ArtifactId id) {
        if (id.getGroupId().equals(project.getGroupId()) && id.getArtifactId().equals(project.getArtifactId()) && id.getVersion().equals(project.getVersion())) {
            this.logger.debug("- skipping dependency " + id.toMvnId());
        } else {
            boolean found = false;
            for (Dependency d : project.getDependencies()) {
                if (!d.getGroupId().equals(id.getGroupId()) || !d.getArtifactId().equals(id.getArtifactId()) || !d.getVersion().equals(id.getVersion()) || !d.getType().equals(id.getType())) continue;
                if (d.getClassifier() == null && id.getClassifier() == null) {
                    found = true;
                    break;
                }
                if (d.getClassifier() == null || !d.getClassifier().equals(id.getClassifier())) continue;
                found = true;
                break;
            }
            if (!found) {
                this.logger.debug("- adding dependency " + id.toMvnId());
                Dependency dep = this.toDependency(id, "provided");
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId("*");
                exclusion.setArtifactId("*");
                dep.addExclusion(exclusion);
                project.getDependencies().add(dep);
            } else {
                this.logger.debug("- skipping duplicate dependency " + id.toMvnId());
            }
        }
    }
}

