/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.mojos.AbstractAemMojo;
import com.adobe.aem.analyser.mojos.DependencyLifecycleParticipant;
import com.adobe.aem.analyser.tasks.ConfigurationFile;
import com.adobe.aem.analyser.tasks.TaskResult;
import com.adobe.aem.project.EnvironmentType;
import com.adobe.aem.project.SDKType;
import com.adobe.aem.project.ServiceType;
import com.adobe.aem.project.model.Application;
import com.adobe.aem.project.model.ArtifactsFile;
import com.adobe.aem.project.model.Module;
import com.adobe.aem.project.model.Project;
import com.adobe.aem.project.model.RepoinitFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.cm.json.Configurations;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="package-app", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PackageAppMojo
extends AbstractAemMojo {
    @Parameter(defaultValue="false", property="aem.analyser.sysout")
    private boolean useSysout;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"*********************************************************************************************");
        this.getLog().warn((CharSequence)"THIS MOJO IS IN ALPHA STATE. USE WITH CAUTION AT YOUR OWN RISK");
        this.getLog().warn((CharSequence)"THE FUNCTIONALITY MIGHT CHANGE OR BREAK WITHOUT PRIOR NOTICE");
        this.getLog().warn((CharSequence)"*********************************************************************************************");
        new File(this.project.getBuild().getDirectory()).mkdirs();
        Project pr = DependencyLifecycleParticipant.getProject(this.project);
        if (pr == null) {
            pr = new Project(this.project.getBasedir().getParentFile());
            pr.scan();
        }
        Application app = pr.getApplication() == null || !pr.getApplication().getDirectory().getAbsolutePath().equals(this.project.getBasedir().getAbsolutePath()) ? new Application(this.project.getBasedir()) : pr.getApplication();
        File buildDirectory = new File(this.project.getBuild().getDirectory());
        File buildFile = new File(buildDirectory, this.project.getBuild().getFinalName().concat(".zip"));
        File filterFile = new File(buildDirectory, "filter.xml");
        File defFile = new File(buildDirectory, ".content.xml");
        File propsFile = new File(buildDirectory, "properties.xml");
        try {
            Files.writeString(filterFile.toPath(), (CharSequence)this.getFilterContents(), new OpenOption[0]);
            Files.writeString(defFile.toPath(), (CharSequence)this.getDefinitionContents(), new OpenOption[0]);
            try (FileOutputStream w = new FileOutputStream(propsFile);){
                this.getPackageProperties().storeToXML(w, null);
            }
            this.jarArchiver.setDestFile(buildFile);
            this.createManifest();
            this.addFile(filterFile, "META-INF/vault/" + filterFile.getName());
            this.addFile(defFile, "META-INF/vault/definition/" + defFile.getName());
            this.addFile(propsFile, "META-INF/vault/" + propsFile.getName());
            List configs = app.getConfigurationFiles();
            List repoinit = app.getRepoInitFiles();
            List bundles = app.getBundleFiles();
            List contentPackages = app.getContentPackageFiles();
            TaskResult result = app.verify(configs, repoinit, bundles, contentPackages);
            this.processResult(result);
            this.processConfigurations(configs);
            this.processRepoinit(repoinit);
            HashSet<ArtifactId> moduleIds = new HashSet<ArtifactId>();
            this.processArtifacts(moduleIds, bundles);
            this.processArtifacts(moduleIds, contentPackages);
            for (Module m : pr.getModules()) {
                ArtifactId id;
                if (m.getMvnId() == null || !moduleIds.add(id = ArtifactId.fromMvnId((String)m.getMvnId()))) continue;
                this.processArtifact(new Artifact(id), m.getServiceType());
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
        this.createArchive();
        this.project.getArtifact().setFile(buildFile);
    }

    private void processResult(TaskResult result) throws MojoExecutionException {
        for (TaskResult.Annotation ann : result.getWarnings()) {
            if (this.strictValidation) {
                if (this.useSysout) {
                    System.out.println(ann.toActionString("error"));
                    continue;
                }
                this.getLog().error((CharSequence)ann.toActionString("error"));
                continue;
            }
            if (this.useSysout) {
                System.out.println(ann.toActionString("warning"));
                continue;
            }
            this.getLog().warn((CharSequence)ann.toActionString("warning"));
        }
        for (TaskResult.Annotation ann : result.getErrors()) {
            if (this.useSysout) {
                System.out.println(ann.toActionString("error"));
                continue;
            }
            this.getLog().error((CharSequence)ann.toActionString("error"));
        }
        if (result.hasErrors() || this.strictValidation && result.hasWarnings()) {
            throw new MojoExecutionException("Configurations are not valid. Please check log");
        }
    }

    private void processRepoinit(List<RepoinitFile> repoinit) throws IOException, MojoExecutionException {
        for (RepoinitFile file : repoinit) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("scripts", file.getContents());
            File outFile = new File(this.project.getBuild().getDirectory(), file.getPid().concat(this.project.getArtifactId()).concat(".cfg.json"));
            try (FileWriter writer = new FileWriter(outFile);){
                Configurations.buildWriter().build((Writer)writer).writeConfiguration(props);
            }
            ConfigurationFile cfgFile = new ConfigurationFile(ConfigurationFile.Location.APPS, outFile);
            cfgFile.setServiceType(file.getServiceType());
            this.processConfiguration(cfgFile);
        }
    }

    private void processConfigurations(List<ConfigurationFile> configs) throws MojoExecutionException {
        for (ConfigurationFile file : configs) {
            this.processConfiguration(file);
        }
    }

    private void processConfiguration(ConfigurationFile file) throws MojoExecutionException {
        String runmode = this.getRunMode(file.getServiceType(), file.getEnvType(), file.getSdkType());
        String path = this.getConfigurationPath(runmode, file.getPid());
        this.addFile(file.getSource(), path);
    }

    private String getRunMode(ServiceType serviceType, EnvironmentType envType, SDKType sdkType) {
        if (serviceType != null) {
            if (envType != null) {
                return serviceType.asString().concat(".").concat(envType.asString());
            }
            if (sdkType != null) {
                return serviceType.asString().concat(".").concat(sdkType.asString());
            }
            return serviceType.asString();
        }
        if (envType != null) {
            return envType.asString();
        }
        if (sdkType != null) {
            return sdkType.asString();
        }
        return null;
    }

    private void processArtifacts(Set<ArtifactId> moduleIds, List<ArtifactsFile> files) throws MojoExecutionException {
        for (ArtifactsFile f : files) {
            for (Artifact a : f.getArtifacts()) {
                moduleIds.add(a.getId());
                this.processArtifact(a, f.getServiceType());
            }
        }
    }

    private void processArtifact(Artifact a, ServiceType serviceType) throws MojoExecutionException {
        String path = this.getArtifactPath(serviceType == null ? null : serviceType.asString(), a);
        File file = this.getOrResolveArtifact(a.getId()).getFile();
        this.addFile(file, path);
    }

    private String getPackageId() {
        return new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, null).toMvnId();
    }

    private String getRoot() {
        return "/jcr_root/apps/feature-".concat(this.project.getArtifactId()).concat("-").concat(this.project.getVersion()).concat("/application");
    }

    private String getArtifactPath(String runmode, Artifact a) {
        String base = this.getRoot().concat("/install");
        if (runmode != null) {
            base = base.concat(".").concat(runmode);
        }
        if (a.getStartOrder() > 0 && a.getStartOrder() != 20) {
            base = base.concat("/").concat(String.valueOf(a.getStartOrder()));
        }
        return base.concat("/").concat(a.getId().toMvnName());
    }

    private String getConfigurationPath(String runmode, String pid) {
        String base = this.getRoot().concat("/config");
        if (runmode != null) {
            base = base.concat(".").concat(runmode);
        }
        return base.concat("/").concat(pid).concat(".cfg.json");
    }

    private Properties getPackageProperties() {
        Properties p = new Properties();
        p.put("allowIndexDefinitions", "false");
        p.put("created", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(System.currentTimeMillis()));
        p.put("groupId", this.project.getGroupId());
        p.put("name", this.project.getArtifactId());
        if (this.project.getDescription() != null) {
            p.put("description", this.project.getDescription());
        }
        p.put("artifactId", this.project.getArtifactId());
        p.put("version", this.project.getVersion());
        p.put("packageType", "container");
        p.put("requiresRoot", "false");
        p.put("group", this.project.getGroupId());
        return p;
    }

    private String getFilterContents() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<workspaceFilter version=\"1.0\">\n  <filter root=\"" + this.getRoot() + "\"/>\n</workspaceFilter>\n";
    }

    private String getValue(String val) {
        if (val != null) {
            return val;
        }
        return "";
    }

    private String getDefinitionContents() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jcr:root xmlns:jcr=\"http://www.jcp.org/jcr/1.0\"\n  jcr:primaryType=\"vlt:PackageDefinition\"\n  providerLink=\"" + this.getValue(this.project.getOrganization() != null ? this.project.getOrganization().getUrl() : null) + "\"\n  providerName=\"" + this.getValue(this.project.getOrganization() != null ? this.project.getOrganization().getName() : null) + "\"\n  providerUrl=\"" + this.getValue(this.project.getOrganization() != null ? this.project.getOrganization().getUrl() : null) + "\"\n  testedWith=\"AEM Cloud Service\">\n</jcr:root>\n";
    }

    private void createManifest() throws MojoExecutionException {
        Manifest outManifest = new Manifest();
        try {
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Created-By", "AEM Project Plugin"));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Implementation-Title", this.project.getName()));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Implementation-Version", this.project.getVersion()));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Content-Package-Type", "container"));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Content-Package-Id", this.getPackageId()));
            outManifest.addConfiguredAttribute(new Manifest.Attribute("Content-Package-Roots", this.getRoot()));
            if (this.project.getDescription() != null) {
                outManifest.addConfiguredAttribute(new Manifest.Attribute("Content-Package-Description", this.project.getDescription()));
            }
            this.jarArchiver.addConfiguredManifest(outManifest);
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Unable to create manifest for " + this.jarArchiver.getDestFile(), (Exception)((Object)e));
        }
    }

    public void addFile(File inputFile, String destFileName) throws MojoExecutionException {
        try {
            this.jarArchiver.addFile(inputFile, destFileName);
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.jarArchiver.getDestFile(), (Exception)((Object)ae));
        }
    }

    public void createArchive() throws MojoExecutionException {
        try {
            this.jarArchiver.createArchive();
        }
        catch (IOException | ArchiverException ae) {
            throw new MojoExecutionException("Unable to create archive for " + this.jarArchiver.getDestFile(), (Exception)ae);
        }
    }
}

