/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.impl.ProviderTypeAnalyserTask;
import com.adobe.aem.analyser.mojos.AbstractAemMojo;
import com.adobe.aem.analyser.mojos.Addon;
import com.adobe.aem.analyser.mojos.VersionUtil;
import com.adobe.aem.analyser.result.AemAnalyserAnnotation;
import com.adobe.aem.analyser.result.AemAnalyserResult;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.ArtifactId;

public abstract class AbstractAnalyseMojo
extends AbstractAemMojo {
    @Parameter(property="sdkArtifactId")
    String sdkArtifactId;
    @Parameter(required=false, property="sdkVersion")
    String sdkVersion;
    @Parameter(required=false, defaultValue="false", property="sdkUseDependency")
    boolean useDependencyVersions;
    @Parameter
    List<Addon> addons;
    @Parameter(defaultValue="false", property="aem.analyser.skip")
    boolean skip;
    @Parameter(defaultValue="true", property="failon.analyser.errors")
    private boolean failOnAnalyserErrors;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor plugin;

    boolean skipRun() {
        boolean skipExecution;
        String skipVar = System.getenv("CM_PROGRAM_ID");
        boolean bl = skipExecution = skipVar != null && skipVar.length() > 0;
        if (skipExecution) {
            this.getLog().info((CharSequence)"Skipping AEM analyser plugin as variable CM_PROGRAM_ID is set.");
        } else if (this.skip) {
            skipExecution = true;
            this.getLog().info((CharSequence)"Skipping AEM analyser plugin as configured.");
        }
        return skipExecution;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean hasErrors;
        if (this.skipRun()) {
            return;
        }
        VersionUtil versionUtil = new VersionUtil(this.getLog(), this.project, this.artifactHandlerManager, this.repoSystem, this.repoSession, this.mavenSession.isOffline());
        versionUtil.checkPluginVersion(this.plugin.getGroupId(), this.plugin.getArtifactId(), this.plugin.getVersion());
        ArtifactId sdkId = versionUtil.getSDKArtifactId(this.sdkArtifactId, this.sdkVersion, this.useDependencyVersions);
        List<ArtifactId> addons = versionUtil.discoverAddons(this.addons, this.useDependencyVersions);
        if (!ProviderTypeAnalyserTask.initializeProviderTypeInfo((ArtifactId)sdkId, (File)this.getOrResolveArtifact(sdkId).getFile())) {
            throw new MojoFailureException("Provider types not found in " + sdkId.toMvnId() + ". Please update to a more recent version of the API.");
        }
        AemAnalyserResult result = this.doExecute(sdkId, addons);
        for (String warn : versionUtil.getVersionWarnings()) {
            result.getWarnings().add(new AemAnalyserAnnotation(warn));
        }
        this.printResult(result);
        boolean bl = hasErrors = result.hasErrors() || this.strictValidation && result.hasWarnings();
        if (hasErrors) {
            if (this.failOnAnalyserErrors) {
                throw new MojoFailureException("One or more feature analyser(s) detected feature error(s), please read the plugin log for more details");
            }
            this.getLog().warn((CharSequence)"Errors found during analyser run, but this plugin is configured to ignore errors and continue the build!");
        }
    }

    protected abstract AemAnalyserResult doExecute(ArtifactId var1, List<ArtifactId> var2) throws MojoExecutionException, MojoFailureException;
}

