/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos;

import com.adobe.aem.analyser.AemAggregator;
import com.adobe.aem.analyser.AemAnalyser;
import com.adobe.aem.analyser.AemPackageConverter;
import com.adobe.aem.analyser.mojos.AbstractAnalyseMojo;
import com.adobe.aem.analyser.result.AemAnalyserAnnotation;
import com.adobe.aem.analyser.result.AemAnalyserResult;
import com.adobe.aem.project.model.FeatureParticipantResolver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.io.artifacts.ArtifactManager;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;

public class AemAnalyseMojo
extends AbstractAnalyseMojo {
    @Parameter(defaultValue="requirements-capabilities,api-regions,api-regions-check-order,api-regions-crossfeature-dups,api-regions-exportsimports,configuration-api,region-deprecated-api", property="analyserTasks")
    List<String> analyserTasks;
    @Parameter(property="skipAnalyserTasks")
    List<String> skipAnalyserTasks;
    @Parameter(defaultValue="bundle-resources,bundle-nativecode,bundle-unversioned-packages,artifact-rules,aem-env-var,repoinit,content-packages-validation,aem-provider-type", property="analyserUserTasks")
    List<String> analyserUserTasks;
    @Parameter(property="skipAnalyserUserTasks")
    List<String> skipAnalyserUserTasks;
    @Parameter
    Map<String, Properties> analyserTaskConfigurations;
    @Parameter(property="aem.analyser.classifier")
    private String classifier;
    @Parameter
    private List<File> contentPackageFiles;

    private File getConversionOutputDir() {
        return new File(this.project.getBuild().getDirectory().concat(File.separator).concat("cp-conversion"));
    }

    private File getGeneratedFeaturesDir() {
        return new File(this.getConversionOutputDir(), "fm.out");
    }

    @Override
    public AemAnalyserResult doExecute(ArtifactId sdkId, List<ArtifactId> addons) throws MojoExecutionException, MojoFailureException {
        AemAnalyserResult aemAnalyserResult;
        block8: {
            ArrayList<String> additionalWarnings = new ArrayList<String>();
            ArrayList<String> additionalErrors = new ArrayList<String>();
            this.convertContentPackages(additionalWarnings, additionalErrors);
            ArtifactManager artifactManager = this.getArtifactManager();
            try {
                ArtifactProvider compositeArtifactProvider = this.getCompositeArtifactProvider(artifactManager);
                List<Feature> features = this.aggregateFeatureModels(sdkId, addons, compositeArtifactProvider);
                AemAnalyserResult result = this.analyseFeatures(features, compositeArtifactProvider);
                additionalWarnings.stream().forEach(msg -> result.getWarnings().add(new AemAnalyserAnnotation(msg)));
                additionalErrors.stream().forEach(msg -> result.getErrors().add(new AemAnalyserAnnotation(msg)));
                aemAnalyserResult = result;
                if (artifactManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (artifactManager != null) {
                        try {
                            artifactManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            artifactManager.close();
        }
        return aemAnalyserResult;
    }

    void convertContentPackages(List<String> additionalWarnings, List<String> additionalErrors) throws MojoExecutionException {
        AemPackageConverter converter = new AemPackageConverter();
        converter.setArtifactIdOverride(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, "slingosgifeature").toMvnId());
        converter.setConverterOutputDirectory(this.getConversionOutputDir());
        converter.setFeatureOutputDirectory(this.getGeneratedFeaturesDir());
        LinkedHashMap<String, File> packages = new LinkedHashMap<String, File>();
        for (Artifact contentPackage : this.getContentPackages()) {
            File source = contentPackage.getFile();
            packages.put(contentPackage.getId().toString(), source);
        }
        try {
            converter.convert(packages);
        }
        catch (ConverterException ce) {
            this.getLog().error((CharSequence)ce.getMessage());
            throw new MojoExecutionException(ce.getMessage());
        }
        catch (IOException t) {
            throw new MojoExecutionException("Content Package Converter Exception " + t.getMessage(), (Exception)t);
        }
    }

    private List<Artifact> getContentPackages() throws MojoExecutionException {
        if (!"aem-analyse".equals(this.project.getPackaging())) {
            if (this.contentPackageFiles != null && !this.contentPackageFiles.isEmpty()) {
                this.validateContentPackageFiles(this.contentPackageFiles);
                return this.contentPackageFiles.stream().map(this::contentPackageFileToArtifact).collect(Collectors.toList());
            }
            if (this.classifier != null) {
                for (Artifact artifact : this.project.getAttachedArtifacts()) {
                    if (!this.classifier.equals(artifact.getClassifier())) continue;
                    this.getLog().info((CharSequence)("Using attached artifact with classifier '" + this.classifier + "' as content package: " + this.project.getArtifact()));
                    return Collections.singletonList(artifact);
                }
                throw new MojoExecutionException("No attached artifact with classifier " + this.classifier + " found for project.");
            }
            this.getLog().info((CharSequence)("Using current project as content package: " + this.project.getArtifact()));
            return Collections.singletonList(this.project.getArtifact());
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Dependency d : this.project.getDependencies()) {
            if (!"zip".equals(d.getType()) && !"content-package".equals(d.getType())) continue;
            Artifact artifact = this.getOrResolveArtifact(new ArtifactId(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), d.getType()));
            result.add(artifact);
        }
        if (result.isEmpty()) {
            throw new MojoExecutionException("No content packages found for project.");
        }
        this.getLog().info((CharSequence)("Found content packages from dependencies: " + result));
        return result;
    }

    private void validateContentPackageFiles(List<File> files) throws MojoExecutionException {
        for (File file : files) {
            try {
                if (!file.exists()) {
                    throw new MojoExecutionException("File not found: " + file.getAbsolutePath());
                }
                if (FileUtils.directoryContains((File)this.project.getBasedir(), (File)file)) continue;
                throw new MojoExecutionException("File not inside project directory: " + file.getAbsolutePath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error validation file: " + file.getAbsolutePath(), (Exception)ex);
            }
        }
    }

    private Artifact contentPackageFileToArtifact(File file) {
        String fileClassifier = "hash-" + file.getPath().hashCode();
        String type = "zip";
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(type);
        DefaultArtifact fileArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, type, fileClassifier, artifactHandler);
        fileArtifact.setFile(file);
        return fileArtifact;
    }

    List<Feature> aggregateFeatureModels(ArtifactId sdkId, List<ArtifactId> addons, ArtifactProvider artifactProvider) throws MojoExecutionException {
        try {
            AemAggregator a = new AemAggregator();
            a.setFeatureOutputDirectory(this.getGeneratedFeaturesDir());
            a.setArtifactProvider(artifactProvider);
            a.setFeatureProvider(new FeatureProvider(){

                public Feature provide(ArtifactId id) {
                    return AemAnalyseMojo.this.getOrResolveFeature(id);
                }
            });
            a.setProjectId(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, null));
            a.setSdkId(sdkId);
            a.setAddOnIds(addons);
            a.setEnableDuplicateBundleHandling(true);
            return a.aggregate();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    AemAnalyserResult analyseFeatures(List<Feature> features, ArtifactProvider artifactProvider) throws MojoFailureException, MojoExecutionException {
        try {
            AemAnalyser analyser = new AemAnalyser();
            analyser.setArtifactProvider(artifactProvider);
            analyser.setIncludedTasks(this.getAnalyserTasks());
            analyser.setIncludedUserTasks(this.getAnalyserUserTasks());
            analyser.setTaskConfigurations(this.getAnalyserTaskConfigurations());
            analyser.setFeatureParticipantResolver((FeatureParticipantResolver)this.getProject());
            return analyser.analyse(features);
        }
        catch (Exception e) {
            throw new MojoExecutionException("A fatal error occurred while analysing the features, see error cause:", e);
        }
    }

    ArtifactProvider getCompositeArtifactProvider(final ArtifactManager artifactManager) throws IOException {
        return new ArtifactProvider(){

            public URL provide(ArtifactId id) {
                URL url = artifactManager.provide(id);
                if (url != null) {
                    return url;
                }
                try {
                    return AemAnalyseMojo.this.getOrResolveArtifact(id).getFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    AemAnalyseMojo.this.getLog().debug((CharSequence)("Malformed url " + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
        };
    }

    Map<String, Map<String, String>> getAnalyserTaskConfigurations() {
        HashMap<String, Map<String, String>> config = new HashMap<String, Map<String, String>>();
        if (this.analyserTaskConfigurations != null) {
            for (Map.Entry<String, Properties> entry : this.analyserTaskConfigurations.entrySet()) {
                HashMap m = new HashMap();
                entry.getValue().stringPropertyNames().forEach(n -> m.put(n, ((Properties)entry.getValue()).getProperty((String)n)));
                config.put(entry.getKey(), m);
            }
        }
        return config;
    }

    Set<String> getAnalyserTasks() {
        return AemAnalyseMojo.getFilteredSet(this.analyserTasks, this.skipAnalyserTasks);
    }

    Set<String> getAnalyserUserTasks() {
        return AemAnalyseMojo.getFilteredSet(this.analyserUserTasks, this.skipAnalyserUserTasks);
    }

    private static Set<String> getFilteredSet(List<String> values, List<String> skipValues) {
        HashSet<String> skipValuesSet = new HashSet<String>(skipValues != null ? skipValues : Collections.emptyList());
        return values.stream().filter(value -> !skipValuesSet.contains(value)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    ArtifactManager getArtifactManager() throws IOException {
        ArtifactManagerConfig amcfg = new ArtifactManagerConfig();
        amcfg.setRepositoryUrls(new String[]{this.getConversionOutputDir().toURI().toURL().toString()});
        return ArtifactManager.getArtifactManager((ArtifactManagerConfig)amcfg);
    }
}

