/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.download;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public interface Download {
    public Collection<AssetModel> getAssets();

    public String getZipFileName();

    public long getMaxContentSize();

    public long getDownloadContentSize();

    public String getMaxContentSizeLabel();

    public String getDownloadContentSizeLabel();

    public boolean isAsynchronous();

    @Deprecated
    default public boolean isLegacyMode() {
        return false;
    }

    default public List<AssetRenditionsGroup> getAssetRenditionsGroups() {
        return Collections.EMPTY_LIST;
    }

    public static class AssetRenditionsGroup {
        private final List<OptionItem> options;
        private final String title;

        public AssetRenditionsGroup(String title, Options options) {
            this.title = title;
            this.options = options.getItems();
        }

        public AssetRenditionsGroup(String title, List<OptionItem> options) {
            this.title = title;
            this.options = new ArrayList<OptionItem>(options);
        }

        public String getTitle() {
            return this.title;
        }

        public List<OptionItem> getItems() {
            return ImmutableList.copyOf(this.options);
        }
    }
}

