/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.DatePredicate;
import com.adobe.aem.commons.assetshare.components.predicates.impl.options.SelectedOptionItem;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.form.Field;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={DatePredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/date-range"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class DatePredicateImpl
extends AbstractPredicate
implements DatePredicate {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/date-range";
    private static final String RELATIVE_DATE_RANGE = "relativedaterange";
    private static final String DATE_RANGE = "daterange";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private Options coreOptions;
    @ValueMapValue
    private String property;
    @ValueMapValue
    private String dateType;
    @ValueMapValue(name="type")
    private String typeString;
    private ValueMap valuesFromRequest = null;

    @PostConstruct
    protected void init() {
        this.coreOptions = (Options)this.request.adaptTo(Options.class);
        this.initPredicate(this.request, (Field)this.coreOptions);
    }

    public String getProperty() {
        return this.property;
    }

    public String getDateType() {
        return this.dateType;
    }

    public String getSubType() {
        return this.typeString;
    }

    @Override
    public List<OptionItem> getItems() {
        ValueMap initialValues = this.getInitialValues();
        ArrayList<OptionItem> processedOptionItems = new ArrayList<OptionItem>();
        for (OptionItem optionItem : this.coreOptions.getItems()) {
            if (PredicateUtil.isOptionInInitialValues(optionItem, initialValues)) {
                processedOptionItems.add(new SelectedOptionItem(optionItem));
                continue;
            }
            processedOptionItems.add(optionItem);
        }
        return processedOptionItems;
    }

    public String getName() {
        return this.getDateType();
    }

    @Override
    public String getLowerBoundName() {
        return this.getName() + "." + "lowerBound";
    }

    @Override
    public String getUpperBoundName() {
        return this.getName() + "." + "upperBound";
    }

    @Override
    public String getInitialLowerBound() {
        return PredicateUtil.getParamFromQueryParams(this.request, this.getGroup() + "." + this.getLowerBoundName());
    }

    @Override
    public String getInitialUpperBound() {
        return PredicateUtil.getParamFromQueryParams(this.request, this.getGroup() + "." + this.getUpperBoundName());
    }

    @Override
    public boolean isReady() {
        return RELATIVE_DATE_RANGE.equals(this.dateType) && this.coreOptions.getItems().size() > 0 || DATE_RANGE.equals(this.dateType);
    }

    @Override
    public String getInitialValue() {
        return null;
    }

    @Override
    public ValueMap getInitialValues() {
        if (this.valuesFromRequest == null) {
            this.valuesFromRequest = new ValueMapDecorator(new HashMap());
            if (StringUtils.isNotBlank((CharSequence)this.getInitialLowerBound())) {
                this.valuesFromRequest.put((Object)this.getLowerBoundName(), (Object)this.getInitialLowerBound());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getInitialLowerBound())) {
                this.valuesFromRequest.put((Object)this.getUpperBoundName(), (Object)this.getInitialLowerBound());
            }
        }
        return this.valuesFromRequest;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

