/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.HiddenPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.PagePredicate;
import com.adobe.aem.commons.assetshare.components.search.SearchConfig;
import com.adobe.aem.commons.assetshare.search.searchpredicates.SearchPredicate;
import com.adobe.aem.commons.assetshare.util.ComponentModelVisitor;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={PagePredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/results"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class PagePredicateImpl
extends AbstractPredicate
implements PagePredicate {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/results";
    private static final int MAX_LIMIT = 1000;
    private static final int DEFAULT_LIMIT = 50;
    @Self
    @Required
    SlingHttpServletRequest request;
    @Inject
    @Required
    private Page currentPage;
    @Self
    @Required
    private SearchConfig searchConfig;
    @OSGiService
    private ModelFactory modelFactory;
    @OSGiService
    private List<SearchPredicate> searchPredicates;

    @PostConstruct
    protected void init() {
        this.initPredicate(this.request, null);
    }

    public String getName() {
        return "p";
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public String getOrderBy() {
        String value = PredicateUtil.getParamFromQueryParams(this.request, "orderby");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)this.searchConfig.getOrderBy());
    }

    @Override
    public String getOrderBySort() {
        String value = PredicateUtil.getParamFromQueryParams(this.request, "orderby.sort");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)this.searchConfig.getOrderBySort());
    }

    private boolean isOrderByCase() {
        if (StringUtils.isBlank((CharSequence)PredicateUtil.getParamFromQueryParams(this.request, "orderby"))) {
            return this.searchConfig.isOrderByCase();
        }
        String value = PredicateUtil.getParamFromQueryParams(this.request, "orderby.case");
        return !"ignore".equals(value);
    }

    @Override
    public int getLimit() {
        RequestParameter requestParameter = this.request.getRequestParameter("p.limit");
        int limit = this.searchConfig.getLimit();
        if (requestParameter != null) {
            try {
                limit = Integer.parseInt(requestParameter.getString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (limit > 1000) {
            return 1000;
        }
        if (limit < 1) {
            return 50;
        }
        return limit;
    }

    public int getOffset() {
        RequestParameter requestParameter = this.request.getRequestParameter("p.offset");
        int offset = 0;
        if (requestParameter != null) {
            try {
                offset = Integer.parseInt(requestParameter.getString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return offset;
    }

    @Override
    public String getGuessTotal() {
        return this.searchConfig.getGuessTotal();
    }

    @Override
    public List<String> getPaths() {
        return this.searchConfig.getPaths();
    }

    @Override
    public PredicateGroup getPredicateGroup() {
        return this.getPredicateGroup(new PagePredicate.ParamTypes[0]);
    }

    @Override
    public PredicateGroup getPredicateGroup(PagePredicate.ParamTypes ... excludeParamTypes) {
        PredicateGroup root = new PredicateGroup();
        PredicateGroup parameterGroup = new PredicateGroup("p");
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.NODE_TYPE))) {
            this.addTypeAsPredicate(root);
        }
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.PATH))) {
            this.addPathAsPredicateGroup(root);
        }
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.ORDERBY))) {
            this.addOrderByAsPredicate(root);
        }
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.HIDDEN_PREDICATES))) {
            this.addHiddenPredicatesAsPredicateGroups(root);
        }
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.SEARCH_PREDICATES))) {
            this.addSearchPredicateAsPredicateGroups(root);
        }
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.OFFSET))) {
            this.addOffsetAsParameterPredicate(parameterGroup);
        }
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.LIMIT))) {
            this.addLimitAsParameterPredicate(parameterGroup);
        }
        if (!ArrayUtils.contains((Object[])excludeParamTypes, (Object)((Object)PagePredicate.ParamTypes.GUESS_TOTAL))) {
            this.addGuessTotalAsParameterPredicate(parameterGroup);
        }
        root.add((Predicate)parameterGroup);
        return root;
    }

    private void addGuessTotalAsParameterPredicate(PredicateGroup parameterGroup) {
        parameterGroup.addAll((Collection)PredicateConverter.createPredicates((Map)ImmutableMap.builder().put((Object)"guessTotal", (Object)this.getGuessTotal()).build()));
    }

    private void addOffsetAsParameterPredicate(PredicateGroup parameterGroup) {
        parameterGroup.addAll((Collection)PredicateConverter.createPredicates((Map)ImmutableMap.builder().put((Object)"offset", (Object)String.valueOf(this.getOffset())).build()));
    }

    private void addLimitAsParameterPredicate(PredicateGroup parameterGroup) {
        parameterGroup.addAll((Collection)PredicateConverter.createPredicates((Map)ImmutableMap.builder().put((Object)"limit", (Object)String.valueOf(this.getLimit())).build()));
    }

    private void addSearchPredicateAsPredicateGroups(PredicateGroup root) {
        for (SearchPredicate searchPredicate : this.getSearchPredicates()) {
            PredicateGroup global = new PredicateGroup();
            global.addAll((Collection)searchPredicate.getPredicateGroup(this.request));
            root.add((Predicate)global);
        }
    }

    private void addHiddenPredicatesAsPredicateGroups(PredicateGroup root) {
        for (HiddenPredicate hiddenPredicate : this.getHiddenPredicates(this.currentPage)) {
            PredicateGroup hidden = new PredicateGroup();
            hidden.addAll((Collection)hiddenPredicate.getPredicateGroup());
            root.add((Predicate)hidden);
        }
    }

    private void addPathAsPredicateGroup(PredicateGroup root) {
        PredicateGroup paths = new PredicateGroup();
        paths.setAllRequired(false);
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        for (String path : this.getPaths()) {
            params.put(i++ + "_" + "path", path);
        }
        paths.addAll((Collection)PredicateConverter.createPredicates(params));
        root.add((Predicate)paths);
    }

    private void addTypeAsPredicate(PredicateGroup root) {
        root.addAll((Collection)PredicateConverter.createPredicates((Map)ImmutableMap.builder().put((Object)"type", (Object)"dam:Asset").build()));
    }

    private void addOrderByAsPredicate(PredicateGroup root) {
        ImmutableMap.Builder orderPredicateBuilder = ImmutableMap.builder().put((Object)"orderby", (Object)this.searchConfig.getOrderBy()).put((Object)"orderby.sort", (Object)this.searchConfig.getOrderBySort());
        if (!this.isOrderByCase()) {
            orderPredicateBuilder.put((Object)"orderby.case", (Object)"ignore");
        }
        root.addAll((Collection)PredicateConverter.createPredicates((Map)orderPredicateBuilder.build()));
    }

    private List<SearchPredicate> getSearchPredicates() {
        List<String> searchPredicateNames = this.searchConfig.getSearchPredicatesNames();
        ArrayList<SearchPredicate> matchingSearchPredicates = new ArrayList<SearchPredicate>();
        for (String searchPredicateName : searchPredicateNames) {
            this.searchPredicates.stream().filter(gp -> StringUtils.equals((CharSequence)searchPredicateName, (CharSequence)gp.getName())).findFirst().ifPresent(matchingSearchPredicates::add);
        }
        return matchingSearchPredicates;
    }

    private Collection<HiddenPredicate> getHiddenPredicates(Page page) {
        ComponentModelVisitor<HiddenPredicate> visitor = new ComponentModelVisitor<HiddenPredicate>(this.request, this.modelFactory, new String[]{"asset-share-commons/components/search/hidden"}, HiddenPredicate.class);
        visitor.accept(page.getContentResource());
        return visitor.getModels();
    }

    @Override
    @Deprecated
    public Map<String, String> getParams() {
        return this.getParams(new PagePredicate.ParamTypes[0]);
    }

    @Override
    @Deprecated
    public Map<String, String> getParams(PagePredicate.ParamTypes ... excludeParamTypes) {
        return PredicateConverter.createMap((PredicateGroup)this.getPredicateGroup(excludeParamTypes));
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

