/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.search.impl;

import com.adobe.aem.commons.assetshare.components.search.SearchConfig;
import com.adobe.aem.commons.assetshare.util.ResourceTypeVisitor;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={SearchConfig.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/results"})
@Exporter(name="jackson", extensions={"json"})
public class SearchConfigImpl
implements SearchConfig,
ComponentExporter {
    private static final Logger log = LoggerFactory.getLogger(SearchConfigImpl.class);
    public static final String RESOURCE_TYPE = "asset-share-commons/components/search/results";
    private static final int MAX_GUESS_TOTAL = 2000;
    private static final int DEFAULT_LIMIT = 50;
    private static final String DEFAULT_GUESS_TOTAL = "250";
    private static final String DEFAULT_ORDER_BY = "@jcr:score";
    private static final String DEFAULT_ORDER_BY_SORT = "desc";
    private static final boolean DEFAULT_ORDER_BY_CASE = true;
    private static final String DEFAULT_LAYOUT = "card";
    private static final String DEFAULT_SPID = "search";
    private final String[] DEFAULT_PATHS = new String[]{"/content/dam"};
    private String PN_ORDER_BY = "orderBy";
    private String PN_ORDER_BY_SORT = "orderBySort";
    private String PN_ORDER_BY_CASE = "orderByCase";
    private String PN_LIMIT = "limit";
    private String PN_PATHS = "paths";
    private String PN_LAYOUT = "layout";
    private String PN_GUESS_TOTAL = "guessTotal";
    private String PN_SPID = "searchProviderId";
    private String PN_SEARCH_PREDICATES = "searchPredicates";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Page currentPage;
    @OSGiService
    private ModelFactory modelFactory;
    @SlingObject
    @Optional
    private Resource resource;
    private ValueMap properties;
    List<String> paths;

    @PostConstruct
    protected void init() {
        this.resource = this.resolveSearchConfigResource((PageManager)this.request.getResourceResolver().adaptTo(PageManager.class), this.request.getResource());
        if (this.resource == null) {
            throw new IllegalArgumentException("Adaptable must resolve a search results component.");
        }
        this.properties = this.resource.getValueMap();
    }

    @Override
    public ValueMap getProperties() {
        return this.properties;
    }

    @Override
    public String getMode() {
        return (String)this.properties.get(this.PN_SPID, (Object)DEFAULT_SPID);
    }

    @Override
    public String getLayout() {
        return (String)this.properties.get(this.PN_LAYOUT, (Object)DEFAULT_LAYOUT);
    }

    @Override
    public String getGuessTotal() {
        String guessTotal = (String)this.properties.get(this.PN_GUESS_TOTAL, (Object)DEFAULT_GUESS_TOTAL);
        if (Boolean.TRUE.toString().equalsIgnoreCase(guessTotal)) {
            return Boolean.TRUE.toString();
        }
        try {
            int guessTotalAsNumber = Integer.parseInt(guessTotal);
            return guessTotalAsNumber < 1 || guessTotalAsNumber > 2000 ? DEFAULT_GUESS_TOTAL : String.valueOf(guessTotalAsNumber);
        }
        catch (NumberFormatException e) {
            return DEFAULT_GUESS_TOTAL;
        }
    }

    @Override
    public String getSearchProviderId() {
        return (String)this.properties.get(this.PN_SPID, (Object)DEFAULT_SPID);
    }

    @Override
    public int getLimit() {
        return (Integer)this.properties.get(this.PN_LIMIT, (Object)50);
    }

    @Override
    public String getOrderBy() {
        return (String)this.properties.get(this.PN_ORDER_BY, (Object)DEFAULT_ORDER_BY);
    }

    @Override
    public String getOrderBySort() {
        return (String)this.properties.get(this.PN_ORDER_BY_SORT, (Object)DEFAULT_ORDER_BY_SORT);
    }

    @Override
    public boolean isOrderByCase() {
        return (Boolean)this.properties.get(this.PN_ORDER_BY_CASE, (Object)true);
    }

    @Override
    public List<String> getPaths() {
        List<String> paths = Arrays.stream((Object[])this.properties.get(this.PN_PATHS, (Object)this.DEFAULT_PATHS)).filter(path -> StringUtils.equals((CharSequence)path, (CharSequence)"/content/dam") || StringUtils.startsWith((CharSequence)path, (CharSequence)"/content/dam")).collect(Collectors.toList());
        return paths.size() < 1 ? Arrays.asList(this.DEFAULT_PATHS) : paths;
    }

    @Override
    public List<String> getSearchPredicatesNames() {
        return Arrays.asList((Object[])this.properties.get(this.PN_SEARCH_PREDICATES, (Object)new String[0]));
    }

    private Resource resolveSearchConfigResource(PageManager pageManager, Resource currentResource) {
        if (!this.isValidResource(currentResource)) {
            return null;
        }
        if (currentResource.isResourceType(RESOURCE_TYPE)) {
            return currentResource;
        }
        ResourceTypeVisitor visitor = new ResourceTypeVisitor(new String[]{RESOURCE_TYPE});
        Page page = pageManager.getContainingPage(currentResource);
        visitor.accept(page.getContentResource());
        if (visitor.getResources().size() > 0) {
            return visitor.getResources().iterator().next();
        }
        if (page.getParent() != null) {
            return this.resolveSearchConfigResource(pageManager, page.getParent().getContentResource());
        }
        log.warn("Unable to locate a Search Results component resource that can represent the Search Config. It is likely the Search Results component has not been added to the Search page yet!");
        return null;
    }

    private boolean isValidResource(Resource resource) {
        return resource != null && StringUtils.startsWith((CharSequence)resource.getPath(), (CharSequence)"/content/");
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

