/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl;

import com.adobe.aem.commons.assetshare.configuration.AssetDetails;
import com.adobe.aem.commons.assetshare.configuration.AssetDetailsResolver;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={AssetDetails.class})
public class AssetDetailsImpl
implements AssetDetails {
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Inject
    @Required
    private AssetModel asset;
    @Self
    @Required
    private Config config;
    @OSGiService
    @Required
    private AssetDetailsResolver assetDetailsResolver;
    private String url = null;

    @Override
    public String getUrl() {
        if (this.url == null) {
            this.url = this.assetDetailsResolver.getUrl(this.config, this.asset);
        }
        return this.url;
    }

    @Override
    public String getFullUrl() {
        String fullUrl = this.getUrl();
        fullUrl = this.config.getAssetDetailReferenceById() ? fullUrl + "/" + this.asset.getAssetId() + ".html" : fullUrl + (String)this.asset.getProperties().get("url", (Object)this.asset.getPath());
        return UrlUtil.escape(fullUrl);
    }
}

