/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl.selectors;

import com.adobe.aem.commons.assetshare.configuration.AssetDetailsSelector;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(property={"label:String=Asset Type", "id:String=asset-type"}, service={AssetDetailsSelector.class})
@Designate(ocd=Cfg.class)
public class AssetTypeSelectorImpl
implements AssetDetailsSelector {
    public static final String LABEL = "Asset Type";
    public static final String ID = "asset-type";
    private Cfg cfg;

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String getId() {
        return this.cfg.id();
    }

    @Override
    public boolean accepts(Config config, AssetModel asset) {
        return StringUtils.equalsIgnoreCase((CharSequence)config.getAssetDetailsSelector(), (CharSequence)ID);
    }

    @Override
    public String getUrl(Config config, AssetModel asset) {
        return this.buildUrl(config, (String)asset.getProperties().get("type", String.class));
    }

    private String buildUrl(Config config, String assetType) {
        if (assetType == null) {
            return null;
        }
        assetType = StringUtils.lowerCase((String)assetType);
        assetType = StringUtils.replace((String)assetType, (String)" ", (String)"-");
        if (StringUtils.isBlank((CharSequence)config.getAssetDetailsPath())) {
            return null;
        }
        return config.getAssetDetailsPath() + "/" + assetType + ".html";
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Asset Details Selector - Asset Type")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Asset Type";

        @AttributeDefinition(name="ID", description="Defines the id of data this exposes. Should be unique across selectors.")
        public String id() default "asset-type";
    }
}

