/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.day.cq.dam.api.Asset;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class LicenseImpl
extends AbstractComputedProperty<String> {
    public static final String LABEL = "License";
    public static final String NAME = "license";
    private Cfg cfg;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public String get(Asset asset) {
        String licensePath = StringUtils.trimToNull((String)((String)this.getMetadataProperties(asset).get("xmpRights:WebStatement", String.class)));
        if (licensePath != null) {
            if (StringUtils.startsWith((CharSequence)licensePath, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)licensePath, (CharSequence)"//")) {
                Resource licenseResource = ((Resource)asset.adaptTo(Resource.class)).getResourceResolver().resolve(licensePath);
                if (licenseResource != null) {
                    return licensePath;
                }
            } else {
                return licensePath;
            }
        }
        return null;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - License")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "License";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"metadata"};
    }
}

