/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions;

import com.adobe.acs.commons.util.PathInfoUtil;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssetRenditionParameters {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionParameters.class);
    public static final String DOWNLOAD = "download";
    public static final String CACHE_FILENAME = "asset.rendition";
    private final Asset asset;
    private final String renditionName;
    private final String fileName;
    private final List<String> otherParameters;

    public AssetRenditionParameters(SlingHttpServletRequest request) throws IllegalArgumentException {
        String[] segments = PathInfoUtil.getSuffixSegments(request);
        this.asset = DamUtil.resolveToAsset((Resource)request.getResource());
        this.renditionName = PathInfoUtil.getFirstSuffixSegment(request);
        if (this.asset == null) {
            throw new IllegalArgumentException(String.format("Request resource [ %s ] cannot be resolved to an Asset", request.getResource().getPath()));
        }
        if (segments.length < 2) {
            throw new IllegalArgumentException(String.format("Request must at least 2 suffix segments, found [ %d ]", segments.length));
        }
        if (StringUtils.isBlank((CharSequence)this.renditionName)) {
            throw new IllegalArgumentException(String.format("Request does not have a rendition name in the first suffix segment", new Object[0]));
        }
        if (!CACHE_FILENAME.equals(PathInfoUtil.getLastSuffixSegment(request))) {
            throw new IllegalArgumentException(String.format("Request's last suffix segment must be [ %s ]", CACHE_FILENAME));
        }
        this.fileName = this.buildFileName(this.asset, this.renditionName);
        this.otherParameters = new ArrayList<String>();
        for (int i = 1; i < segments.length - 1; ++i) {
            this.otherParameters.add(segments[i]);
        }
    }

    public AssetRenditionParameters(@Nonnull AssetModel assetModel, @Nonnull String renditionName) throws IllegalArgumentException {
        this(assetModel, renditionName, false);
    }

    public AssetRenditionParameters(@Nonnull AssetModel assetModel, @Nonnull String renditionName, boolean download) throws IllegalArgumentException {
        this(assetModel, renditionName, download, Collections.EMPTY_LIST);
    }

    public AssetRenditionParameters(@Nonnull AssetModel assetModel, @Nonnull String renditionName, boolean download, String ... otherParameters) throws IllegalArgumentException {
        this(assetModel, renditionName, download, Arrays.asList(otherParameters));
    }

    public AssetRenditionParameters(@Nonnull AssetModel assetModel, @Nonnull String renditionName, boolean download, List<String> otherParameters) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)renditionName)) {
            throw new IllegalArgumentException("Am asset is required");
        }
        if (StringUtils.isBlank((CharSequence)renditionName)) {
            throw new IllegalArgumentException("A renditionName is required");
        }
        this.asset = DamUtil.resolveToAsset((Resource)assetModel.getResource());
        this.renditionName = renditionName;
        this.fileName = this.buildFileName(this.asset, renditionName);
        this.otherParameters = new ArrayList<String>(otherParameters);
        if (download) {
            this.otherParameters.add(DOWNLOAD);
        }
    }

    public String getRenditionName() {
        return this.renditionName;
    }

    public boolean isDownload() {
        return this.otherParameters.contains(DOWNLOAD);
    }

    public String getFileName() {
        if (this.fileName == null) {
            log.debug("The fileName can only be derived from parameters sourced from a SlingHttpServletRequest");
        }
        return this.fileName;
    }

    public List<String> getParameters() {
        return new ArrayList<String>(this.otherParameters);
    }

    protected String buildFileName(Asset asset, String renditionName) {
        String assetName = StringUtils.substringBeforeLast((String)asset.getName(), (String)".");
        String fileName = StringUtils.lastIndexOf((CharSequence)asset.getName(), (CharSequence)".") < 0 ? assetName + "." + renditionName : assetName + "." + renditionName + "." + StringUtils.substringAfterLast((String)asset.getName(), (String)".");
        return fileName;
    }
}

