/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.util.ExpressionEvaluator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AssetRenditionsImpl
implements AssetRenditions {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionsImpl.class);
    @Reference
    private ModelFactory modelFactory;
    @Reference
    private ExpressionEvaluator expressionEvaluator;

    @Override
    public String getUrl(SlingHttpServletRequest request, AssetModel asset, AssetRenditionParameters parameters) {
        String url = request.getResourceResolver().map(asset.getPath()) + "." + "renditions" + "/" + parameters.getRenditionName() + "/";
        if (parameters.isDownload()) {
            url = url + "download/";
        }
        url = url + "asset.rendition";
        return url;
    }

    @Override
    public Map<String, String> getOptions(Map<String, ? extends Object> mappings) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        mappings.keySet().stream().sorted().forEach(key -> {
            if (!options.containsValue(key)) {
                options.put(StringUtils.capitalize((String)StringUtils.replace((String)key, (String)"_", (String)" ")), (String)key);
            }
        });
        return options;
    }

    @Override
    public String evaluateExpression(SlingHttpServletRequest request, String expression) {
        AssetModel assetModel = (AssetModel)this.modelFactory.createModel((Object)request.getResource(), AssetModel.class);
        return this.evaluateExpression(assetModel, new AssetRenditionParameters(request).getRenditionName(), expression);
    }

    @Override
    public String evaluateExpression(AssetModel assetModel, String renditionName, String expression) {
        expression = this.expressionEvaluator.evaluateAssetExpression(expression, assetModel);
        expression = this.expressionEvaluator.evaluateRenditionExpression(expression, renditionName);
        expression = this.expressionEvaluator.evaluateDynamicMediaExpression(expression, assetModel);
        expression = this.expressionEvaluator.evaluateProperties(expression, assetModel);
        return expression;
    }
}

