/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRendition;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers.AbstractRenditionDispatcherImpl;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=-10000", "webconsole.configurationFactory.nameHint={name} [ {label} ] @ {service.ranking}"})
@Designate(ocd=Cfg.class, factory=true)
public class ExternalRedirectRenditionDispatcherImpl
extends AbstractRenditionDispatcherImpl
implements AssetRenditionDispatcher {
    private static final Logger log = LoggerFactory.getLogger(ExternalRedirectRenditionDispatcherImpl.class);
    private static Long PLACEHOLDER_SIZE_IN_BYTES = 0x6400000L;
    private Cfg cfg;
    private ConcurrentHashMap<String, String> mappings;
    @Reference
    private AssetRenditions assetRenditions;
    @Reference
    private MimeTypeService mimeTypeService;

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String getName() {
        return this.cfg.name();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.assetRenditions.getOptions(this.mappings);
    }

    @Override
    public boolean isHidden() {
        return this.cfg.hidden();
    }

    @Override
    public Set<String> getRenditionNames() {
        if (this.mappings == null) {
            return Collections.EMPTY_SET;
        }
        return this.mappings.keySet();
    }

    @Override
    public List<String> getTypes() {
        if (this.cfg.types() != null) {
            return Arrays.asList(this.cfg.types());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void dispatch(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        AssetRenditionParameters parameters = new AssetRenditionParameters(request);
        String expression = this.mappings.get(parameters.getRenditionName());
        String renditionRedirect = this.assetRenditions.evaluateExpression(request, expression);
        if (StringUtils.isNotBlank((CharSequence)renditionRedirect)) {
            if (log.isDebugEnabled()) {
                log.debug("Serving External redirect rendition [ {} ] for resolved rendition name [ {} ]", (Object)renditionRedirect, (Object)parameters.getRenditionName());
            }
            if (this.cfg.redirect() == 302) {
                response.setStatus(302);
            } else {
                response.setStatus(301);
            }
            response.setHeader("Location", UrlUtil.escape(renditionRedirect));
        } else {
            log.error("Could not convert [ {} ] into a valid URI", (Object)renditionRedirect);
            response.sendError(404, "Could not serve asset rendition.");
        }
    }

    @Override
    public AssetRendition getRendition(AssetModel assetModel, AssetRenditionParameters parameters) {
        String expression = this.mappings.get(parameters.getRenditionName());
        String renditionRedirect = this.assetRenditions.evaluateExpression(assetModel, parameters.getRenditionName(), expression);
        if (StringUtils.isNotBlank((CharSequence)renditionRedirect)) {
            try {
                renditionRedirect = UrlUtil.escape(renditionRedirect, true);
                String extension = this.getExtensionFromAscExtQueryParameter(renditionRedirect);
                renditionRedirect = this.cleanURI(renditionRedirect);
                if (log.isDebugEnabled()) {
                    log.debug("Downloading External redirect rendition [ {} ] for resolved rendition name [ {} ]", (Object)renditionRedirect, (Object)parameters.getRenditionName());
                }
                return new AssetRendition(renditionRedirect, PLACEHOLDER_SIZE_IN_BYTES, this.mimeTypeService.getMimeType(extension));
            }
            catch (URISyntaxException e) {
                log.warn("Unable to create a valid URI for rendition redirect [ {} ]", (Object)renditionRedirect, (Object)e);
                return new AssetRendition("failed://to.create.valid.uri.from.rendition.redirect", (Long)0L, "invalid/uri");
            }
        }
        return null;
    }

    @Override
    public boolean accepts(AssetModel assetModel, String renditionName) {
        return this.getRenditionNames().contains(renditionName);
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
        this.mappings = super.parseMappingsAsStrings(cfg.rendition_mappings());
    }

    @ObjectClassDefinition(name="Asset Share Commons - Rendition Dispatcher - External Redirect Renditions")
    public static @interface Cfg {
        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{name} [ {label} ] @ {service.ranking}";

        @AttributeDefinition(name="Name", description="The system name of this Rendition Dispatcher. This should be unique across all AssetRenditionDispatcher instances.")
        public String name() default "external-redirect";

        @AttributeDefinition(name="Label", description="The human-friendly name of this AssetRenditionDispatcher and may be displayed to authors.")
        public String label() default "External Redirect Renditions";

        @AttributeDefinition(name="Rendition types", description="The types of renditions this configuration will return. Ideally all renditions in this configuration apply types specified here. This is used to drive and scope the Asset Renditions displays in Authoring datasources. OOTB types are: `image` and `video`")
        public String[] types() default {};

        @AttributeDefinition(name="Hide renditions", description="Hide if this AssetRenditionDispatcher configuration is not intended to be exposed to AEM authors for selection in dialogs.", type=AttributeType.BOOLEAN)
        public boolean hidden() default false;

        @AttributeDefinition(name="Redirect", description="Select the type of redirect that should be made: Moved Permanently (301) or Moved Temporarily (302). Defaults to 301.", options={@Option(label="Moved Permanently (301)", value="301"), @Option(label="Moved Temporarily (302)", value="302")})
        public int redirect() default 301;

        @AttributeDefinition(name="Rendition mappings", description="In the form: <rendition name>=<redirect location>")
        public String[] rendition_mappings() default {};

        @AttributeDefinition(name="Service ranking", description="The larger the number, the higher the precedence.", type=AttributeType.INTEGER)
        public int service_ranking() default 0;
    }
}

