/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.search.impl.datasources;

import com.adobe.aem.commons.assetshare.content.MetadataProperties;
import com.adobe.aem.commons.assetshare.search.FastProperties;
import com.adobe.aem.commons.assetshare.util.DataSourceBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=asset-share-commons/data-sources/filterable-properties", "sling.servlet.methods=GET"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class FilterablePropertiesDataSource
extends SlingSafeMethodsServlet {
    private static final String PN_METADATA_FIELD_TYPES = "metadataFieldTypes";
    private static final String PN_PROPERTY_INDEX = "propertyIndex";
    private static final String PN_FILTER_PROPERTIES = "indexRuleCapabilities";
    @Reference
    private transient DataSourceBuilder dataSourceBuilder;
    @Reference
    private transient FastProperties fastPropertiesService;
    @Reference
    private transient MetadataProperties metadataProperties;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        ValueMap properties = request.getResource().getValueMap();
        List<Object> metadataFieldTypes = Arrays.asList((Object[])properties.get(PN_METADATA_FIELD_TYPES, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
        List<Object> indexRuleCapabilityProperties = Arrays.asList((Object[])properties.get(PN_FILTER_PROPERTIES, (Object)new String[]{PN_PROPERTY_INDEX}));
        Map<String, List<String>> collectedMetadata = this.metadataProperties.getMetadataProperties(request, metadataFieldTypes);
        List<String> fastProperties = this.fastPropertiesService.getFastProperties(indexRuleCapabilityProperties);
        for (Map.Entry<String, List<String>> entry : collectedMetadata.entrySet()) {
            String label = StringUtils.join((Iterable)entry.getValue(), (String)" / ") + " (" + StringUtils.removeStart((String)entry.getKey(), (String)"./") + ")";
            String value = entry.getKey();
            if (fastProperties.contains(StringUtils.removeStart((String)entry.getKey(), (String)"./"))) {
                data.put(this.fastPropertiesService.getFastLabel(label), value);
                continue;
            }
            data.put(this.fastPropertiesService.getSlowLabel(label), value);
        }
        if (metadataFieldTypes.isEmpty()) {
            this.addDeltaFastProperties(data, fastProperties);
        }
        this.dataSourceBuilder.build(request, data);
    }

    private void addDeltaFastProperties(Map<String, Object> data, List<String> fastProperties) {
        List<String> deltaFastProperties = this.fastPropertiesService.getDeltaProperties(fastProperties, data.values());
        for (String deltaFastProperty : deltaFastProperties) {
            data.put("\u26a1 " + deltaFastProperty, deltaFastProperty);
        }
    }
}

