/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRendition;
import com.adobe.aem.commons.assetshare.util.ExpressionEvaluator;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    public static final String ZIP_EXTENSION = ".zip";
    private static final DateTimeFormatter year = DateTimeFormatter.ofPattern("yyyy");
    private static final DateTimeFormatter month = DateTimeFormatter.ofPattern("MM");
    private static final DateTimeFormatter monthName = DateTimeFormatter.ofPattern("MMM");
    private static final DateTimeFormatter day = DateTimeFormatter.ofPattern("dd");
    private static final DateTimeFormatter dayName = DateTimeFormatter.ofPattern("EEE");
    private static final DateTimeFormatter hour24 = DateTimeFormatter.ofPattern("HH");
    private static final DateTimeFormatter hour12 = DateTimeFormatter.ofPattern("hh");
    private static final DateTimeFormatter minute = DateTimeFormatter.ofPattern("mm");
    private static final DateTimeFormatter ampm = DateTimeFormatter.ofPattern("a");
    @Reference
    private MimeTypeService mimeTypeService;

    @Override
    public String evaluateAssetsRenditionsExpressions(String expression, Collection<AssetModel> assetModels, Collection<String> renditionNames) {
        expression = StringUtils.replace((String)expression, (String)"${asset.count}", (String)String.valueOf(assetModels.size()));
        expression = StringUtils.replace((String)expression, (String)"${rendition.count}", (String)String.valueOf(renditionNames.size()));
        expression = StringUtils.replace((String)expression, (String)"${file.count}", (String)String.valueOf(assetModels.size() * renditionNames.size()));
        return expression;
    }

    @Override
    public String evaluateDateTimeExpressions(String expression, ZonedDateTime zonedDateTime) {
        expression = StringUtils.replace((String)expression, (String)"${year}", (String)zonedDateTime.format(year));
        expression = StringUtils.replace((String)expression, (String)"${month}", (String)zonedDateTime.format(month));
        expression = StringUtils.replace((String)expression, (String)"${month.name}", (String)zonedDateTime.format(monthName));
        expression = StringUtils.replace((String)expression, (String)"${day}", (String)zonedDateTime.format(day));
        expression = StringUtils.replace((String)expression, (String)"${day.name}", (String)zonedDateTime.format(dayName));
        expression = StringUtils.replace((String)expression, (String)"${hour.24}", (String)zonedDateTime.format(hour24));
        expression = StringUtils.replace((String)expression, (String)"${hour.12}", (String)zonedDateTime.format(hour12));
        expression = StringUtils.replace((String)expression, (String)"${minute}", (String)zonedDateTime.format(minute));
        expression = StringUtils.replace((String)expression, (String)"${am.pm}", (String)zonedDateTime.format(ampm));
        return expression;
    }

    @Override
    public String evaluateDynamicMediaExpression(String expression, AssetModel assetModel) {
        String dmName = (String)assetModel.getProperties().get("dam:scene7Name", String.class);
        String dmId = (String)assetModel.getProperties().get("dam:scene7ID", String.class);
        String dmFile = (String)assetModel.getProperties().get("dam:scene7File", String.class);
        String dmFileAvs = (String)assetModel.getProperties().get("dam:scene7FileAvs", String.class);
        String dmFolder = (String)assetModel.getProperties().get("dam:scene7Folder", String.class);
        String dmDomain = (String)assetModel.getProperties().get("dam:scene7Domain", String.class);
        String dmApiServer = (String)assetModel.getProperties().get("dam:scene7APIServer", String.class);
        String dmCompanyId = (String)assetModel.getProperties().get("dam:scene7CompanyID", String.class);
        expression = StringUtils.replace((String)expression, (String)"${dm.name}", (String)dmName);
        expression = StringUtils.replace((String)expression, (String)"${dm.id}", (String)dmId);
        expression = StringUtils.replace((String)expression, (String)"${dm.file}", (String)dmFile);
        expression = StringUtils.replace((String)expression, (String)"${dm.file.avs}", (String)dmFileAvs);
        expression = StringUtils.replace((String)expression, (String)"${dm.file.no-company}", (String)StringUtils.substringAfterLast((String)dmFile, (String)"/"));
        expression = StringUtils.replace((String)expression, (String)"${dm.folder}", (String)dmFolder);
        expression = StringUtils.replace((String)expression, (String)"${dm.domain}", (String)dmDomain);
        expression = StringUtils.replace((String)expression, (String)"${dm.api-server}", (String)dmApiServer);
        expression = StringUtils.replace((String)expression, (String)"${dm.company.id}", (String)dmCompanyId);
        expression = StringUtils.replace((String)expression, (String)"${dm.company.name}", (String)StringUtils.substringBeforeLast((String)dmFile, (String)"/"));
        return expression;
    }

    @Override
    public String evaluateAssetExpression(String expression, AssetModel assetModel) {
        String assetPath = assetModel.getPath();
        String assetUrl = assetModel.getUrl();
        String assetName = assetModel.getName();
        expression = StringUtils.replace((String)expression, (String)"${asset.path}", (String)assetPath);
        expression = StringUtils.replace((String)expression, (String)"${asset.url}", (String)assetUrl);
        expression = StringUtils.replace((String)expression, (String)"${asset.name}", (String)assetName);
        expression = StringUtils.replace((String)expression, (String)"${asset.name.no-extension}", (String)StringUtils.substringBeforeLast((String)assetModel.getName(), (String)"."));
        expression = StringUtils.replace((String)expression, (String)"${asset.extension}", (String)StringUtils.substringAfterLast((String)assetName, (String)"."));
        return expression;
    }

    @Override
    public String evaluateRenditionExpression(String expression, String renditionName) {
        expression = StringUtils.replace((String)expression, (String)"${rendition.name}", (String)renditionName);
        return expression;
    }

    @Override
    public String evaluateRenditionExpression(String expression, AssetRendition assetRendition) {
        String mimeType = assetRendition.getMimeType();
        String renditionExtension = this.mimeTypeService.getExtension(mimeType);
        expression = StringUtils.replace((String)expression, (String)"${rendition.extension}", (String)renditionExtension);
        return expression;
    }

    @Override
    public String evaluateProperties(String expression, AssetModel assetModel) {
        Pattern p = Pattern.compile("\\$\\{prop\\@([^}]+)\\}");
        Matcher m = p.matcher(expression);
        while (m.find()) {
            String replaceString = m.group(0);
            String propertyPath = m.group(1);
            String value = (String)assetModel.getProperties().get(propertyPath, (Object)"");
            expression = expression.replace(replaceString, value);
        }
        return expression;
    }
}

