/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.config;

import java.util.Dictionary;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="FormsManager Configuration", description="Configuration for Forms Manager")
@Service(value={AEMFormsManagerConfiguration.class})
public class AEMFormsManagerConfiguration {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final boolean DEFAULT_INCLUDE_OOTB_TEMPLATES = true;
    private static final boolean DEFAULT_INCLUDE_DEPRECATED_TEMPLATES = false;
    private boolean includeOOTBTemplates = true;
    private boolean includeDeprecatedTemplates = false;
    @Property(boolValue={true}, label="Include Out of the box AF And AD Templates", description=" Select this option to include Out of the box Adaptive Form and Adaptive Document Templates. Defaults to true")
    private static final String PROPERTY_INCLUDE_OOTB_TEMPLATES = "formsManagerConfig.includeOOTBTemplates";
    @Property(boolValue={false}, label="Include AEM 6.0 AF Templates", description=" Select this option to include Adaptive Form Templates that were present in AEM 6.0 and are now deprecated in AEM ver 6.2. Defaults to false")
    private static final String PROPERTY_INCLUDE_DEPRECATED_TEMPLATES = "formsManagerConfig.includeDeprecatedTemplates";

    protected void activate(ComponentContext context) throws RepositoryException {
        Dictionary props = context.getProperties();
        try {
            this.setIncludeOOTBTemplates(OsgiUtil.toBoolean(props.get(PROPERTY_INCLUDE_OOTB_TEMPLATES), true));
            this.setIncludeDeprecatedTemplates(OsgiUtil.toBoolean(props.get(PROPERTY_INCLUDE_DEPRECATED_TEMPLATES), false));
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isIncludeOOTBTemplates() {
        return this.includeOOTBTemplates;
    }

    public boolean isIncludeDeprecatedTemplates() {
        return this.includeDeprecatedTemplates;
    }

    public void setIncludeOOTBTemplates(boolean includeOOTBTemplates) {
        this.includeOOTBTemplates = includeOOTBTemplates;
    }

    public void setIncludeDeprecatedTemplates(boolean includeDeprecatedTemplates) {
        this.includeDeprecatedTemplates = includeDeprecatedTemplates;
    }
}

