/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.events;

import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={EventHandler.class})
@Properties(value={@Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"}), @Property(name="event.filter", value={"(|(path=/content/dam/formsanddocuments/*)(path=/content/forms/af/*)(path=/content/dam/formsanddocuments-themes/*))"})})
public class AssetUpdateListener
implements EventHandler {
    private static final Set<String> ignoredAttributes = new HashSet<String>();
    private static final Set<String> guideAttributes = new HashSet<String>();
    private static final Set<String> replicationAttributes = new HashSet<String>();
    public static final String REPLICATION_EVENT_TOPIC = "com/adobe/aem/formsndocuments/scheduler/formreplication";
    public static final String PROPERTY_REPLICATION_FORM_PATH = "event.form.path";
    public static final String PROPERTY_REPLICATION_ATTRIBUTE = "event.replication.attribute";
    private final Logger log = LoggerFactory.getLogger(AssetUpdateListener.class);
    private final BlockingQueue<Event> events = new LinkedBlockingQueue<Event>();
    private volatile Thread processor;
    @Reference
    private SlingRepository repository = null;
    @Reference
    private JobManager jobManager;

    @Activate
    protected void activate(ComponentContext context) throws Exception {
        this.processor = new Thread(new EventProcessor());
        this.processor.setDaemon(true);
        this.processor.start();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        Thread interrupter = this.processor;
        this.processor = null;
        interrupter.interrupt();
    }

    public void handleEvent(Event event) {
        try {
            this.events.put(event);
        }
        catch (InterruptedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        guideAttributes.add("formModelChanged");
        replicationAttributes.add("activationDate");
        replicationAttributes.add("expiryDate");
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    private class EventProcessor
    implements Runnable {
        private EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            ArrayList evts = new ArrayList();
            ArrayList<String> assetsToUpdate = new ArrayList<String>();
            while (AssetUpdateListener.this.processor == currentThread) {
                Session session = null;
                try {
                    evts.add(AssetUpdateListener.this.events.take());
                    AssetUpdateListener.this.events.drainTo(evts);
                    session = FMUtils.getFnDServiceUserSession(AssetUpdateListener.this.repository);
                    for (Event event : evts) {
                        try {
                            String aggregatedRoot;
                            String eventPath = (String)event.getProperty("path");
                            if (AssetUpdateListener.this.log.isDebugEnabled()) {
                                AssetUpdateListener.this.log.debug("Processing event:" + event.toString() + ":: event path:" + eventPath);
                            }
                            if (!session.nodeExists(aggregatedRoot = this.getAggregateRootPath(eventPath))) continue;
                            Node assetNode = session.getNode(aggregatedRoot);
                            if (assetNode.getPrimaryNodeType().getName().equals("dam:Asset")) {
                                this.processModifiedProperties(session, event, aggregatedRoot);
                            }
                            boolean updateAsset = false;
                            updateAsset = this.isModificationTimeUpdateRequired(event);
                            if (assetsToUpdate.contains(aggregatedRoot) || !updateAsset) continue;
                            assetsToUpdate.add(aggregatedRoot);
                        }
                        catch (Exception e) {
                            AssetUpdateListener.this.log.error("Exception while processing the event : " + event.toString(), (Throwable)e);
                        }
                    }
                    Calendar lastModifyTime = Calendar.getInstance();
                    for (String assetPath : assetsToUpdate) {
                        try {
                            Node contentNode;
                            if (!session.nodeExists(assetPath)) continue;
                            Node assetNode = session.getNode(assetPath);
                            if (assetNode.getPrimaryNodeType().getName().equals("cq:Page")) {
                                assetPath = FMUtils.getAssetPathFromPage(assetPath);
                                assetNode = session.getNode(assetPath);
                            }
                            if ((contentNode = FMUtils.getContentNode(assetNode, false)) == null || !FMUtils.isGuide(session, assetPath) && !FMUtils.isAFFragment(session, assetPath) && !FMUtils.isAdaptiveDocument(session, assetPath)) continue;
                            AssetUpdateListener.this.log.info("Setting jcr:lastModified for asset:" + assetPath);
                            contentNode.setProperty("jcr:lastModified", lastModifyTime);
                        }
                        catch (Exception e) {
                            AssetUpdateListener.this.log.error("Exception while setting last modification time for asset:" + assetPath, (Throwable)e);
                        }
                    }
                    assetsToUpdate.clear();
                    evts.clear();
                }
                catch (InterruptedException e) {
                    AssetUpdateListener.this.log.debug("InterruptedException in AssetUpdateListener thread", (Throwable)e);
                    AssetUpdateListener.this.log.info("Stopping the AssetUpdateListener thread.");
                }
                catch (Exception e) {
                    AssetUpdateListener.this.log.error("Error occurred while processing asset update thread : " + currentThread.toString(), (Throwable)e);
                }
                finally {
                    if (session == null) continue;
                    try {
                        if (session.hasPendingChanges()) {
                            session.save();
                        }
                        session.logout();
                    }
                    catch (Exception e) {
                        AssetUpdateListener.this.log.error("Exception while closing session", (Throwable)e);
                    }
                }
            }
        }

        private boolean isModificationTimeUpdateRequired(Event event) {
            List<String> modificationAttributes = this.getModificationAttributes(event);
            if (modificationAttributes.size() > 0) {
                for (String updatedAttribute : modificationAttributes) {
                    if ((updatedAttribute.startsWith("cq:") || updatedAttribute.startsWith("jcr:") || ignoredAttributes.contains(updatedAttribute)) && !updatedAttribute.equals("jcr:title") && !updatedAttribute.equals("jcr:description")) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        private List<String> getModificationAttributes(Event event) {
            ArrayList<String> modificationAttributes = new ArrayList<String>();
            String[] addedAttributes = (String[])event.getProperty("resourceAddedAttributes");
            String[] updatedAttributes = (String[])event.getProperty("resourceChangedAttributes");
            String[] removedAttributes = (String[])event.getProperty("resourceRemovedAttributes");
            if (addedAttributes != null) {
                if (AssetUpdateListener.this.log.isDebugEnabled()) {
                    AssetUpdateListener.this.log.debug("New Properties:" + Arrays.asList(addedAttributes));
                }
                modificationAttributes.addAll(Arrays.asList(addedAttributes));
            }
            if (updatedAttributes != null) {
                if (AssetUpdateListener.this.log.isDebugEnabled()) {
                    AssetUpdateListener.this.log.debug("Modified Properties:" + Arrays.asList(updatedAttributes));
                }
                modificationAttributes.addAll(Arrays.asList(updatedAttributes));
            }
            if (removedAttributes != null) {
                if (AssetUpdateListener.this.log.isDebugEnabled()) {
                    AssetUpdateListener.this.log.debug("Deleted Properties:" + Arrays.asList(removedAttributes));
                }
                modificationAttributes.addAll(Arrays.asList(removedAttributes));
            }
            return modificationAttributes;
        }

        private void scheduleFormReplication(Session session, String updatedAttribute, String formPath) throws FormsMgrException {
            if (replicationAttributes.contains(updatedAttribute)) {
                Date activationTime = null;
                boolean postJobEvent = true;
                try {
                    Calendar cal;
                    Node assetNode = session.getNode(formPath);
                    Node metadataNode = FMUtils.getMetadataNode(assetNode, false);
                    if (metadataNode != null && metadataNode.hasProperty(updatedAttribute) && (cal = metadataNode.getProperty(updatedAttribute).getDate()) != null && (activationTime = cal.getTime()) != null) {
                        boolean bl = postJobEvent = !activationTime.before(new Date());
                    }
                    if (postJobEvent) {
                        FMUtils.unscheduleJob(AssetUpdateListener.this.jobManager, formPath, updatedAttribute);
                        if (activationTime != null) {
                            HashMap<String, Object> props = new HashMap<String, Object>();
                            props.put(AssetUpdateListener.PROPERTY_REPLICATION_FORM_PATH, formPath);
                            props.put(AssetUpdateListener.PROPERTY_REPLICATION_ATTRIBUTE, updatedAttribute);
                            JobBuilder jobBuilder = AssetUpdateListener.this.jobManager.createJob(AssetUpdateListener.REPLICATION_EVENT_TOPIC).properties(props);
                            jobBuilder.schedule().at(activationTime).add();
                        }
                    }
                }
                catch (FormsMgrException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new FormsMgrException(e);
                }
            }
        }

        private void processModifiedProperties(Session session, Event event, String aggregatedRoot) throws FormsMgrException {
            List<String> modificationAttributes = this.getModificationAttributes(event);
            if (modificationAttributes.size() > 0) {
                for (String updatedAttribute : modificationAttributes) {
                    this.scheduleFormReplication(session, updatedAttribute, aggregatedRoot);
                    if (!FMUtils.isGuide(session, aggregatedRoot) && !FMUtils.isAFFragment(session, aggregatedRoot) && !FMUtils.isAdaptiveDocument(session, aggregatedRoot)) continue;
                    this.copyAdaptiveFormProperties(session, updatedAttribute, aggregatedRoot);
                }
            }
        }

        private void copyAdaptiveFormProperties(Session session, String updatedAttribute, String adaptableAssetPath) {
            if (guideAttributes.contains(updatedAttribute)) {
                String cqPagePath = FMUtils.getPagePathFromAsset(adaptableAssetPath);
                try {
                    if (!session.nodeExists(cqPagePath)) {
                        throw new FormsMgrException("CQ Page corresponding to Guide/AF Fragment/Adaptive Document node does not exists.");
                    }
                    Node cqPageNode = session.getNode(cqPagePath);
                    Node guideNode = session.getNode(adaptableAssetPath);
                    Node cqPagecontainerNode = cqPageNode.getNode("jcr:content/guideContainer");
                    Node metadataNode = FMUtils.getMetadataNode(guideNode, false);
                    if (metadataNode != null) {
                        if (metadataNode.hasProperty(updatedAttribute)) {
                            cqPagecontainerNode.setProperty(updatedAttribute, metadataNode.getProperty(updatedAttribute).getValue(), metadataNode.getProperty(updatedAttribute).getType());
                        } else if (cqPagecontainerNode.hasProperty(updatedAttribute)) {
                            cqPagecontainerNode.getProperty(updatedAttribute).remove();
                        }
                    }
                }
                catch (Exception e) {
                    AssetUpdateListener.this.log.error("Exception while updating adaptive form/fragment/document properties at path : " + cqPagePath, (Throwable)e);
                }
            }
        }

        private String getAggregateRootPath(String path) {
            int idx = path.indexOf("/jcr:content/");
            if (idx >= 0) {
                path = path.substring(0, idx);
            } else if (path.endsWith("/jcr:content")) {
                path = path.substring(0, path.length() - "/jcr:content".length());
            }
            return path;
        }
    }
}

