/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.predicateevaluator;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.apache.felix.scr.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, factory="com.day.cq.search.eval.PredicateEvaluator/dateComparison")
public class DateComparisonPredicateEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(DateComparisonPredicateEvaluator.class);
    public static final String DATE_COMPARISON = "dateComparison";
    public static final String PROPERTY1 = "property1";
    public static final String PROPERTY2 = "property2";
    public static final String OPERATION = "operation";
    public static final String OP_EQUALS = "equals";
    public static final String OP_UNEQUALS = "unequals";
    public static final String OP_GT = "greater";
    public static final String OP_GTE = "greaterthanequal";

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        String prop1 = p.get(PROPERTY1);
        String prop2 = p.get(PROPERTY2);
        String operation = p.get(OPERATION, OP_EQUALS);
        Node node = null;
        String path = null;
        try {
            if (prop1 != null && prop1.trim().length() != 0 && prop2 != null && prop2.trim().length() != 0) {
                node = context.getNode(row);
                path = context.getPath(row);
                if (node.hasProperty(prop1) && node.hasProperty(prop2)) {
                    Property property1 = node.getProperty(prop1);
                    Property property2 = node.getProperty(prop2);
                    if (property1.getType() == 5 && property2.getType() == 5) {
                        int compareStatus = property1.getDate().compareTo(property2.getDate());
                        if (OP_EQUALS.equals(operation)) {
                            return compareStatus == 0;
                        }
                        if (OP_UNEQUALS.equals(operation)) {
                            return compareStatus != 0;
                        }
                        if (OP_GT.equals(operation)) {
                            return compareStatus > 0;
                        }
                        if (OP_GTE.equals(operation)) {
                            return compareStatus > 0 || compareStatus == 0;
                        }
                    }
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Could not evaluate property1 = '" + prop1 + "', property2 = '" + prop2 + "', node = '" + path, (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return false;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }
}

