/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.publish;

import com.adobe.aem.formsndocuments.service.FormsRelationService;
import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.replication.PathNotFoundException;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ReferenceProvider.class})
public class AssetReferenceProvider
implements ReferenceProvider {
    private final Logger log = LoggerFactory.getLogger(AssetReferenceProvider.class);
    @org.apache.felix.scr.annotations.Reference(referenceInterface=ResourceResolverHelper.class)
    ResourceResolverHelper resourceResolverHelper;
    @org.apache.felix.scr.annotations.Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private FormsRelationService formsRelationService;
    @org.apache.felix.scr.annotations.Reference
    private SlingRepository repository = null;
    @org.apache.felix.scr.annotations.Reference(referenceInterface=QueryBuilder.class)
    private QueryBuilder queryBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Reference> findReferences(Resource resource) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        Session session = null;
        boolean localSession = false;
        try {
            session = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            if (session == null) {
                session = FMUtils.getFnDServiceUserSession(this.repository);
                localSession = true;
            }
            ResourceResolver resourceResolver = resource.getResourceResolver();
            HashSet<AssetInfo> allRelatedChildAssets = new HashSet<AssetInfo>();
            List<String> nodePaths = this.resolvePathsToFindReferences(resource.getPath(), session);
            for (String nodePath : nodePaths) {
                this.formsRelationService.getAllRelatedChildAssets(resourceResolver, nodePath, allRelatedChildAssets);
                for (AssetInfo formInfo : allRelatedChildAssets) {
                    references.add(new Reference(this.getPublishType(formInfo), formInfo.getResource().getName(), formInfo.getResource(), this.getLastModifiedTime(session, formInfo)));
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to retrieve asset dependencies. Cause:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (localSession && session != null) {
                session.logout();
            }
        }
        return references;
    }

    List<String> resolvePathsToFindReferences(String path, Session session) throws PathNotFoundException, RepositoryException {
        ArrayList<String> paths = new ArrayList<String>();
        if (path.endsWith("/jcr:content")) {
            path = path.substring(0, path.length() - "jcr:content".length() - 1);
        }
        if (path.startsWith("/content/forms/af")) {
            path = FMUtils.getAssetPathFromPage(path);
        }
        if (path.startsWith("/content/dam/formsanddocuments")) {
            Node rootAssetNode = session.getNode(path);
            if (rootAssetNode.isNodeType("dam:Asset")) {
                paths.add(path);
            }
            return paths;
        }
        Node node = session.getNode(path);
        if (node.isNodeType("cq:Page")) {
            this.log.debug("Entering query for :  resolvePathsToFindReferences for asset : " + path);
            PredicateGroup predicateGroup = new PredicateGroup();
            predicateGroup.setAllRequired(true);
            Predicate typePredicate = new Predicate("type");
            typePredicate.set("type", "nt:unstructured");
            Predicate pathPredicate = new Predicate("path");
            pathPredicate.set("path", path);
            pathPredicate.set("exact", "false");
            PredicateGroup refPredicateGroup = new PredicateGroup();
            Predicate refPredicate = new Predicate("property");
            refPredicate.set("property", "sling:resourceType");
            refPredicate.set("operation", "equals");
            refPredicate.set("value", "fd/af/components/aemform");
            refPredicateGroup.add(refPredicate);
            predicateGroup.add(refPredicateGroup);
            predicateGroup.add(typePredicate);
            predicateGroup.add(pathPredicate);
            Query query = this.queryBuilder.createQuery(predicateGroup, session);
            SearchResult result = query.getResult();
            this.log.debug("Query execution time (ms) " + result.getExecutionTimeMillis());
            if (result != null) {
                Iterator<Node> iter = result.getNodes();
                while (iter.hasNext()) {
                    Node assetNode = iter.next();
                    this.checkPropertyAndAddPath(assetNode, "formRef", paths);
                }
            }
        }
        return paths;
    }

    private void checkPropertyAndAddPath(Node assetNode, String propertyName, List<String> paths) throws RepositoryException {
        if (assetNode.hasProperty(propertyName)) {
            String assetPath = assetNode.getProperty(propertyName).getString();
            if (assetPath.startsWith("/content/forms/af")) {
                assetPath = FMUtils.getAssetPathFromPage(assetPath);
            }
            paths.add(assetPath);
        }
    }

    private String getPublishType(AssetInfo formInfo) throws RepositoryException {
        Node node;
        String publishType = "form";
        Resource res = formInfo.getResource();
        if (res != null && (node = res.adaptTo(Node.class)) != null && node.isNodeType("dam:Asset")) {
            publishType = "asset";
        }
        return publishType;
    }

    private long getLastModifiedTime(Session session, AssetInfo assetInfo) throws FormsMgrException {
        long lastModifiedTime = assetInfo.getLastModifiedOrCreatedTime(session);
        if (lastModifiedTime == -1L) {
            lastModifiedTime = Long.MAX_VALUE;
        }
        return lastModifiedTime;
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindFormsRelationService(FormsRelationService formsRelationService) {
        this.formsRelationService = formsRelationService;
    }

    protected void unbindFormsRelationService(FormsRelationService formsRelationService) {
        if (this.formsRelationService == formsRelationService) {
            this.formsRelationService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

