/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.rnc;

import com.adobe.aem.formsndocuments.exception.FormsNDocumentsException;
import com.adobe.aem.formsndocuments.rnc.ReviewManagementService;
import com.adobe.aem.formsndocuments.util.RnCUtil;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="ReviewManagerServlet", description="ReviewManagerServlet")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.resourceTypes", value={"fd/fm/reviewServlet"}), @Property(name="sling.servlet.methods", value={"GET", "POST"})})
public class ReviewManagerServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1059891247634439445L;
    private static final String REVIEW_ACTION = "reviewAction";
    private static final String CREATE_REVIEW = "createReview";
    private static final String UPDATE_REVIEW = "updateReview";
    private static final String END_REVIEW = "endReview";
    private static final String UTF8_CHAR_ENCODING = "utf-8";
    private static final String CONTENT_JSON = "application/json";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String ERROR_CODE = "errorCode";
    @Reference(referenceInterface=ReviewManagementService.class)
    ReviewManagementService reviewManagementService;
    @Reference(referenceInterface=SlingRepository.class)
    SlingRepository slingRepository;
    private static Logger logger = LoggerFactory.getLogger(ReviewManagerServlet.class);

    private static void writeErrorResponseHeader(SlingHttpServletResponse response) {
        response.setContentType(CONTENT_JSON);
        response.setStatus(500);
    }

    private static void writeResponseError(OutputStream outputStream, FormsNDocumentsException fndException) {
        logger.trace("Entering writeResponseError.");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put(ERROR_CODE, fndException.getCode());
        errorMap.put(ERROR_MESSAGE, fndException.getMessage());
        JSONArray jarray = new JSONArray();
        jarray.put(errorMap);
        try {
            outputStream.write(jarray.toString().getBytes());
        }
        catch (IOException e) {
            logger.error("Error while writting error information ", (Throwable)e);
        }
        logger.trace("Exiting writeResponseError.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        logger.trace("Entering doGet.");
        String assetPath = request.getParameter("assetPath");
        Map<String, String> reviewInfo = null;
        response.setCharacterEncoding(UTF8_CHAR_ENCODING);
        ServletOutputStream outputStream = null;
        try {
            response.setContentType(CONTENT_JSON);
            outputStream = response.getOutputStream();
            RnCUtil.checkAssetPathArgument(assetPath);
            reviewInfo = this.reviewManagementService.fetchReviewInfo(request.getResourceResolver(), assetPath);
            JSONArray jarray = new JSONArray();
            jarray.put(reviewInfo);
            outputStream.write(jarray.toString().getBytes());
        }
        catch (FormsMgrException fmException) {
            logger.error("Error fetching the review information ", (Throwable)fmException);
            if (fmException instanceof FormsNDocumentsException) {
                ReviewManagerServlet.writeErrorResponseHeader(response);
                ReviewManagerServlet.writeResponseError((OutputStream)outputStream, (FormsNDocumentsException)fmException);
            }
        }
        catch (IOException e) {
            logger.error("Error while writting data ", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close the object output stream", (Throwable)e);
                }
            }
        }
        logger.trace("Exiting doGet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        block18: {
            String action = request.getParameter(REVIEW_ACTION);
            String assetPath = request.getParameter("assetPath");
            OutputStream outputStream = null;
            try {
                RnCUtil.checkAssetPathArgument(assetPath);
                if (CREATE_REVIEW.equals(action)) {
                    String reviewName = request.getParameter("reviewName");
                    String reviewDescription = request.getParameter("reviewDescription");
                    String deadline = request.getParameter("reviewDeadline");
                    String[] reviewerList = request.getParameterValues("reviewers");
                    this.reviewManagementService.beginReview(reviewName, reviewDescription, deadline, reviewerList, assetPath);
                    break block18;
                }
                if (UPDATE_REVIEW.equals(action)) {
                    String reviewDescription = request.getParameter("reviewDescription");
                    String deadline = request.getParameter("reviewDeadline");
                    String[] reviewerList = request.getParameterValues("reviewers");
                    this.reviewManagementService.updateReview(assetPath, reviewDescription, deadline, reviewerList);
                    break block18;
                }
                if (END_REVIEW.equals(action)) {
                    this.reviewManagementService.endReview(assetPath);
                    break block18;
                }
                Object[] args = new Object[]{action};
                throw new FormsNDocumentsException("AEM-FMG-700-018", args);
            }
            catch (FormsMgrException fmException) {
                logger.error("Error fetching the review information ", (Throwable)fmException);
                if (fmException instanceof FormsNDocumentsException) {
                    FormsNDocumentsException fndException = (FormsNDocumentsException)fmException;
                    try {
                        ReviewManagerServlet.writeErrorResponseHeader(response);
                        outputStream = response.getOutputStream();
                        ReviewManagerServlet.writeResponseError(outputStream, fndException);
                    }
                    catch (IOException e) {
                        logger.error("Error while writting data ", (Throwable)e);
                    }
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("Failed to close the object output stream", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void bindReviewManagementService(ReviewManagementService reviewManagementService) {
        this.reviewManagementService = reviewManagementService;
    }

    protected void unbindReviewManagementService(ReviewManagementService reviewManagementService) {
        if (this.reviewManagementService == reviewManagementService) {
            this.reviewManagementService = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

