/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.rnc;

import com.adobe.aem.formsndocuments.preprocess.DeletePreprocessor;
import com.adobe.aem.formsndocuments.rnc.ReviewManagementService;
import com.adobe.aem.formsndocuments.util.RnCUtil;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DeletePreprocessor.class})
public class RnCDeletePreprocessor
implements DeletePreprocessor {
    private static final String METADATA_PATH = "/jcr:content/metadata";
    private static Logger logger = LoggerFactory.getLogger(RnCDeletePreprocessor.class);
    @Reference(referenceInterface=SlingRepository.class)
    SlingRepository slingRepository;
    @Reference(referenceInterface=ResourceResolverHelper.class)
    ResourceResolverHelper resourceResolverHelper;
    @Reference(referenceInterface=ReviewManagementService.class)
    ReviewManagementService reviewManagementService;

    @Override
    public void preprocess(Session userSession, String assetPath, Map params) {
        logger.trace("Entering preprocess.");
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        try {
            Node asset = RnCUtil.checkNodeExistance(assetPath + METADATA_PATH, resourceResolver);
            if (asset.hasProperty("underReview") && asset.getProperty("underReview").getBoolean()) {
                this.reviewManagementService.cleanReview(assetPath, userSession, false);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to cleanup the review ", (Throwable)e);
        }
        logger.trace("Exiting preprocess.");
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindReviewManagementService(ReviewManagementService reviewManagementService) {
        this.reviewManagementService = reviewManagementService;
    }

    protected void unbindReviewManagementService(ReviewManagementService reviewManagementService) {
        if (this.reviewManagementService == reviewManagementService) {
            this.reviewManagementService = null;
        }
    }
}

