/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.scheduler;

import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DeleteTempArchiveScheduler.class})
public class DeleteTempArchiveScheduler {
    private static final long DEFAULT_DELETION_SCHEDULING_PERIOD = 720L;
    private long deletionSchedulingPeriod;
    @Reference(referenceInterface=SlingRepository.class)
    private SlingRepository repository;
    @Reference(referenceInterface=Scheduler.class)
    private Scheduler scheduler;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DELETE_TEMP_ARCHIVE_JOB_NAME = "FMDeleteTempArchive";

    protected void activate(ComponentContext componentContext) {
        this.setDeletionSchedulingPeriod(720L);
        long period = this.getDeletionSchedulingPeriod() * 60L;
        this.log.info("Period for DeleteTempArchiveScheduler Service : " + period + " seconds");
        HashMap<String, Serializable> jobConfig = new HashMap<String, Serializable>();
        boolean runConcurrently = false;
        Runnable deleteTempArchiveJob = new Runnable(){

            @Override
            public void run() {
                DeleteTempArchiveScheduler.this.log.info("Running DeleteTempArchiveScheduler service.");
                try {
                    DeleteTempArchiveScheduler.this.deleteTempArchives();
                }
                catch (Exception e) {
                    DeleteTempArchiveScheduler.this.log.error("Exception occured while running deletion scheduler ", (Throwable)e);
                }
            }
        };
        try {
            this.log.debug("Adding job FMDeleteTempArchive to the scheduler");
            this.scheduler.addPeriodicJob(DELETE_TEMP_ARCHIVE_JOB_NAME, deleteTempArchiveJob, jobConfig, period, runConcurrently);
        }
        catch (Exception e) {
            this.log.error("Exception occured while adding job to the scheduler ", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        try {
            this.log.debug("Removing job FMDeleteTempArchive from scheduler");
            this.scheduler.removeJob(DELETE_TEMP_ARCHIVE_JOB_NAME);
        }
        catch (NoSuchElementException noJobException) {
            this.log.error("Exception while deregistering the temp archive deletion job", (Throwable)noJobException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTempArchives() throws FormsMgrException {
        Session session = null;
        try {
            session = FMUtils.getFnDServiceUserSession(this.repository);
            FMUtils.deleteTempArchives(session);
        }
        catch (Exception e) {
            this.log.error("Exception while deleting temporary archives.", (Throwable)e);
            this.throwFormsManagerException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void throwFormsManagerException(Exception e) throws FormsMgrException {
        if (e instanceof FormsMgrException) {
            throw (FormsMgrException)e;
        }
        throw new FormsMgrException(e);
    }

    public long getDeletionSchedulingPeriod() {
        return this.deletionSchedulingPeriod;
    }

    public void setDeletionSchedulingPeriod(long deletionSchedulingPeriod) {
        this.deletionSchedulingPeriod = deletionSchedulingPeriod;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }
}

