/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.scheduler;

import com.adobe.aem.formsndocuments.publish.PublishService;
import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="FormReplicationScheduler")
@Service(value={JobConsumer.class})
@Property(name="job.topics", value={"com/adobe/aem/formsndocuments/scheduler/formreplication"})
public class FormReplicationScheduler
implements JobConsumer {
    private final Logger log = LoggerFactory.getLogger(FormReplicationScheduler.class);
    @Reference
    private SlingRepository repository = null;
    @Reference(referenceInterface=ResourceResolverFactory.class)
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(referenceInterface=PublishService.class)
    private PublishService publishService;
    @Reference
    private JobManager jobManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobConsumer.JobResult process(Job job) {
        this.log.debug("Processing Replication Job with id {}", (Object)job.getId());
        String formPath = (String)job.getProperty("event.form.path");
        String replicationAtribute = (String)job.getProperty("event.replication.attribute");
        Session jobSession = null;
        ResourceResolver resourceResolver = null;
        try {
            jobSession = FMUtils.getFnDServiceUserSession(this.repository);
            if ("activationDate".equals(replicationAtribute)) {
                resourceResolver = FMUtils.getResourceResolver(this.resourceResolverFactory, jobSession);
                this.log.info("Executing timed topic event to activate the form " + formPath + " and its related assets.");
                Set<AssetInfo> assetsToPublish = this.publishService.getRelatedAssetsToPublish(resourceResolver, formPath);
                ArrayList<String> permittedAssetsToPublish = new ArrayList<String>();
                boolean publishPermission = true;
                for (AssetInfo formInfo : assetsToPublish) {
                    Resource resource = formInfo.getResource();
                    if (!FMUtils.canReplicate(resource.getPath(), jobSession)) {
                        this.log.error("User does not have permissions to publish asset:" + resource.getPath());
                        publishPermission = false;
                    }
                    permittedAssetsToPublish.add(resource.getPath());
                }
                if (publishPermission) {
                    this.publishService.publish(jobSession, permittedAssetsToPublish);
                }
            } else if ("expiryDate".equals(replicationAtribute)) {
                this.log.info("Executing timed topic event to deactivate the form " + formPath);
                this.publishService.deactivate(jobSession, Collections.singletonList(formPath));
            }
        }
        catch (Exception e) {
            this.log.error("Exception occurred while carrying out scheduled activation/deactivation of form : " + formPath, (Throwable)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
            if (jobSession != null) {
                jobSession.logout();
            }
        }
        FMUtils.unscheduleJob(this.jobManager, formPath, replicationAtribute);
        return JobConsumer.JobResult.OK;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    protected void unbindPublishService(PublishService publishService) {
        if (this.publishService == publishService) {
            this.publishService = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }
}

