/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.service.impl;

import com.adobe.aem.formsndocuments.preprocess.DeletePreprocessor;
import com.adobe.aem.formsndocuments.publish.PublishService;
import com.adobe.aem.formsndocuments.service.FMCRUDService;
import com.adobe.aem.formsndocuments.util.FMConstants;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aem.formsndocuments.util.ThumbnailUtil;
import com.adobe.aemds.guide.utils.GuideThemeUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={FMCRUDService.class})
public class FMCRUDServiceImpl
implements FMCRUDService {
    private final Logger log = LoggerFactory.getLogger(FMCRUDServiceImpl.class);
    @Reference(referenceInterface=DeletePreprocessor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<DeletePreprocessor> deletePreprocessors = new CopyOnWriteArrayList<DeletePreprocessor>();
    @Reference(referenceInterface=PublishService.class)
    private PublishService publishService;
    @Reference(referenceInterface=ResourceResolverFactory.class)
    ResourceResolverFactory resourceResolverFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preprocessDelete(Session session, String assetPath) throws FormsMgrException {
        HashMap preprocessParams = new HashMap();
        this.log.info("Invoking delete preprocessors for asset:" + assetPath);
        for (DeletePreprocessor preprocessor : this.deletePreprocessors) {
            this.log.debug("Invoking preprocessor:" + preprocessor.getClass().getName());
            try {
                preprocessor.preprocess(session, assetPath, preprocessParams);
            }
            catch (Exception e) {
                this.log.warn("Exception in delete preprocess. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
        ResourceResolver resourceResolver = null;
        try {
            ReplicationStatus replicationStatus;
            resourceResolver = FMUtils.getResourceResolver(this.resourceResolverFactory, session);
            Resource resource = resourceResolver.getResource(assetPath);
            if (resource != null && ((replicationStatus = resource.adaptTo(ReplicationStatus.class)).isActivated() || replicationStatus.isDelivered())) {
                this.log.info("Deactivating asset: " + assetPath);
                this.publishService.deactivate(session, Arrays.asList(assetPath));
            }
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public void deleteCRXResource(Session session, String resourcePath) throws FormsMgrException {
        try {
            if (session == null) {
                Object[] args = new Object[]{"session", session};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (!session.nodeExists(resourcePath)) {
                Object[] args = new Object[]{resourcePath};
                throw new FormsMgrException("AEM-FMG-700-002", args);
            }
            FMConstants.CoreAssetType assetType = FMUtils.getAssetType(session, resourcePath);
            if (FMUtils.isForm(assetType) || assetType == FMConstants.CoreAssetType.GUIDE || assetType == FMConstants.CoreAssetType.AFFRAGMENT || assetType == FMConstants.CoreAssetType.FORMSET || assetType == FMConstants.CoreAssetType.RESOURCE || assetType == FMConstants.CoreAssetType.ADAPTIVEDOCUMENT || assetType == FMConstants.CoreAssetType.THEME) {
                this.preprocessDelete(session, resourcePath);
                this.deleteAsset(session, resourcePath, assetType);
            } else if (assetType == FMConstants.CoreAssetType.FOLDER) {
                List<String> childAssets = this.getAllAssets(session, resourcePath);
                for (String childAssetPath : childAssets) {
                    if (FMUtils.isFolder(session, childAssetPath) || FMUtils.isApplication(session, childAssetPath)) continue;
                    this.preprocessDelete(session, childAssetPath);
                }
                this.deleteAsset(session, resourcePath, assetType);
            }
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    private void deleteAsset(Session session, String resourcePath, FMConstants.CoreAssetType assetType) throws FormsMgrException {
        try {
            String clientlibPath;
            Node resourceNode = session.getNode(resourcePath);
            if (assetType == FMConstants.CoreAssetType.GUIDE || assetType == FMConstants.CoreAssetType.FOLDER || assetType == FMConstants.CoreAssetType.AFFRAGMENT || assetType == FMConstants.CoreAssetType.ADAPTIVEDOCUMENT) {
                String cqPagePath = FMUtils.getPagePathFromAsset(resourcePath);
                if (session.nodeExists(cqPagePath)) {
                    session.getNode(cqPagePath).remove();
                }
            } else if (assetType == FMConstants.CoreAssetType.THEME && session.nodeExists(clientlibPath = FMUtils.getClientlibPath(resourceNode))) {
                session.getNode(clientlibPath).remove();
            }
            resourceNode.remove();
            this.log.info((Object)((Object)assetType) + " removed successfully from path : " + resourcePath);
            session.save();
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    public List<String> getAllAssets(Session session, String folderPath) throws FormsMgrException {
        ArrayList<String> assetList = new ArrayList<String>();
        this.populateAllAssets(session, assetList, folderPath);
        return assetList;
    }

    private void populateAllAssets(Session session, List<String> assetList, String folderPath) throws FormsMgrException {
        block8: {
            try {
                if (folderPath != null && !folderPath.isEmpty()) {
                    Node rootNode;
                    NodeIterator iter;
                    if (session.nodeExists(folderPath) && (iter = (rootNode = session.getNode(folderPath)).getNodes()) != null) {
                        int i = 0;
                        while ((long)i < iter.getSize()) {
                            Node node = iter.nextNode();
                            String nodePath = node.getPath();
                            FMConstants.CoreAssetType assetType = FMUtils.getAssetType(session, nodePath);
                            if (assetType == FMConstants.CoreAssetType.FOLDER) {
                                assetList.add(nodePath);
                                this.populateAllAssets(session, assetList, nodePath);
                            } else if (assetType == FMConstants.CoreAssetType.GUIDE || assetType == FMConstants.CoreAssetType.FORM || assetType == FMConstants.CoreAssetType.PDFFORM || assetType == FMConstants.CoreAssetType.PRINTFORM || assetType == FMConstants.CoreAssetType.RESOURCE) {
                                assetList.add(nodePath);
                            }
                            ++i;
                        }
                    }
                    break block8;
                }
                throw new FormsMgrException("Invalid Asset path:" + folderPath);
            }
            catch (Exception e) {
                throw FMUtils.getFormsMgrException(e);
            }
        }
    }

    protected void bindDeletePreprocessors(DeletePreprocessor deletePreprocessor) {
        this.deletePreprocessors.add(deletePreprocessor);
    }

    protected void unbindDeletePreprocessors(DeletePreprocessor deletePreprocessor) {
        this.deletePreprocessors.remove(deletePreprocessor);
    }

    @Override
    public Asset createAsset(ResourceResolver resolver, JSONObject assetJSON) throws FormsMgrException {
        try {
            String propertyValue;
            String propertyName;
            Iterator<String> jsonIter;
            AssetManager assetManager = resolver.adaptTo(AssetManager.class);
            Asset asset = assetManager.createAsset(assetJSON.getString("path"));
            String type = assetJSON.getString("assetType");
            ValueMap vm = asset.adaptTo(ValueMap.class);
            if (assetJSON.has("assetJcrProperties")) {
                JSONObject jcrPropertyJSON = assetJSON.getJSONObject("assetJcrProperties");
                jsonIter = jcrPropertyJSON.keys();
                while (jsonIter.hasNext()) {
                    propertyName = jsonIter.next();
                    propertyValue = jcrPropertyJSON.getString(propertyName);
                    vm.put(propertyName, propertyValue);
                }
            }
            vm.put(type, "1");
            JSONObject metadataPropertyJSON = assetJSON.getJSONObject("metadataProperties");
            Resource metadataResource = resolver.getResource(asset, "jcr:content/metadata");
            ModifiableValueMap mvm = metadataResource.adaptTo(ModifiableValueMap.class);
            jsonIter = metadataPropertyJSON.keys();
            while (jsonIter.hasNext()) {
                propertyName = jsonIter.next();
                propertyValue = metadataPropertyJSON.getString(propertyName);
                if (propertyName.equals("cq:tags")) {
                    if (JSONArray.class.isAssignableFrom(metadataPropertyJSON.get("cq:tags").getClass())) {
                        JSONArray jsonArray = metadataPropertyJSON.getJSONArray("cq:tags");
                        if (jsonArray == null) continue;
                        int arrLen = jsonArray.length();
                        String[] tags = new String[arrLen];
                        for (int i = 0; i < arrLen; ++i) {
                            tags[i] = jsonArray.optString(i);
                        }
                        TagManager tagManager = resolver.adaptTo(TagManager.class);
                        if (tagManager == null || tags == null) continue;
                        ArrayList<Tag> processedTags = new ArrayList<Tag>();
                        for (String tagId : tags) {
                            Tag tag = tagManager.resolve(tagId);
                            if (tag == null) {
                                tag = tagManager.createTagByTitle(tagId, Locale.ENGLISH);
                            }
                            processedTags.add(tag);
                        }
                        tagManager.setTags(metadataResource, processedTags.toArray(new Tag[tags.length]), false);
                        continue;
                    }
                    mvm.put(propertyName, propertyValue.split(","));
                    continue;
                }
                mvm.put(propertyName, propertyValue.toString());
            }
            if (!"formset".equals(type)) {
                resolver.adaptTo(Session.class).getNode(asset.getPath() + "/" + "jcr:content" + "/" + "related").remove();
            }
            return asset;
        }
        catch (JSONException e) {
            throw new FormsMgrException("AEM-FMG-800-005");
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    @Override
    public void createFormset(ResourceResolver resolver, JSONObject formsetJSON) throws FormsMgrException, IOException {
        Asset asset = this.createUpdateFormset(resolver, formsetJSON);
        this.generateFormsetThumbnail(resolver, asset.getPath());
    }

    @Override
    public void updateFormset(ResourceResolver resolver, JSONObject formsetJSON) throws FormsMgrException {
        this.createUpdateFormset(resolver, formsetJSON);
    }

    @Override
    public void generateFormsetThumbnail(ResourceResolver resolver, String formsetPath) throws FormsMgrException, IOException {
        if (formsetPath != null && !formsetPath.isEmpty()) {
            Asset asset = resolver.getResource(formsetPath).adaptTo(Asset.class);
            ThumbnailUtil.addThumbnail(resolver.getResource(formsetPath), this.getMembers(asset, "forms"));
            resolver.commit();
        }
    }

    @Override
    public String createFragmentFromPanel(ResourceResolver resolver, JSONObject params) throws FormsMgrException {
        try {
            Node metadataNode;
            String inputFormAssetsNodePath;
            String inputFormCQPagePath;
            String errorMsg = new String();
            if (!this.isValidFragmentInputParams(params, errorMsg)) {
                this.log.error(errorMsg);
                throw new FormsMgrException("AEM-FMG-700-001");
            }
            Session session = resolver.adaptTo(Session.class);
            JSONObject assetJson = new JSONObject();
            JSONObject metadataProperties = new JSONObject(params.getString("metadataProperties"));
            assetJson.put("metadataProperties", metadataProperties);
            String panelPath = params.getString("panelPath");
            String fragName = params.getString("name");
            String inputTargetPath = params.has("targetPath") ? params.getString("targetPath") : null;
            String targetFragPath = this.getTargetFragmentPath(resolver, panelPath, inputTargetPath, fragName);
            if (metadataProperties.has("cq:tags")) {
                String tags = metadataProperties.getString("cq:tags");
                if (tags != null && !tags.isEmpty()) {
                    metadataProperties.put("cq:tags", StringUtils.split((String)tags, (String)","));
                } else {
                    metadataProperties.remove("cq:tags");
                }
            }
            FMConstants.FORM_MODEL formModel = FMConstants.FORM_MODEL.NONE;
            String inputFormModelStr = metadataProperties.getString("formmodel");
            if ("formtemplates".equals(inputFormModelStr)) {
                formModel = FMConstants.FORM_MODEL.FORM_TEMPLATE;
            } else if ("xmlschema".equals(inputFormModelStr)) {
                formModel = FMConstants.FORM_MODEL.XML_SCHEMA;
            } else if ("none".equals(inputFormModelStr)) {
                metadataProperties.remove("fragmentModelRoot");
            }
            FMUtils.prepareJsonToCreateDAMAsset(resolver, assetJson, FMConstants.CoreAssetType.AFFRAGMENT, targetFragPath, fragName);
            this.createAsset(resolver, assetJson);
            String createdFragmentAssetPath = assetJson.getString("path");
            Node cqPageNode = FMUtils.createCQPageNode(resolver, assetJson, FMConstants.CoreAssetType.AFFRAGMENT, formModel, null);
            String fragmentCQPagePath = cqPageNode.getPath();
            JSONObject panelJson = new JSONObject(params.getString("panelJson"));
            String fragmentRootPanelPath = fragmentCQPagePath + "/" + "jcr:content/guideContainer" + "/" + "rootPanel";
            FMUtils.JsonToJcrNode(session.getNode(fragmentRootPanelPath + "/" + "items"), panelJson.getJSONObject("items"));
            AssetManager assetManager = resolver.adaptTo(AssetManager.class);
            Resource resource = FMUtils.getClosestNodeUpInHierarchy(resolver, panelPath, "jcr:primaryType", "cq:Page", false);
            String string = inputFormCQPagePath = resource == null ? null : resource.getPath();
            if (inputFormCQPagePath != null && session.nodeExists(inputFormAssetsNodePath = inputFormCQPagePath + "/" + "jcr:content/guideContainer/assets")) {
                String fragmentAssetNodePath = fragmentCQPagePath + "/" + "jcr:content/guideContainer/assets";
                assetManager.copyAsset(inputFormAssetsNodePath, fragmentAssetNodePath);
                String fragmentDictionaryPath = fragmentAssetNodePath + "/" + "dictionary";
                if (session.nodeExists(fragmentDictionaryPath)) {
                    Node dictionaryNode = session.getNode(fragmentDictionaryPath);
                    NodeIterator iter = dictionaryNode.getNodes();
                    long iteratorsize = iter.getSize();
                    for (long i = 0L; i < iteratorsize; ++i) {
                        iter.nextNode().setProperty("sling:basename", fragmentDictionaryPath);
                    }
                }
            }
            this.addImagesInCreatedFragment(assetManager, panelJson, panelPath, fragmentRootPanelPath);
            if (formModel == FMConstants.FORM_MODEL.XML_SCHEMA && "/assets/xsdRef.xsd".equals(metadataProperties.getString("xsdRef")) && (metadataNode = FMUtils.getMetadataNode(session, inputFormCQPagePath, false)) != null && metadataNode.hasProperty("xsdRef")) {
                String xsdRefVal = metadataNode.getProperty("xsdRef").getString();
                Node fragMetadataNode = FMUtils.getMetadataNode(session, createdFragmentAssetPath, false);
                fragMetadataNode.setProperty("xsdRef", xsdRefVal);
            }
            resolver.commit();
            return createdFragmentAssetPath;
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Adaptive Form Fragment creation failed ", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-007");
        }
    }

    private void addImagesInCreatedFragment(AssetManager assetManager, JSONObject panelJson, String srcPanelPath, String targetFragmentPath) throws FormsMgrException {
        Iterator<String> keys = panelJson.keys();
        try {
            while (keys.hasNext()) {
                String key = keys.next();
                Object property = panelJson.get(key);
                if (!JSONObject.class.isAssignableFrom(property.getClass())) continue;
                JSONObject jsonData = (JSONObject)property;
                if (jsonData.has("jcr:primaryType") && jsonData.getString("jcr:primaryType").equals("nt:file")) {
                    assetManager.copyAsset(srcPanelPath + "/" + key, targetFragmentPath + "/" + key);
                    continue;
                }
                this.addImagesInCreatedFragment(assetManager, jsonData, srcPanelPath + "/" + key, targetFragmentPath + "/" + key);
            }
        }
        catch (JSONException e) {
            this.log.error("JSON Exception while parsing panelJson in updatePanelJsonToCreateFragment() ", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-007");
        }
    }

    private boolean isValidFragmentInputParams(JSONObject params, String errorMsg) throws FormsMgrException {
        boolean returnVal = false;
        errorMsg = "Invalid Parameter : ";
        try {
            if (!params.has("metadataProperties")) {
                errorMsg = errorMsg.concat("fragment metadata properties missing");
            } else if (!params.has("panelPath") || params.getString("panelPath").isEmpty()) {
                errorMsg = errorMsg.concat("panel path missing");
            } else if (!params.has("panelJson")) {
                errorMsg = errorMsg.concat("panel json missing");
            } else if (!params.has("name") || params.getString("name").isEmpty()) {
                errorMsg = errorMsg.concat("fragment name missing");
            } else {
                JSONObject metadataProperties = new JSONObject(params.getString("metadataProperties"));
                if (!metadataProperties.has("formmodel") || metadataProperties.getString("formmodel").isEmpty()) {
                    errorMsg = errorMsg.concat("fragment FORM MODEL missing");
                } else {
                    returnVal = true;
                }
            }
        }
        catch (JSONException e) {
            this.log.error("JSON Exception in isValidFragmentInputParams() while validating input params for Fragment creation from existing panel ", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-007");
        }
        return returnVal;
    }

    @Override
    public void cleanUpForm(Session session, String formPath) throws FormsMgrException {
        block9: {
            try {
                if (session == null) {
                    Object[] args = new Object[]{"session", session};
                    throw new FormsMgrException("AEM-FMG-700-001", args);
                }
                if (session.nodeExists(formPath)) {
                    Node formNode = session.getNode(formPath);
                    Node metaDataNode = FMUtils.getMetadataNode(formNode, false);
                    if (metaDataNode != null) {
                        if (metaDataNode.hasProperty("underReview")) {
                            this.cleanUpReviewInfo(session, formPath);
                        }
                        if (metaDataNode.hasProperty("targetEnabled")) {
                            this.cleanUpABTestingInfo(session, formPath);
                        }
                        if (metaDataNode.hasProperty("analyticsEnabled")) {
                            this.cleanUpAnalyticsInfo(session, formPath);
                        }
                    }
                    break block9;
                }
                throw new FormsMgrException("AEM-FMG-700-002", new String[]{formPath});
            }
            catch (FormsMgrException e) {
                throw e;
            }
            catch (RepositoryException e) {
                throw new FormsMgrException(e);
            }
        }
    }

    @Override
    public void cleanUpReviewInfo(Session session, String formPath) throws FormsMgrException {
        try {
            if (session == null) {
                Object[] args = new Object[]{"session", session};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            Node formNode = session.getNode(formPath);
            Node metaDataNode = FMUtils.getMetadataNode(formNode, false);
            if (metaDataNode != null && metaDataNode.hasProperty("reviewId")) {
                metaDataNode.setProperty("reviewId", (Value)null);
                metaDataNode.setProperty("reviewInitiator", (Value)null);
                metaDataNode.setProperty("underReview", (Value)null);
                String reviewContainerPath = formNode.getPath() + "/" + "jcr:content" + "/" + "reviewcontainer";
                Node reviewContainerNode = session.getNode(reviewContainerPath);
                reviewContainerNode.remove();
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{"Review", formPath};
            throw new FormsMgrException("AEM-FMG-700-025", args);
        }
    }

    @Override
    public void cleanUpABTestingInfo(Session session, String formPath) throws FormsMgrException {
        this.cleanUpFormABTestingInfo(session, formPath);
        this.cleanUpFormPageABTestingInfo(session, FMUtils.getPagePathFromAsset(formPath));
    }

    @Override
    public void cleanUpFormABTestingInfo(Session session, String formPath) throws FormsMgrException {
        try {
            if (session == null) {
                Object[] args = new Object[]{"session", session};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (session.nodeExists(formPath)) {
                Node formNode = session.getNode(formPath);
                Node metaDataNode = FMUtils.getMetadataNode(formNode, false);
                if (metaDataNode != null) {
                    metaDataNode.setProperty("targetEnabled", (Value)null);
                    metaDataNode.setProperty("targetCampaignName", (Value)null);
                    metaDataNode.setProperty("targetCampaignObj", (Value)null);
                    metaDataNode.setProperty("targetAudience", (Value)null);
                    metaDataNode.setProperty("targetPercentage", (Value)null);
                    metaDataNode.setProperty("targetUrlDomains", (Value)null);
                    metaDataNode.setProperty("targetProfile", (Value)null);
                    metaDataNode.setProperty("targetStartDate", (Value)null);
                    metaDataNode.setProperty("targetLastModified", (Value)null);
                } else {
                    this.log.error("Unable to retrieve metadata node for the form : " + formPath);
                }
            } else {
                this.log.error("Unable to retrieve node at path : " + formPath);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{"A/B Testing", formPath};
            throw new FormsMgrException("AEM-FMG-700-025", args);
        }
    }

    @Override
    public void cleanUpFormPageABTestingInfo(Session session, String pagePath) throws FormsMgrException {
        try {
            if (session == null) {
                Object[] args = new Object[]{"session", session};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (session.nodeExists(pagePath)) {
                Node pageNode = session.getNode(pagePath);
                Node contentNode = FMUtils.getContentNode(pageNode, false);
                if (contentNode != null && contentNode.hasProperty("targetEnabled")) {
                    contentNode.setProperty("targetEnabled", (Value)null);
                    if (contentNode.hasNode("guideContainer2")) {
                        Node guideContainerNode2 = contentNode.getNode("guideContainer2");
                        guideContainerNode2.remove();
                    }
                } else {
                    this.log.error("Unable to retrieve JCR content node for page path : " + pagePath);
                }
            } else {
                this.log.error("Unable to retrieve node at path : " + pagePath);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{"A/B Testing", FMUtils.getAssetPathFromPage(pagePath)};
            throw new FormsMgrException("AEM-FMG-700-025", args);
        }
    }

    @Override
    public void cleanUpAnalyticsInfo(Session session, String formPath) throws FormsMgrException {
        try {
            if (session == null) {
                Object[] args = new Object[]{"session", session};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (session.nodeExists(formPath)) {
                Node metaDataNode;
                Node formNode = session.getNode(formPath);
                Node analyticsDataNode = FMUtils.getAnalyticsDataNode(formNode, false);
                if (analyticsDataNode != null) {
                    analyticsDataNode.remove();
                }
                if ((metaDataNode = FMUtils.getMetadataNode(formNode, false)) != null) {
                    metaDataNode.setProperty("analyticsEnabled", (Value)null);
                } else {
                    this.log.error("Unable to retrieve metadata node for the form : " + formPath);
                }
            } else {
                this.log.error("Unable to retrieve node at path : " + formPath);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{"Analytics", formPath};
            throw new FormsMgrException("AEM-FMG-700-025", args);
        }
    }

    private Iterator<Asset> getMembers(Asset asset, String relationName) {
        final Iterator<? extends Asset> members = asset.listRelated(relationName);
        return new Iterator<Asset>(){

            @Override
            public boolean hasNext() {
                return members.hasNext();
            }

            @Override
            public Asset next() {
                return ((Asset)members.next()).adaptTo(Asset.class);
            }

            @Override
            public void remove() {
                members.remove();
            }
        };
    }

    private Asset createUpdateFormset(ResourceResolver resolver, JSONObject formsetJSON) throws FormsMgrException {
        try {
            Asset asset;
            if (resolver == null) {
                this.log.error("resolver parameter in createUpdateFormset() function is null");
                Object[] args = new Object[]{"resolver", resolver};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (formsetJSON == null) {
                this.log.error("formsetJSON parameter in createUpdateFormset() function is null");
                Object[] args = new Object[]{"formsetJSON", formsetJSON};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            String errorMsg = new String();
            Session session = resolver.adaptTo(Session.class);
            if (!this.isValidFormsetInputParams(session, formsetJSON, errorMsg)) {
                this.log.error(errorMsg);
                Object[] args = new Object[]{"errorMsg", errorMsg};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            formsetJSON.put("assetType", "formset");
            JSONObject jcrContentPropertyJSON = new JSONObject();
            jcrContentPropertyJSON.put("sling:resourceType", "fd/fm/formset/render");
            formsetJSON.put("assetJcrProperties", jcrContentPropertyJSON);
            if (formsetJSON.has("metadataProperties")) {
                asset = this.createAsset(resolver, formsetJSON);
            } else {
                AssetManager assetManager = resolver.adaptTo(AssetManager.class);
                asset = assetManager.getAsset(formsetJSON.getString("path"));
                asset.removeRelation("forms");
            }
            ValueMap vm = asset.adaptTo(ValueMap.class);
            vm.put("jcr:lastModified", Calendar.getInstance());
            if (formsetJSON.has("formsetForms")) {
                JSONArray formReferenceJSONArray = formsetJSON.getJSONArray("formsetForms");
                for (int i = 0; i < formReferenceJSONArray.length(); ++i) {
                    String formPath = null;
                    JSONObject formReferenceJSON = formReferenceJSONArray.getJSONObject(i);
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    Iterator<String> jsonIterator = formReferenceJSON.keys();
                    while (jsonIterator.hasNext()) {
                        String propertyName = jsonIterator.next();
                        String propertyValue = formReferenceJSON.getString(propertyName);
                        if (propertyName.equals("formPath")) {
                            formPath = formReferenceJSON.getString("formPath");
                            continue;
                        }
                        props.put(propertyName, propertyValue);
                    }
                    asset.addRelation("forms", formPath, props);
                }
                resolver.commit();
                return asset;
            }
            throw new FormsMgrException("AEM-FMG-800-005");
        }
        catch (Exception e) {
            throw new FormsMgrException("AEM-FMG-800-006");
        }
    }

    private boolean isValidFormsetInputParams(Session session, JSONObject params, String errorMsg) throws FormsMgrException, RepositoryException {
        boolean returnVal = false;
        errorMsg = "Invalid Parameter : ";
        try {
            if (session == null) {
                this.log.error("session parameter in isValidThemeInputParams() function is null");
                Object[] args = new Object[]{"session", session};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (!params.has("path") || params.getString("path").isEmpty()) {
                errorMsg = errorMsg.concat("Formset path is missing");
            } else if (params.has("metadataProperties")) {
                String formsetPath = params.getString("path");
                int index = formsetPath.lastIndexOf("/");
                String nodeName = formsetPath.substring(index + 1);
                if (session.nodeExists(formsetPath)) {
                    this.log.error("Error as resource " + nodeName + " already exist at destination" + formsetPath);
                    Object[] args = new Object[]{nodeName, formsetPath};
                    throw new FormsMgrException("AEM-FMG-900-002", args);
                }
            }
            returnVal = true;
        }
        catch (JSONException e) {
            this.log.error("JSON Exception in isValidThemeInputParams() while validating input params for theme creation ", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-009");
        }
        return returnVal;
    }

    private String getTargetFragmentPath(ResourceResolver resolver, String panelPath, String targetPath, String fragName) throws FormsMgrException {
        try {
            Session session;
            if (targetPath == null || targetPath.isEmpty()) {
                Resource resource = FMUtils.getClosestNodeUpInHierarchy(resolver, panelPath, "jcr:primaryType", "cq:Page", false);
                if (resource == null) {
                    throw new FormsMgrException("AEM-FMG-700-001");
                }
                targetPath = resource.getPath();
                String assetPath = FMUtils.getAssetPathFromPage(targetPath);
                targetPath = assetPath.substring(0, assetPath.lastIndexOf("/"));
            }
            if ((session = resolver.adaptTo(Session.class)).nodeExists(targetPath + "/" + fragName)) {
                Object[] args = new Object[]{fragName, targetPath};
                throw new FormsMgrException("AEM-FMG-900-002", args);
            }
            return targetPath;
        }
        catch (RepositoryException e) {
            this.log.error("error while deducing target path to save Fragment ", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-007");
        }
    }

    @Override
    public void createTheme(ResourceResolver resolver, JSONObject themeJson) throws FormsMgrException {
        try {
            if (resolver == null) {
                this.log.error("resolver parameter in createTheme() function is null");
                Object[] args = new Object[]{"resolver", resolver};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (themeJson == null) {
                this.log.error("themeJson parameter in createTheme() function is null");
                Object[] args = new Object[]{"themeJson", themeJson};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            String errorMsg = new String();
            Session session = resolver.adaptTo(Session.class);
            if (!this.isValidThemeInputParams(session, themeJson, errorMsg)) {
                this.log.error(errorMsg);
                Object[] args = new Object[]{"errorMsg", errorMsg};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            themeJson.put("assetType", "theme");
            JSONObject jcrContentPropertyJSON = new JSONObject();
            jcrContentPropertyJSON.put("sling:resourceType", "fd/fm/theme/render");
            themeJson.put("assetJcrProperties", jcrContentPropertyJSON);
            Asset themeAsset = this.createAsset(resolver, themeJson);
            AssetManager assetManager = resolver.adaptTo(AssetManager.class);
            String defaultAFPath = GuideThemeUtils.getConfiguredFormPagePath(resolver, themeAsset.getChild("jcr:content").getPath());
            String afRenditionNodePath = defaultAFPath + "/" + "jcr:content/renditions";
            if (session.nodeExists(afRenditionNodePath)) {
                assetManager.copyAsset(afRenditionNodePath, themeAsset.getPath() + "/" + "jcr:content/renditions");
            }
            Node themeNode = session.getNode(themeAsset.getPath());
            Node renditionNode = FMUtils.getRenditionNode(themeNode, true);
            if (session.nodeExists("/libs/fd/af/themes/initialJSON")) {
                String destPath = renditionNode.getPath() + "/" + "original";
                assetManager.copyAsset("/libs/fd/af/themes/initialJSON", destPath);
                Node contentNode = session.getNode(destPath + "/" + "jcr:content");
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                contentNode.setProperty("jcr:lastModifiedBy", session.getUserID());
            }
            this.createClientLibFolderForTheme(session, assetManager, themeJson, themeAsset.getName());
            resolver.commit();
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Exception in createTheme while theme creation", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-009");
        }
    }

    private boolean isValidThemeInputParams(Session session, JSONObject params, String errorMsg) throws FormsMgrException, RepositoryException {
        boolean returnVal = false;
        errorMsg = "Invalid Parameter : ";
        try {
            if (session == null) {
                this.log.error("session parameter in isValidThemeInputParams() function is null");
                Object[] args = new Object[]{"session", session};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (!params.has("path") || params.getString("path").isEmpty()) {
                errorMsg = errorMsg.concat("Theme path is missing");
            } else if (!params.has("metadataProperties")) {
                errorMsg = errorMsg.concat("Theme metadata properties is missing");
            } else {
                JSONObject metadataProperties = new JSONObject(params.getString("metadataProperties"));
                if (!metadataProperties.has("clientlibRef") || metadataProperties.getString("clientlibRef").isEmpty()) {
                    errorMsg = errorMsg.concat("Theme clientlib location is missing");
                } else if (!metadataProperties.has("clientlibCategory") || metadataProperties.getString("clientlibCategory").isEmpty()) {
                    errorMsg = errorMsg.concat("Theme clientlib category name is missing");
                } else {
                    String themePath = params.getString("path");
                    int index = themePath.lastIndexOf("/");
                    String nodeName = themePath.substring(index + 1);
                    if (session.nodeExists(themePath)) {
                        this.log.error("Exception in isValidThemeInputParams() as resource" + nodeName + "already exist at destination" + themePath);
                        Object[] args = new Object[]{nodeName, themePath};
                        throw new FormsMgrException("AEM-FMG-900-002", args);
                    }
                    String clientLibLocation = params.getJSONObject("metadataProperties").getString("clientlibRef");
                    if (session.nodeExists(clientLibLocation + "/" + nodeName)) {
                        this.log.error("Exception in isValidThemeInputParams() as CQ Client Library folder" + nodeName + "already exists at " + clientLibLocation + " location");
                        Object[] args = new Object[]{nodeName, clientLibLocation};
                        throw new FormsMgrException("AEM-FMG-900-002", args);
                    }
                    returnVal = true;
                }
            }
        }
        catch (JSONException e) {
            this.log.error("JSON Exception in isValidThemeInputParams() while validating input params for theme creation ", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-009");
        }
        return returnVal;
    }

    private void createClientLibFolderForTheme(Session session, AssetManager assetManager, JSONObject params, String themeName) throws FormsMgrException {
        String clientLibLocation = "";
        try {
            JSONObject metadataPropertyJSON = params.getJSONObject("metadataProperties");
            clientLibLocation = metadataPropertyJSON.getString("clientlibRef");
            String clientLibCategoryName = metadataPropertyJSON.getString("clientlibCategory");
            Node rootNode = FMUtils.getFolderNode(session, clientLibLocation, true, "nt:folder");
            Node clientLibNode = rootNode.addNode(themeName, "cq:ClientLibraryFolder");
            clientLibNode.setProperty("categories", new String[]{clientLibCategoryName});
            clientLibNode.setProperty("guideComponentType", "fd/af/components/guideThemeClientLib");
            String cssFileName = "theme.css";
            Node cssFolderNode = clientLibNode.addNode("css", "nt:folder");
            assetManager.copyAsset("/etc/clientlibs/fd/af/guidetheme2/default/css/default.css", cssFolderNode.getPath() + "/" + cssFileName);
            Node cssTextFileNode = clientLibNode.addNode("css.txt", "nt:file");
            Node cssTextFileContentNode = cssTextFileNode.addNode("jcr:content", "nt:resource");
            cssTextFileContentNode.setProperty("jcr:mimeType", "text/css");
            String cssTextFileContent = "css/" + cssFileName;
            Binary binary = session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(cssTextFileContent.getBytes()));
            cssTextFileContentNode.setProperty("jcr:data", binary);
        }
        catch (Exception e) {
            this.log.error("Error while creating client library folder structure at location " + clientLibLocation, (Throwable)e);
            throw new FormsMgrException(e);
        }
    }

    @Override
    public boolean checkNodeExist(ResourceResolver resolver, String nodePath) throws FormsMgrException {
        Session session = resolver.adaptTo(Session.class);
        try {
            return session.nodeExists(nodePath);
        }
        catch (Exception e) {
            this.log.error("Exception in checkNodeExist() while checking Node Existence", (Throwable)e);
            throw new FormsMgrException(e);
        }
    }

    protected void bindPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    protected void unbindPublishService(PublishService publishService) {
        if (this.publishService == publishService) {
            this.publishService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

