/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.service.impl;

import com.adobe.aem.formsndocuments.service.FormsRelationService;
import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.forms.foundation.provider.DependencyProvider;
import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.forms.foundation.service.FormsFoundationException;
import com.adobe.forms.foundation.service.util.FormsFoundationUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
public class FMDependencyProviderImpl
implements DependencyProvider {
    private static final Logger logger = LoggerFactory.getLogger(FMDependencyProviderImpl.class);
    @Reference
    private FormsFoundationUtils formsFoundationUtils;
    @Reference
    private FormsRelationService formsRelationService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    public Map<FormsAssetType, Set<String>> getImmediateParentDependencies(String assetId) throws FormsFoundationException {
        HashMap<FormsAssetType, Set<String>> parentDeps = new HashMap<FormsAssetType, Set<String>>();
        try {
            if (assetId == null || assetId.isEmpty()) {
                Object[] obj = null;
                throw new FormsFoundationException("AEM-FF-002", obj);
            }
            ResourceResolver resolver = FMUtils.getResourceResolver(this.resourceResolverFactory, this.formsFoundationUtils.getCurrentSession());
            Set<AssetInfo> assetInfoSet = this.formsRelationService.getDependentParentFMAssets(resolver, assetId);
            this.processDependentParentAssets(assetInfoSet, parentDeps);
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (FormsMgrException e) {
            throw new FormsFoundationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new FormsFoundationException((Throwable)e);
        }
        return parentDeps;
    }

    public boolean hasParentDependencies(String assetId) throws FormsFoundationException {
        boolean hasParentDeps;
        try {
            if (assetId == null || assetId.isEmpty()) {
                Object[] obj = null;
                throw new FormsFoundationException("AEM-FF-002", obj);
            }
            ResourceResolver resolver = FMUtils.getResourceResolver(this.resourceResolverFactory, this.formsFoundationUtils.getCurrentSession());
            hasParentDeps = this.formsRelationService.hasDependentParentFMAssets(resolver, assetId);
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (FormsMgrException e) {
            throw new FormsFoundationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new FormsFoundationException((Throwable)e);
        }
        return hasParentDeps;
    }

    public Map<FormsAssetType, Set<String>> getDDEReferences(String dataDictionaryID, List<String> ddeReferenceNames) throws FormsFoundationException {
        try {
            if (dataDictionaryID == null || dataDictionaryID.isEmpty() || ddeReferenceNames == null || ddeReferenceNames.size() == 0) {
                Object[] obj = null;
                throw new FormsFoundationException("AEM-FF-002", obj);
            }
            HashMap<FormsAssetType, Set<String>> parentDeps = new HashMap<FormsAssetType, Set<String>>();
            Set<AssetInfo> assetInfoSet = this.formsRelationService.getDDEReferences(dataDictionaryID, ddeReferenceNames);
            this.processDependentParentAssets(assetInfoSet, parentDeps);
            return parentDeps;
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (FormsMgrException e) {
            throw new FormsFoundationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new FormsFoundationException((Throwable)e);
        }
    }

    public boolean hasDDEReferences(String dataDictionaryID, List<String> ddeReferenceNames) throws FormsFoundationException {
        try {
            if (dataDictionaryID == null || dataDictionaryID.isEmpty() || ddeReferenceNames == null || ddeReferenceNames.size() == 0) {
                Object[] obj = null;
                throw new FormsFoundationException("AEM-FF-002", obj);
            }
            return this.formsRelationService.hasDDEReferences(dataDictionaryID, ddeReferenceNames);
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (FormsMgrException e) {
            throw new FormsFoundationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new FormsFoundationException((Throwable)e);
        }
    }

    private void processDependentParentAssets(Set<AssetInfo> assetInfoSet, Map<FormsAssetType, Set<String>> parentDeps) throws FormsMgrException {
        if (assetInfoSet == null) {
            logger.debug("assetInfoSet should not be null in processDependentParentAssets() in FMDependencyProviderImpl");
            return;
        }
        for (AssetInfo assetInfo : assetInfoSet) {
            Resource resource = assetInfo.getResource();
            if (resource == null) continue;
            String path = resource.getPath();
            FormsAssetType assetType = FMUtils.getFormsFoundationAssetType(assetInfo.getType());
            this.addAssetToDependenciesList(parentDeps, assetType, path);
        }
    }

    private void addAssetToDependenciesList(Map<FormsAssetType, Set<String>> dependenciesMap, FormsAssetType assetType, String path) {
        if (path == null || path.isEmpty()) {
            logger.error("empty path cannot be added in addAssetToDependenciesList() in FMDependencyProviderImpl");
            return;
        }
        if (assetType == null) {
            logger.error("assetType cannot be null in addAssetToDependenciesList() in FMDependencyProviderImpl");
            return;
        }
        if (!dependenciesMap.containsKey(assetType)) {
            dependenciesMap.put(assetType, new HashSet());
        }
        dependenciesMap.get(assetType).add(path);
    }

    protected void bindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        this.formsFoundationUtils = formsFoundationUtils;
    }

    protected void unbindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        if (this.formsFoundationUtils == formsFoundationUtils) {
            this.formsFoundationUtils = null;
        }
    }

    protected void bindFormsRelationService(FormsRelationService formsRelationService) {
        this.formsRelationService = formsRelationService;
    }

    protected void unbindFormsRelationService(FormsRelationService formsRelationService) {
        if (this.formsRelationService == formsRelationService) {
            this.formsRelationService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

